/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.async;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.async.SyncModelContext;
import org.eclipse.uml2.diagram.common.async.SyncModelNode;

public class NewDiagramSyncHelper {
    private static final String TEMP_DIAGRAM_RESOURCE_URI = "uri://" + NewDiagramSyncHelper.class.getName() + "/diagram.xml";
    private final String myDiagramModelId;
    private SyncModelContext myContext;
    private Resource myTempDiagramResource;
    private EObject mySemanticRoot;
    private Diagram myTempDiagram;
    private SyncModelNode myRootSyncNode;
    private boolean myIsDisposed;

    public NewDiagramSyncHelper(SyncModelContext context, String diagramModelId) {
        this.myContext = context;
        this.myDiagramModelId = diagramModelId;
        this.myTempDiagramResource = context.getDomain().getResourceSet().createResource(URI.createURI((String)TEMP_DIAGRAM_RESOURCE_URI));
    }

    public void setSemanticRoot(EObject newRoot) {
        if (this.mySemanticRoot != newRoot) {
            if (this.mySemanticRoot != null) {
                this.unloadTempDiagram();
                this.myRootSyncNode = null;
            }
            this.loadTempDiagram(newRoot);
            final Diagram syncDiagram = ViewService.createDiagram((EObject)newRoot, (String)this.myDiagramModelId, (PreferencesHint)this.myContext.getPreferencesHint());
            this.myContext.runCommand(new Runnable(){

                public void run() {
                    NewDiagramSyncHelper.this.myContext.getSyncModelResource().getContents().clear();
                    NewDiagramSyncHelper.this.myContext.getSyncModelResource().getContents().add((Object)syncDiagram);
                }
            });
            this.myRootSyncNode = this.createRootNode(this.myContext, syncDiagram, this.myTempDiagram);
            this.mySemanticRoot = newRoot;
        }
    }

    protected SyncModelNode createRootNode(SyncModelContext context, Diagram syncDiagram, Diagram subjectDiagram) {
        return new SyncModelNode((View)syncDiagram, (View)this.myTempDiagram, context);
    }

    public Diagram getNewDiagram() {
        return this.myTempDiagram;
    }

    public SyncModelNode getSyncRoot() {
        return this.myRootSyncNode;
    }

    private void unloadTempDiagram() {
        if (this.myTempDiagram == null || this.myTempDiagramResource == null) {
            return;
        }
        this.myContext.runCommand(new Runnable(){

            public void run() {
                NewDiagramSyncHelper.this.myTempDiagramResource.getContents().remove((Object)NewDiagramSyncHelper.this.myTempDiagram);
                NewDiagramSyncHelper.this.myTempDiagram = null;
            }
        });
    }

    private void loadTempDiagram(final EObject semanticRoot) {
        if (this.myTempDiagram != null) {
            throw new IllegalStateException();
        }
        this.myContext.runCommand(new Runnable(){

            public void run() {
                NewDiagramSyncHelper.this.myTempDiagram = ViewService.createDiagram((EObject)semanticRoot, (String)NewDiagramSyncHelper.this.myDiagramModelId, (PreferencesHint)NewDiagramSyncHelper.this.myContext.getPreferencesHint());
                NewDiagramSyncHelper.this.myTempDiagramResource.getContents().add((Object)NewDiagramSyncHelper.this.myTempDiagram);
            }
        });
    }

    private void disposeTempDiagramResource() {
        if (this.myTempDiagramResource != null) {
            this.myTempDiagramResource.unload();
            this.myContext.getDomain().getResourceSet().getResources().remove((Object)this.myTempDiagramResource);
        }
    }

    public void dispose() {
        if (!this.myIsDisposed) {
            this.myIsDisposed = true;
            this.myContext.dispose();
            this.disposeTempDiagramResource();
            this.myContext = null;
            this.myTempDiagramResource = null;
            this.myTempDiagram = null;
            this.myRootSyncNode = null;
        }
    }
}

