/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.clazz.edit.policies;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredLayoutCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalConnectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Ratio;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.clazz.conventions.InterfaceNotationConvention;
import org.eclipse.uml2.diagram.clazz.links.UMLInterfaceLinkManager;
import org.eclipse.uml2.diagram.clazz.part.UMLDiagramUpdater;
import org.eclipse.uml2.diagram.clazz.part.UMLVisualIDRegistry;
import org.eclipse.uml2.diagram.common.async.ICanonicalHelper;
import org.eclipse.uml2.diagram.common.editpolicies.UpdateDescriptionRequest;
import org.eclipse.uml2.diagram.common.genapi.IUpdaterLinkDescriptor;
import org.eclipse.uml2.diagram.common.genapi.IUpdaterNodeDescriptor;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageCanonicalEditPolicy
extends CanonicalConnectionEditPolicy {
    Set myFeaturesToSynchronize;
    private final ICanonicalHelper myCanonicalHelper = ICanonicalHelper.IMPLEMENTATION;

    public void activate() {
        super.activate();
        this.addListenerFilter("NotationListener_Container" + this.getDiagram().toString(), (NotificationListener)this, (EObject)this.getDiagram(), (EStructuralFeature)NotationPackage.eINSTANCE.getView_PersistedChildren());
    }

    protected List getSemanticChildrenList() {
        View viewObject = (View)this.getHost().getModel();
        LinkedList<EObject> result = new LinkedList<EObject>();
        Iterator it = UMLDiagramUpdater.getSemanticChildren(viewObject).iterator();
        while (it.hasNext()) {
            result.add(((IUpdaterNodeDescriptor)it.next()).getModelElement());
        }
        return result;
    }

    protected boolean shouldDeleteViewGen(View view) {
        return true;
    }

    protected boolean shouldDeleteView(View view) {
        return this.shouldDeleteViewGen(view) || InterfaceNotationConvention.hasAlternativeNotation(view);
    }

    protected boolean isOrphaned(Collection semanticChildren, View view) {
        if (view.getEAnnotation("Shortcut") != null) {
            return UMLDiagramUpdater.isShortcutOrphaned(view);
        }
        int visualID = UMLVisualIDRegistry.getVisualID(view);
        int suggestedID = UMLVisualIDRegistry.getNodeVisualID((View)this.getHost().getModel(), view.getElement());
        switch (visualID) {
            case 3001: 
            case 3002: 
            case 3003: 
            case 3006: 
            case 3007: 
            case 3008: 
            case 3009: 
            case 3011: 
            case 3012: 
            case 3013: 
            case 3014: 
            case 3015: 
            case 3016: 
            case 3017: 
            case 3019: 
            case 3020: 
            case 3021: 
            case 3022: 
            case 3023: 
            case 3024: 
            case 3025: 
            case 3027: 
            case 3028: 
            case 3029: 
            case 3030: 
            case 3031: 
            case 3032: 
            case 3033: 
            case 3034: 
            case 3035: 
            case 3036: 
            case 3037: 
            case 3038: 
            case 3039: 
            case 3040: 
            case 3041: {
                return true;
            }
            case 2001: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: 
            case 2009: 
            case 2012: 
            case 2014: 
            case 2018: {
                if (semanticChildren.contains(view.getElement())) break;
                return true;
            }
            case 2002: {
                if (!semanticChildren.contains(view.getElement())) {
                    return true;
                }
                return visualID != suggestedID && suggestedID != 2016;
            }
            case 2007: {
                if (!semanticChildren.contains(view.getElement())) {
                    return true;
                }
                return visualID != suggestedID && suggestedID != 2015;
            }
            case 2010: {
                if (!semanticChildren.contains(view.getElement())) {
                    return true;
                }
                return visualID != suggestedID && suggestedID != 2013;
            }
            case 2008: {
                if (!semanticChildren.contains(view.getElement())) {
                    return true;
                }
                return visualID != suggestedID && suggestedID != 2017;
            }
            case 2013: {
                if (!semanticChildren.contains(view.getElement())) {
                    return true;
                }
                return visualID != suggestedID && suggestedID != 2010;
            }
            case 2015: {
                if (!semanticChildren.contains(view.getElement())) {
                    return true;
                }
                return visualID != suggestedID && suggestedID != 2007;
            }
            case 2016: {
                if (!semanticChildren.contains(view.getElement())) {
                    return true;
                }
                return visualID != suggestedID && suggestedID != 2002;
            }
            case 2017: {
                if (!semanticChildren.contains(view.getElement())) {
                    return true;
                }
                return visualID != suggestedID && suggestedID != 2008;
            }
        }
        return false;
    }

    private void populateViewProperties(View oldView, View newView) {
        if (oldView instanceof Node && newView instanceof Node) {
            Node oldNode = (Node)oldView;
            Node newNode = (Node)newView;
            if (oldNode.getLayoutConstraint() instanceof Location && newNode.getLayoutConstraint() instanceof Location) {
                ((Location)newNode.getLayoutConstraint()).setX(((Location)oldNode.getLayoutConstraint()).getX());
                ((Location)newNode.getLayoutConstraint()).setY(((Location)oldNode.getLayoutConstraint()).getY());
            }
            if (oldNode.getLayoutConstraint() instanceof Size && newNode.getLayoutConstraint() instanceof Size) {
                ((Size)newNode.getLayoutConstraint()).setWidth(((Size)oldNode.getLayoutConstraint()).getWidth());
                ((Size)newNode.getLayoutConstraint()).setHeight(((Size)oldNode.getLayoutConstraint()).getHeight());
            }
            if (oldNode.getLayoutConstraint() instanceof Ratio && newNode.getLayoutConstraint() instanceof Ratio) {
                ((Ratio)newNode.getLayoutConstraint()).setValue(((Ratio)oldNode.getLayoutConstraint()).getValue());
            }
            newNode.persist();
        }
    }

    protected String getDefaultFactoryHint() {
        return null;
    }

    protected Set getFeaturesToSynchronize() {
        if (this.myFeaturesToSynchronize == null) {
            this.myFeaturesToSynchronize = new HashSet();
            this.myFeaturesToSynchronize.add(UMLPackage.eINSTANCE.getPackage_PackagedElement());
            this.myFeaturesToSynchronize.add(UMLPackage.eINSTANCE.getComponent_PackagedElement());
            this.myFeaturesToSynchronize.add(UMLPackage.eINSTANCE.getElement_OwnedComment());
        }
        return this.myFeaturesToSynchronize;
    }

    protected List getSemanticConnectionsList() {
        return Collections.EMPTY_LIST;
    }

    protected EObject getSourceElement(EObject relationship) {
        return null;
    }

    protected EObject getTargetElement(EObject relationship) {
        return null;
    }

    protected boolean shouldIncludeConnection(Edge connector, Collection children) {
        return false;
    }

    protected void refreshSemantic() {
        LinkedList createdViews = new LinkedList();
        if (this.myCanonicalHelper.shouldSyncNodes(this.getNotationView())) {
            createdViews.addAll(this.refreshSemanticChildren());
        }
        LinkedList createdConnectionViews = new LinkedList();
        if (this.myCanonicalHelper.shouldSyncLinks(this.getNotationView())) {
            createdConnectionViews.addAll(this.refreshSemanticConnections());
            createdConnectionViews.addAll(this.refreshConnections());
        }
        if (createdViews.size() > 1) {
            DeferredLayoutCommand layoutCmd = new DeferredLayoutCommand(this.host().getEditingDomain(), createdViews, this.host());
            this.executeCommand((Command)new ICommandProxy((ICommand)layoutCmd));
        }
        createdViews.addAll(createdConnectionViews);
        this.makeViewsImmutable(createdViews);
    }

    private Collection refreshConnections() {
        Domain2Notation domain2NotationMap = new Domain2Notation();
        Collection linkDescriptors = this.collectAllLinks((View)this.getDiagram(), domain2NotationMap);
        LinkedList existingLinks = new LinkedList(this.getDiagram().getEdges());
        Iterator linksIterator = existingLinks.iterator();
        while (linksIterator.hasNext()) {
            Edge nextDiagramLink = (Edge)linksIterator.next();
            int diagramLinkVisualID = UMLVisualIDRegistry.getVisualID((View)nextDiagramLink);
            if (diagramLinkVisualID == -1) {
                if (nextDiagramLink.getSource() == null || nextDiagramLink.getTarget() == null) continue;
                linksIterator.remove();
                continue;
            }
            if (this.isNotationOnlyEdge(nextDiagramLink)) {
                linksIterator.remove();
                continue;
            }
            EObject diagramLinkObject = nextDiagramLink.getElement();
            EObject diagramLinkSrc = nextDiagramLink.getSource().getElement();
            EObject diagramLinkDst = nextDiagramLink.getTarget().getElement();
            boolean existingLinkRemoved = false;
            Iterator LinkDescriptorsIterator = linkDescriptors.iterator();
            while (LinkDescriptorsIterator.hasNext()) {
                IUpdaterLinkDescriptor nextLinkDescriptor = (IUpdaterLinkDescriptor)LinkDescriptorsIterator.next();
                if (diagramLinkObject != nextLinkDescriptor.getModelElement() || diagramLinkSrc != nextLinkDescriptor.getSource() || diagramLinkDst != nextLinkDescriptor.getDestination() || diagramLinkVisualID != nextLinkDescriptor.getVisualID()) continue;
                if (!existingLinkRemoved) {
                    linksIterator.remove();
                    existingLinkRemoved = true;
                }
                LinkDescriptorsIterator.remove();
            }
        }
        this.deleteViews(existingLinks.iterator());
        return this.createConnections(linkDescriptors, domain2NotationMap);
    }

    private Collection collectAllLinks(View view, Domain2Notation domain2NotationMap) {
        Collection result = this.collectAllLinksGen(view, domain2NotationMap);
        if (view instanceof Diagram) {
            result = new UMLInterfaceLinkManager(result).getFilteredLinkDescriptors();
        }
        return result;
    }

    private Collection collectAllLinksGen(View view, Domain2Notation domain2NotationMap) {
        if (UMLVisualIDRegistry.isShortcutDescendant(view)) {
            return this.collectLinksOutgoingFromShortcut(view, domain2NotationMap);
        }
        LinkedList result = new LinkedList();
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getPackage_1000ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2002: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getPackage_2002ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2001: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getClass_2001ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2007: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getAssociationClass_2007ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2004: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getDataType_2004ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2005: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getPrimitiveType_2005ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2003: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getEnumeration_2003ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2010: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getInterface_2010ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2006: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getConstraint_2006ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2008: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getInstanceSpecification_2008ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2009: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getDependency_2009ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2012: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getGeneralizationSet_2012ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2013: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getInterface_2013ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2014: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getPackage_2014ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2015: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getAssociationClass_2015ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2016: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getPackage_2016ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2017: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getInstanceSpecification_2017ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2018: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getComment_2018ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3006: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getPackage_3006ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3007: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getClass_3007ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3008: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getDataType_3008ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3009: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getPrimitiveType_3009ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3011: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getEnumeration_3011ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3012: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getAssociationClass_3012ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3041: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getInterface_3041ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3013: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getInstanceSpecification_3013ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3001: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getProperty_3001ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3002: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getOperation_3002ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3003: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getClass_3003ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3025: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getPort_3025ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3027: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getRedefinableTemplateSignature_3027ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3019: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getProperty_3019ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3020: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getOperation_3020ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3014: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getProperty_3014ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3015: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getOperation_3015ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3021: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getProperty_3021ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3022: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getOperation_3022ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3016: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getEnumerationLiteral_3016ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3023: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getProperty_3023ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3024: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getOperation_3024ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3017: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getSlot_3017ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3028: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getProperty_3028ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3029: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getOperation_3029ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3030: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getClass_3030ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3031: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getElementImport_3031ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3032: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getPackage_3032ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3033: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getClass_3033ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3034: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getEnumeration_3034ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3035: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getInstanceSpecification_3035ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3036: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getDataType_3036ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3037: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getPrimitiveType_3037ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3038: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getLiteralString_3038ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3039: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getLiteralInteger_3039ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3040: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getExpression_3040ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4001: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getGeneralization_4001ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4002: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getDependency_4002ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4003: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getProperty_4003ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4005: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getAssociation_4005ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4008: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getInterfaceRealization_4008ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4010: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getRealization_4010ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4011: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getGeneralization_4011ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4013: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getUsage_4013ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4014: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getAssociationClass_4014ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4015: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getSlot_4015ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4016: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(UMLDiagramUpdater.getTemplateBinding_4016ContainedLinks(view));
                }
                domain2NotationMap.put(view.getElement(), view);
            }
        }
        Iterator children = view.getChildren().iterator();
        while (children.hasNext()) {
            result.addAll(this.collectAllLinks((View)children.next(), domain2NotationMap));
        }
        Iterator edges = view.getSourceEdges().iterator();
        while (edges.hasNext()) {
            result.addAll(this.collectAllLinks((View)edges.next(), domain2NotationMap));
        }
        return result;
    }

    private Collection createConnections(Collection linkDescriptors, Domain2Notation domain2NotationMap) {
        LinkedList<IAdaptable> adapters = new LinkedList<IAdaptable>();
        for (IUpdaterLinkDescriptor nextLinkDescriptor : linkDescriptors) {
            EditPart sourceEditPart = this.getSourceEditPart(nextLinkDescriptor, domain2NotationMap);
            EditPart targetEditPart = this.getTargetEditPart(nextLinkDescriptor, domain2NotationMap);
            if (sourceEditPart == null || targetEditPart == null) continue;
            CreateConnectionViewRequest.ConnectionViewDescriptor descriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor(nextLinkDescriptor.getSemanticAdapter(), UMLVisualIDRegistry.getType(nextLinkDescriptor.getVisualID()), -1, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
            CreateConnectionViewRequest ccr = new CreateConnectionViewRequest(descriptor);
            ccr.setType((Object)"connection start");
            ccr.setSourceEditPart(sourceEditPart);
            sourceEditPart.getCommand((Request)ccr);
            ccr.setTargetEditPart(targetEditPart);
            ccr.setType((Object)"connection end");
            Command cmd = targetEditPart.getCommand((Request)ccr);
            if (cmd == null || !cmd.canExecute()) continue;
            this.executeCommand(cmd);
            IAdaptable viewAdapter = (IAdaptable)ccr.getNewObject();
            if (viewAdapter == null) continue;
            adapters.add(viewAdapter);
        }
        return adapters;
    }

    private EditPart getEditPart(EObject domainModelElement, Domain2Notation domain2NotationMap) {
        View view = domain2NotationMap.get(domainModelElement);
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    private EditPart getSourceEditPartGen(IUpdaterLinkDescriptor descriptor, Domain2Notation domain2NotationMap) {
        return this.getEditPart(descriptor.getSource(), domain2NotationMap);
    }

    private EditPart getSourceEditPart(IUpdaterLinkDescriptor descriptor, Domain2Notation domain2NotationMap) {
        if (4014 == descriptor.getVisualID()) {
            return this.getHintedEditPart(descriptor.getSource(), domain2NotationMap, 2007);
        }
        if (4003 == descriptor.getVisualID()) {
            return this.getHintedEditPart(descriptor.getSource(), domain2NotationMap, 2015);
        }
        return this.getSourceEditPartGen(descriptor, domain2NotationMap);
    }

    private EditPart getTargetEditPartGen(IUpdaterLinkDescriptor descriptor, Domain2Notation domain2NotationMap) {
        return this.getEditPart(descriptor.getDestination(), domain2NotationMap);
    }

    private EditPart getTargetEditPart(IUpdaterLinkDescriptor descriptor, Domain2Notation domain2NotationMap) {
        if (4014 == descriptor.getVisualID()) {
            return this.getHintedEditPart(descriptor.getDestination(), domain2NotationMap, 2015);
        }
        return this.getTargetEditPartGen(descriptor, domain2NotationMap);
    }

    protected final EditPart getHintedEditPart(EObject domainModelElement, Domain2Notation domain2NotationMap, int hintVisualId) {
        View view = domain2NotationMap.getHinted(domainModelElement, UMLVisualIDRegistry.getType(hintVisualId));
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    private boolean isNotationOnlyEdge(Edge edge) {
        return false;
    }

    private Collection<IUpdaterLinkDescriptor> collectLinksOutgoingFromShortcut(View view, Domain2Notation domain2NotationMap) {
        EditPart ep = (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        if (!(ep instanceof IGraphicalEditPart)) {
            return Collections.emptyList();
        }
        IGraphicalEditPart editPart = (IGraphicalEditPart)ep;
        UpdateDescriptionRequest request = new UpdateDescriptionRequest();
        editPart.getCommand((Request)request);
        HashSet<IUpdaterLinkDescriptor> linksToFromShortcuts = new HashSet<IUpdaterLinkDescriptor>();
        for (UpdateDescriptionRequest.Descriptor next : request.getDescriptions()) {
            linksToFromShortcuts.addAll(next.getContainedLinks());
            linksToFromShortcuts.addAll(next.getOutgoingLinks());
            if (next.getSemanticElement() == null) continue;
            domain2NotationMap.put(next.getSemanticElement(), next.getProvider().getNotationView());
        }
        return linksToFromShortcuts;
    }

    private View getNotationView() {
        return (View)this.getHost().getModel();
    }

    protected String getFactoryHint(IAdaptable elementAdapter) {
        EObject domainModelElment = (EObject)elementAdapter.getAdapter(EObject.class);
        View containerView = ((IGraphicalEditPart)this.getHost()).getNotationView();
        int hint = UMLVisualIDRegistry.getNodeVisualID(containerView, domainModelElment);
        return hint != -1 ? UMLVisualIDRegistry.getType(hint) : super.getFactoryHint(elementAdapter);
    }

    private Diagram getDiagram() {
        return ((View)this.getHost().getModel()).getDiagram();
    }

    private static class Domain2Notation {
        private final HashMap myMap = new HashMap();

        private Domain2Notation() {
        }

        public boolean containsDomainElement(EObject domainElement) {
            return this.myMap.containsKey(domainElement);
        }

        public boolean containsKey(EObject domainElement) {
            return this.containsDomainElement(domainElement);
        }

        public void put(EObject domainElement, View view) {
            Object viewOrList = this.myMap.get(domainElement);
            if (viewOrList instanceof View) {
                this.myMap.remove(domainElement);
                LinkedList<View> list = new LinkedList<View>();
                list.add((View)viewOrList);
                this.myMap.put(domainElement, list);
                list.add(view);
            } else if (viewOrList instanceof List) {
                ((List)viewOrList).add(view);
            } else {
                this.myMap.put(domainElement, view);
            }
        }

        public View get(EObject domainEObject) {
            Object viewOrList = this.myMap.get(domainEObject);
            if (viewOrList instanceof View) {
                return (View)viewOrList;
            }
            if (viewOrList instanceof List) {
                for (Object next : (List)viewOrList) {
                    View nextView = (View)next;
                    if (nextView.getEAnnotation("Shortcut") != null) continue;
                    return nextView;
                }
                return (View)((List)viewOrList).get(0);
            }
            return null;
        }

        public View getHinted(EObject domainEObject, String hint) {
            if (hint == null) {
                return this.get(domainEObject);
            }
            Object viewOrList = this.myMap.get(domainEObject);
            if (viewOrList instanceof View) {
                return (View)viewOrList;
            }
            if (viewOrList instanceof List) {
                for (Object next : (List)viewOrList) {
                    View nextView = (View)next;
                    if (!hint.equals(nextView.getType())) continue;
                    return nextView;
                }
                return (View)((List)viewOrList).get(0);
            }
            return null;
        }
    }
}

