/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.edit.commands;

import java.text.MessageFormat;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.editpolicies.U2TCreateLinkCommand;
import org.eclipse.uml2.diagram.common.editpolicies.U2TCreateParameters;
import org.eclipse.uml2.diagram.sequence.edit.commands.ThePastImpl;
import org.eclipse.uml2.diagram.sequence.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.diagram.sequence.model.SDModelAccess;
import org.eclipse.uml2.diagram.sequence.model.builder.SDBuilder;
import org.eclipse.uml2.diagram.sequence.model.sdnotation.SDModelStorageStyle;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDBehaviorSpec;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDExecution;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDInvocation;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDTrace;
import org.eclipse.uml2.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.uml2.diagram.sequence.providers.ElementInitializers;
import org.eclipse.uml2.uml.BehaviorExecutionSpecification;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageCreateCommand
extends EditElementCommand {
    private final EObject source;
    private final EObject target;
    private final Interaction container;

    public MessageCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.source = source;
        this.target = target;
        this.container = MessageCreateCommand.deduceContainer(source, target);
    }

    public boolean canExecute() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !this.isValidEnd(this.source)) {
            return false;
        }
        if (this.target != null && !this.isValidEnd(this.target)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        if (this.getContainer() == null) {
            return false;
        }
        if (this.source instanceof InteractionOperand && this.target instanceof InteractionOperand) {
            Lifeline targetLL;
            if (this.source != this.target) {
                return false;
            }
            U2TCreateLinkCommand linkCreationPack = U2TCreateLinkCommand.getFromRequest((IEditCommandRequest)this.getRequest());
            if (linkCreationPack == null || linkCreationPack.getSourceParameters() == null || linkCreationPack.getTargetParameters() == null) {
                return false;
            }
            Lifeline sourceLL = MessageCreateCommand.findEnclosedDiagramLifeLine(linkCreationPack.getSourceParameters().getParentView());
            if (sourceLL == (targetLL = MessageCreateCommand.findEnclosedDiagramLifeLine(linkCreationPack.getTargetParameters().getParentView()))) {
                return false;
            }
        }
        if (this.source == this.target) {
            return this.source instanceof InteractionOperand;
        }
        return UMLBaseItemSemanticEditPolicy.LinkConstraints.canCreateMessage_4001(this.getContainer(), this.getSource(), this.getTarget());
    }

    private BehaviorExecutionSpecification createBehaviorExecutionSpecification(Interaction interaction, Lifeline lifeline, int nameIndex, boolean forSource) {
        String prefix = forSource ? "invocation-" : "execution-";
        String withIndex = String.valueOf(prefix) + nameIndex + "-";
        ThePastImpl thePast = new ThePastImpl(U2TCreateLinkCommand.getFromRequest((IEditCommandRequest)this.getRequest()));
        ListIterator<InteractionFragment> listPosition = thePast.getAfterThePastPosition(interaction);
        MessageOccurrenceSpecification start = MessageCreateCommand.doCreateMessageOccurrence(listPosition, String.valueOf(withIndex) + "start");
        BehaviorExecutionSpecification result = MessageCreateCommand.doCreateBehaviorExecution(listPosition, String.valueOf(withIndex) + "body");
        MessageOccurrenceSpecification finish = MessageCreateCommand.doCreateMessageOccurrence(listPosition, String.valueOf(withIndex) + "finish");
        this.setupBehaviorSpec(result, start, finish, lifeline);
        return result;
    }

    private BehaviorExecutionSpecification[] createBehaviorExecutionSpecificationsPair(Interaction interaction, Lifeline sourceLL, Lifeline targetLL, int messageIndex, ListIterator<InteractionFragment> listPosition) {
        String invocationPrefix = "invocation-" + messageIndex + "-";
        String executionPrefix = "execution-" + messageIndex + "-";
        MessageOccurrenceSpecification invocationStart = MessageCreateCommand.doCreateMessageOccurrence(listPosition, String.valueOf(invocationPrefix) + "start");
        MessageOccurrenceSpecification executionStart = MessageCreateCommand.doCreateMessageOccurrence(listPosition, String.valueOf(executionPrefix) + "start");
        BehaviorExecutionSpecification invocation = MessageCreateCommand.doCreateBehaviorExecution(listPosition, String.valueOf(invocationPrefix) + "body");
        BehaviorExecutionSpecification execution = MessageCreateCommand.doCreateBehaviorExecution(listPosition, String.valueOf(executionPrefix) + "body");
        MessageOccurrenceSpecification executionFinish = MessageCreateCommand.doCreateMessageOccurrence(listPosition, String.valueOf(executionPrefix) + "finish");
        MessageOccurrenceSpecification invocationFinish = MessageCreateCommand.doCreateMessageOccurrence(listPosition, String.valueOf(invocationPrefix) + "finish");
        this.setupBehaviorSpec(invocation, invocationStart, invocationFinish, sourceLL);
        this.setupBehaviorSpec(execution, executionStart, executionFinish, targetLL);
        return new BehaviorExecutionSpecification[]{invocation, execution};
    }

    private void setupBehaviorSpec(BehaviorExecutionSpecification spec, MessageOccurrenceSpecification start, MessageOccurrenceSpecification finish, Lifeline lifeline) {
        this.setSingleCovered((InteractionFragment)spec, lifeline);
        this.setSingleCovered((InteractionFragment)start, lifeline);
        this.setSingleCovered((InteractionFragment)finish, lifeline);
        spec.setStart((OccurrenceSpecification)start);
        spec.setFinish((OccurrenceSpecification)finish);
    }

    private void setSingleCovered(InteractionFragment fragment, Lifeline lifeline) {
        if (!fragment.getCovereds().contains((Object)lifeline)) {
            fragment.getCovereds().add((Object)lifeline);
        }
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        BehaviorExecutionSpecification parentExecution;
        Gate domainTarget;
        Gate domainSource;
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        Interaction interaction = this.getContainer();
        int count = interaction.getMessages().size() + 1;
        Element diagramSource = this.getSource();
        Element diagramTarget = this.getTarget();
        BehaviorExecutionSpecification sourceInvocation = null;
        BehaviorExecutionSpecification targetExecution = null;
        if (diagramSource instanceof Gate && diagramTarget instanceof Lifeline) {
            domainSource = (Gate)diagramSource;
            targetExecution = this.createBehaviorExecutionSpecification(interaction, (Lifeline)diagramTarget, count, false);
            domainTarget = (MessageOccurrenceSpecification)targetExecution.getStart();
        } else if (diagramTarget instanceof Gate && diagramSource instanceof Lifeline) {
            domainTarget = (Gate)diagramTarget;
            sourceInvocation = this.createBehaviorExecutionSpecification(interaction, (Lifeline)diagramSource, count, true);
            domainSource = (MessageOccurrenceSpecification)sourceInvocation.getStart();
        } else if (diagramTarget instanceof Lifeline && diagramSource instanceof Lifeline) {
            Lifeline sourceLL = (Lifeline)diagramSource;
            Lifeline targetLL = (Lifeline)diagramTarget;
            ThePastImpl thePast = this.createThePast();
            ListIterator<InteractionFragment> position = thePast.getAfterThePastPosition(interaction);
            BehaviorExecutionSpecification[] pair = this.createBehaviorExecutionSpecificationsPair(interaction, sourceLL, targetLL, count, position);
            sourceInvocation = pair[0];
            targetExecution = pair[1];
            domainSource = (MessageOccurrenceSpecification)sourceInvocation.getStart();
            domainTarget = (MessageOccurrenceSpecification)targetExecution.getStart();
        } else if (diagramSource instanceof BehaviorExecutionSpecification && diagramTarget instanceof Lifeline) {
            parentExecution = (BehaviorExecutionSpecification)diagramSource;
            Lifeline sourceLL = (Lifeline)parentExecution.getCovereds().get(0);
            Lifeline targetLL = (Lifeline)diagramTarget;
            SDBuilder sdBuilder = new SDBuilder(sourceLL.getInteraction());
            SDBehaviorSpec sdExecution = sdBuilder.getSDModel().getUMLTracing().findBehaviorSpec((ExecutionSpecification)parentExecution);
            if (!(sdExecution instanceof SDExecution)) {
                throw new IllegalArgumentException("SDExecution expected: " + sdExecution);
            }
            ThePastImpl thePast = this.createThePast();
            thePast.executionStarted((SDExecution)sdExecution);
            ListIterator<InteractionFragment> position = thePast.getAfterThePastPosition(interaction);
            BehaviorExecutionSpecification[] pair = this.createBehaviorExecutionSpecificationsPair(interaction, sourceLL, targetLL, count, position);
            sourceInvocation = pair[0];
            targetExecution = pair[1];
            domainSource = (MessageOccurrenceSpecification)sourceInvocation.getStart();
            domainTarget = (MessageOccurrenceSpecification)targetExecution.getStart();
        } else if (diagramSource instanceof BehaviorExecutionSpecification && diagramTarget instanceof BehaviorExecutionSpecification) {
            parentExecution = (BehaviorExecutionSpecification)diagramSource;
            BehaviorExecutionSpecification diagramTargetImpl = (BehaviorExecutionSpecification)diagramTarget;
            Lifeline sourceLL = (Lifeline)parentExecution.getCovereds().get(0);
            Lifeline targetLL = (Lifeline)diagramTargetImpl.getCovereds().get(0);
            SDTrace sdTracing = new SDBuilder(sourceLL.getInteraction()).getSDModel().getUMLTracing();
            SDBehaviorSpec sdSourceExecution = sdTracing.findBehaviorSpec((ExecutionSpecification)parentExecution);
            if (!(sdSourceExecution instanceof SDExecution)) {
                throw new IllegalArgumentException("SDExecution expected as source: " + sdSourceExecution);
            }
            SDBehaviorSpec sdTargetInvocation = sdTracing.findBehaviorSpec((ExecutionSpecification)diagramTargetImpl);
            if (!(sdTargetInvocation instanceof SDInvocation)) {
                throw new IllegalArgumentException("SDInvocation expected as target: " + sdSourceExecution);
            }
            ThePastImpl thePast = this.createThePast();
            thePast.executionStarted((SDExecution)sdSourceExecution);
            ListIterator<InteractionFragment> position = thePast.getAfterThePastPosition(interaction);
            BehaviorExecutionSpecification[] pair = this.createBehaviorExecutionSpecificationsPair(interaction, sourceLL, targetLL, count, position);
            sourceInvocation = pair[0];
            targetExecution = pair[1];
            domainSource = (MessageOccurrenceSpecification)sourceInvocation.getStart();
            domainTarget = (MessageOccurrenceSpecification)targetExecution.getStart();
        } else if (diagramSource instanceof InteractionOperand && diagramTarget == diagramSource) {
            InteractionOperand operand = (InteractionOperand)diagramSource;
            U2TCreateLinkCommand linkCreationPack = U2TCreateLinkCommand.getFromRequest((IEditCommandRequest)this.getRequest());
            if (linkCreationPack == null || linkCreationPack.getSourceParameters() == null || linkCreationPack.getTargetParameters() == null) {
                throw new UnsupportedOperationException("I need extended creation parameters");
            }
            Lifeline sourceLL = MessageCreateCommand.findEnclosedDiagramLifeLine(linkCreationPack.getSourceParameters().getParentView());
            Lifeline targetLL = MessageCreateCommand.findEnclosedDiagramLifeLine(linkCreationPack.getTargetParameters().getParentView());
            ThePastImpl thePast = this.createThePast();
            ListIterator position = thePast.getAfterThePastPosition((List)operand.getFragments());
            BehaviorExecutionSpecification[] pair = this.createBehaviorExecutionSpecificationsPair(interaction, sourceLL, targetLL, count, position);
            sourceInvocation = pair[0];
            targetExecution = pair[1];
            domainSource = (MessageOccurrenceSpecification)sourceInvocation.getStart();
            domainTarget = (MessageOccurrenceSpecification)targetExecution.getStart();
        } else {
            throw new UnsupportedOperationException("Message between this elements can't be created: from: " + this.getSource() + " to: " + this.getTarget());
        }
        Message newElement = null;
        if (domainSource != null && domainTarget != null) {
            newElement = interaction.createMessage("");
            interaction.getMessages().add((Object)newElement);
            newElement.setSendEvent((MessageEnd)domainSource);
            newElement.setReceiveEvent((MessageEnd)domainTarget);
            domainSource.setMessage(newElement);
            domainTarget.setMessage(newElement);
        }
        ElementInitializers.init_Message_4001(newElement);
        this.doConfigure(newElement, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newElement);
        this.createAdditionalViews(sourceInvocation, targetExecution, newElement);
        return CommandResult.newOKCommandResult((Object)newElement);
    }

    private static Lifeline findEnclosedDiagramLifeLine(View view) {
        if (view instanceof Diagram) {
            return null;
        }
        if (!view.isSetElement()) {
            return null;
        }
        if (view.getElement() instanceof Lifeline) {
            return (Lifeline)view.getElement();
        }
        EObject container = view.eContainer();
        if (!(container instanceof View)) {
            return null;
        }
        return MessageCreateCommand.findEnclosedDiagramLifeLine((View)container);
    }

    private View createBehaviorExecutionView(View sourceView, EObject behaviorExecution, int position, Point relativeLocation) {
        int visualID = UMLVisualIDRegistry.getNodeVisualID(sourceView, behaviorExecution);
        Node result = ViewService.getInstance().createNode((IAdaptable)new EObjectAdapter(behaviorExecution), sourceView, UMLVisualIDRegistry.getType(visualID), position, UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        if (relativeLocation != null) {
            if (result.getLayoutConstraint() == null) {
                result.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
            }
            ViewUtil.setStructuralFeatureValue((View)result, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)relativeLocation.y);
            ViewUtil.setStructuralFeatureValue((View)result, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)10);
        }
        return result;
    }

    private View createBehaviorExecutionView(U2TCreateParameters createParams, EObject behaviorExecution, int position) {
        return this.createBehaviorExecutionView(createParams.getParentView(), behaviorExecution, position, createParams.getRelativeLocation());
    }

    private void createAdditionalViews(BehaviorExecutionSpecification sourceInvocation, BehaviorExecutionSpecification targetExecution, Message message) {
        if (message == null) {
            return;
        }
        U2TCreateLinkCommand linkCreationPack = U2TCreateLinkCommand.getFromRequest((IEditCommandRequest)this.getRequest());
        if (linkCreationPack == null || linkCreationPack.getSourceParameters() == null || linkCreationPack.getTargetParameters() == null) {
            return;
        }
        SDModelStorageStyle sdModelAccessor = SDModelAccess.findSDModelAccessor(linkCreationPack.getSourceParameters().getParentView());
        if (sdModelAccessor != null) {
            sdModelAccessor.invalidateModel();
        }
        assert (sourceInvocation == null || message.getSendEvent() == sourceInvocation.getStart());
        assert (targetExecution == null || message.getReceiveEvent() == targetExecution.getStart());
        View invocationView = null;
        if (sourceInvocation != null) {
            if (message.getSendEvent() != sourceInvocation.getStart()) {
                throw new IllegalStateException(MessageFormat.format("Invocation: {0}, \n start: {1}, message: {2}, sendEvent {3}", sourceInvocation, sourceInvocation.getStart(), message, message.getSendEvent()));
            }
            U2TCreateParameters sourceParams = linkCreationPack.getSourceParameters();
            int sourceViewIndex = this.findAnchoredViewPosition(sourceParams);
            invocationView = this.createBehaviorExecutionView(sourceParams, (EObject)sourceInvocation, sourceViewIndex);
            linkCreationPack.getSetConnectionEndsCommand().setNewSourceAdaptor((IAdaptable)new EObjectAdapter((EObject)invocationView));
        }
        if (targetExecution != null) {
            View executionView;
            if (message.getReceiveEvent() != targetExecution.getStart()) {
                throw new IllegalStateException(MessageFormat.format("Execution: {0}, \n start: {1}, message: {2}, receiveEvent {3}", targetExecution, targetExecution.getStart(), message, message.getReceiveEvent()));
            }
            U2TCreateParameters targetParams = linkCreationPack.getTargetParameters();
            if (sourceInvocation.getCovereds().get(0) == targetExecution.getCovereds().get(0)) {
                executionView = this.createBehaviorExecutionView(invocationView, (EObject)targetExecution, -1, new Point(10, 10));
            } else {
                int targetViewIndex = this.findAnchoredViewPosition(targetParams);
                executionView = this.createBehaviorExecutionView(targetParams, (EObject)targetExecution, targetViewIndex);
            }
            linkCreationPack.getSetConnectionEndsCommand().setNewTargetAdaptor((IAdaptable)new EObjectAdapter((EObject)executionView));
        }
    }

    protected void doConfigure(Message newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        configureRequest.setParameter("CreateRelationshipRequest.source", (Object)this.getSource());
        configureRequest.setParameter("CreateRelationshipRequest.target", (Object)this.getTarget());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }

    protected void setElementToEdit(EObject element) {
        throw new UnsupportedOperationException();
    }

    protected Element getSource() {
        return (Element)this.source;
    }

    protected Element getTarget() {
        return (Element)this.target;
    }

    public Interaction getContainer() {
        return this.container;
    }

    private static Interaction deduceContainer(EObject source, EObject target) {
        EObject element = source;
        while (element != null) {
            if (element instanceof Interaction) {
                return (Interaction)element;
            }
            element = element.eContainer();
        }
        return null;
    }

    private boolean isValidEnd(EObject diagramEnd) {
        if (diagramEnd instanceof Gate) {
            return true;
        }
        if (diagramEnd instanceof Lifeline) {
            return true;
        }
        if (diagramEnd instanceof BehaviorExecutionSpecification) {
            return ((BehaviorExecutionSpecification)diagramEnd).getCovereds().size() == 1;
        }
        return diagramEnd instanceof InteractionOperand;
    }

    private static MessageOccurrenceSpecification doCreateMessageOccurrence(ListIterator<InteractionFragment> position, String name) {
        MessageOccurrenceSpecification result = UMLFactory.eINSTANCE.createMessageOccurrenceSpecification();
        if (name != null) {
            result.setName(name);
        }
        position.add((InteractionFragment)result);
        return result;
    }

    private static BehaviorExecutionSpecification doCreateBehaviorExecution(ListIterator<InteractionFragment> position, String name) {
        BehaviorExecutionSpecification result = UMLFactory.eINSTANCE.createBehaviorExecutionSpecification();
        if (name != null) {
            result.setName(name);
        }
        position.add((InteractionFragment)result);
        return result;
    }

    private int findAnchoredViewPosition(U2TCreateParameters sourceParams) {
        int viewPosition = -1;
        if (sourceParams.getAnchorSibling() != null) {
            View anchor = sourceParams.getAnchorSibling();
            int anchorPos = sourceParams.getParentView().getChildren().indexOf((Object)anchor);
            if (anchorPos > 0) {
                viewPosition = anchorPos;
                if (!sourceParams.isBeforeNotAfterAnchor()) {
                    ++viewPosition;
                }
            }
        }
        return viewPosition;
    }

    private ThePastImpl createThePast() {
        return new ThePastImpl(U2TCreateLinkCommand.getFromRequest((IEditCommandRequest)this.getRequest()));
    }
}

