/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.internal;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.ecore.internal.OCLEcorePlugin;
import org.eclipse.ocl.ecore.internal.OCLFactoryImpl;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.utilities.PredefinedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OCLStandardLibraryImpl
implements OCLStandardLibrary<EClassifier> {
    private static final String NS_URI = "http://www.eclipse.org/ocl/1.1.0/oclstdlib.ecore";
    private static EClassifier OCL_ANY;
    private static EClassifier OCL_ELEMENT;
    private static EClassifier OCL_BOOLEAN;
    private static EClassifier OCL_INTEGER;
    private static EClassifier OCL_UNLIMITED_NATURAL;
    private static EClassifier OCL_REAL;
    private static EClassifier OCL_STRING;
    private static EClassifier OCL_VOID;
    private static EClassifier OCL_MESSAGE;
    private static EClassifier OCL_TYPE;
    private static EClassifier INVALID;
    private static EClassifier OCL_T;
    private static EClassifier OCL_T2;
    private static EClassifier OCL_SET;
    private static EClassifier OCL_ORDERED_SET;
    private static EClassifier OCL_BAG;
    private static EClassifier OCL_SEQUENCE;
    private static EClassifier OCL_COLLECTION;
    private static EClassifier STATE;
    private static EClassifier OCL_EXPRESSION;
    public static final OCLStandardLibraryImpl INSTANCE;
    public static EPackage stdlibPackage;
    public static final EObject OCL_INVALID;

    static {
        INSTANCE = new OCLStandardLibraryImpl();
        stdlibPackage = OCLStandardLibraryImpl.init();
        OCL_INVALID = stdlibPackage.getEFactoryInstance().create((EClass)stdlibPackage.getEClassifier("Invalid_Class"));
    }

    private OCLStandardLibraryImpl() {
    }

    public EClassifier getBoolean() {
        return OCL_BOOLEAN;
    }

    public EClassifier getInteger() {
        return OCL_INTEGER;
    }

    public EClassifier getUnlimitedNatural() {
        return OCL_UNLIMITED_NATURAL;
    }

    public EClassifier getInvalid() {
        return INVALID;
    }

    public EClassifier getReal() {
        return OCL_REAL;
    }

    public EClassifier getString() {
        return OCL_STRING;
    }

    public EClassifier getOclAny() {
        return OCL_ANY;
    }

    public EClassifier getOclElement() {
        return OCL_ELEMENT;
    }

    public Object getOclInvalid() {
        return OCL_INVALID;
    }

    public EClassifier getState() {
        return STATE;
    }

    public EClassifier getOclMessage() {
        return OCL_MESSAGE;
    }

    public EClassifier getOclType() {
        return OCL_TYPE;
    }

    public EClassifier getOclVoid() {
        return OCL_VOID;
    }

    public EClassifier getT() {
        return OCL_T;
    }

    public EClassifier getT2() {
        return OCL_T2;
    }

    public EClassifier getSet() {
        return OCL_SET;
    }

    public EClassifier getOrderedSet() {
        return OCL_ORDERED_SET;
    }

    public EClassifier getBag() {
        return OCL_BAG;
    }

    public EClassifier getSequence() {
        return OCL_SEQUENCE;
    }

    public EClassifier getCollection() {
        return OCL_COLLECTION;
    }

    public EClassifier getOclExpression() {
        return OCL_EXPRESSION;
    }

    private static EPackage init() {
        EPackage ePackage;
        block6: {
            if (stdlibPackage != null) {
                return stdlibPackage;
            }
            ResourceSetImpl rset = new ResourceSetImpl();
            Resource res = null;
            try {
                Resource load = rset.getResource(URI.createURI((String)NS_URI), true);
                res = OCLEcorePlugin.getEcoreResourceFactory().createResource(load.getURI());
                res.getContents().addAll((Collection)load.getContents());
                stdlibPackage = (EPackage)res.getContents().get(0);
                OCL_ANY = stdlibPackage.getEClassifier("OclAny");
                OCL_ELEMENT = stdlibPackage.getEClassifier("OclElement");
                OCL_BOOLEAN = stdlibPackage.getEClassifier("Boolean");
                OCL_INTEGER = stdlibPackage.getEClassifier("Integer");
                OCL_UNLIMITED_NATURAL = stdlibPackage.getEClassifier("UnlimitedNatural");
                OCL_REAL = stdlibPackage.getEClassifier("Real");
                OCL_STRING = stdlibPackage.getEClassifier("String");
                OCL_VOID = stdlibPackage.getEClassifier("OclVoid");
                OCL_MESSAGE = stdlibPackage.getEClassifier("OclMessage");
                INVALID = stdlibPackage.getEClassifier("Invalid");
                OCL_T = stdlibPackage.getEClassifier("T");
                OCL_T2 = stdlibPackage.getEClassifier("T2");
                OCL_TYPE = (EClassifier)EcoreUtil.getObjectByType((Collection)stdlibPackage.getEClassifiers(), (EClassifier)EcorePackage.Literals.TYPE_TYPE);
                OCL_SET = (EClassifier)EcoreUtil.getObjectByType((Collection)stdlibPackage.getEClassifiers(), (EClassifier)EcorePackage.Literals.SET_TYPE);
                OCL_ORDERED_SET = (EClassifier)EcoreUtil.getObjectByType((Collection)stdlibPackage.getEClassifiers(), (EClassifier)EcorePackage.Literals.ORDERED_SET_TYPE);
                OCL_BAG = (EClassifier)EcoreUtil.getObjectByType((Collection)stdlibPackage.getEClassifiers(), (EClassifier)EcorePackage.Literals.BAG_TYPE);
                OCL_SEQUENCE = (EClassifier)EcoreUtil.getObjectByType((Collection)stdlibPackage.getEClassifiers(), (EClassifier)EcorePackage.Literals.SEQUENCE_TYPE);
                OCL_COLLECTION = stdlibPackage.getEClassifier("Collection(T)");
                STATE = stdlibPackage.getEClassifier("State");
                OCL_EXPRESSION = stdlibPackage.getEClassifier("OclExpression");
                EPackage.Registry.INSTANCE.put((Object)stdlibPackage.getNsURI(), (Object)stdlibPackage);
                ePackage = stdlibPackage;
                if (res == null) break block6;
            }
            catch (Exception exception) {
                EPackage ePackage2;
                block7: {
                    try {
                        ePackage2 = OCLStandardLibraryImpl.build();
                        if (res == null) break block7;
                    }
                    catch (Throwable throwable) {
                        if (res != null) {
                            rset.getResources().remove(res);
                        }
                        throw throwable;
                    }
                    rset.getResources().remove((Object)res);
                }
                return ePackage2;
            }
            rset.getResources().remove((Object)res);
        }
        return ePackage;
    }

    private static EPackage build() {
        if (stdlibPackage != null) {
            return stdlibPackage;
        }
        Environment old = Environment.Registry.INSTANCE.getEnvironmentFor((Object)EcorePackage.Literals.ANY_TYPE);
        stdlibPackage = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEPackage();
        stdlibPackage.setName("oclstdlib");
        stdlibPackage.setNsPrefix("oclstdlib");
        stdlibPackage.setNsURI(NS_URI);
        Resource.Factory factory = OCLEcorePlugin.getEcoreResourceFactory();
        Resource res = factory.createResource(URI.createURI((String)stdlibPackage.getNsURI()));
        res.getContents().add((Object)stdlibPackage);
        Environment.Registry.INSTANCE.deregisterEnvironment(old);
        EcoreEnvironment env = (EcoreEnvironment)EcoreEnvironmentFactory.INSTANCE.loadEnvironment(res);
        Environment.Registry.INSTANCE.registerEnvironment((Environment)env);
        OCL_ANY = EcoreFactory.eINSTANCE.createAnyType();
        OCL_ELEMENT = EcoreFactory.eINSTANCE.createElementType();
        OCL_BOOLEAN = EcoreFactory.eINSTANCE.createPrimitiveType();
        OCL_BOOLEAN.setName("Boolean");
        OCL_INTEGER = EcoreFactory.eINSTANCE.createPrimitiveType();
        OCL_INTEGER.setName("Integer");
        OCL_UNLIMITED_NATURAL = EcoreFactory.eINSTANCE.createPrimitiveType();
        OCL_UNLIMITED_NATURAL.setName("UnlimitedNatural");
        OCL_REAL = EcoreFactory.eINSTANCE.createPrimitiveType();
        OCL_REAL.setName("Real");
        OCL_STRING = EcoreFactory.eINSTANCE.createPrimitiveType();
        OCL_STRING.setName("String");
        OCL_VOID = EcoreFactory.eINSTANCE.createVoidType();
        OCL_MESSAGE = EcoreFactory.eINSTANCE.createMessageType();
        INVALID = EcoreFactory.eINSTANCE.createInvalidType();
        OCL_T = EcoreFactory.eINSTANCE.createAnyType();
        OCL_T.setName("T");
        OCL_T2 = EcoreFactory.eINSTANCE.createAnyType();
        OCL_T2.setName("T2");
        OCL_TYPE = (EClassifier)OCLFactoryImpl.INSTANCE.createTypeType((Object)OCL_T);
        OCL_SET = (EClassifier)OCLFactoryImpl.INSTANCE.createSetType((Object)OCL_T);
        OCL_ORDERED_SET = (EClassifier)OCLFactoryImpl.INSTANCE.createOrderedSetType((Object)OCL_T);
        OCL_BAG = (EClassifier)OCLFactoryImpl.INSTANCE.createBagType((Object)OCL_T);
        OCL_SEQUENCE = (EClassifier)OCLFactoryImpl.INSTANCE.createSequenceType((Object)OCL_T);
        OCL_COLLECTION = (EClassifier)OCLFactoryImpl.INSTANCE.createCollectionType((Object)OCL_T);
        STATE = EcoreFactory.eINSTANCE.createElementType();
        STATE.setName("State");
        OCL_EXPRESSION = EcoreFactory.eINSTANCE.createElementType();
        OCL_EXPRESSION.setName("OclExpression");
        OCL_BOOLEAN.setInstanceClass(Boolean.class);
        OCL_STRING.setInstanceClass(String.class);
        OCL_INTEGER.setInstanceClass(Integer.class);
        OCL_REAL.setInstanceClass(Double.class);
        OCLStandardLibraryImpl.register(OCL_ANY).getEOperations().addAll((Collection)OCLStandardLibraryUtil.createAnyTypeOperations((Environment)env));
        OCLStandardLibraryImpl.register(OCL_VOID).getEOperations().addAll((Collection)OCLStandardLibraryUtil.createAnyTypeOperations((Environment)env));
        OCLStandardLibraryImpl.register(INVALID).getEOperations().addAll((Collection)OCLStandardLibraryUtil.createAnyTypeOperations((Environment)env));
        OCLStandardLibraryImpl.register(OCL_BOOLEAN).getEOperations().addAll((Collection)OCLStandardLibraryUtil.createBooleanOperations((Environment)env));
        OCLStandardLibraryImpl.register(OCL_INTEGER).getEOperations().addAll((Collection)OCLStandardLibraryUtil.createIntegerOperations((Environment)env));
        OCLStandardLibraryImpl.register(OCL_UNLIMITED_NATURAL).getEOperations().addAll((Collection)OCLStandardLibraryUtil.createUnlimitedNaturalOperations((Environment)env));
        OCLStandardLibraryImpl.register(OCL_REAL).getEOperations().addAll((Collection)OCLStandardLibraryUtil.createRealOperations((Environment)env));
        OCLStandardLibraryImpl.register(OCL_STRING).getEOperations().addAll((Collection)OCLStandardLibraryUtil.createStringOperations((Environment)env));
        OCLStandardLibraryImpl.register(OCL_TYPE).getEOperations().addAll((Collection)OCLStandardLibraryUtil.createTypeTypeOperations((Environment)env));
        OCLStandardLibraryImpl.register(OCL_MESSAGE).getEOperations().addAll((Collection)OCLStandardLibraryUtil.createMessageTypeOperations((Environment)env));
        OCLStandardLibraryImpl.register(OCL_ELEMENT);
        OCLStandardLibraryImpl.register(STATE);
        OCLStandardLibraryImpl.register(OCL_EXPRESSION);
        EList operations = OCLStandardLibraryImpl.register(OCL_COLLECTION).getEOperations();
        operations.addAll(OCLStandardLibraryUtil.createCollectionOperations((Environment)env));
        List iterators = OCLStandardLibraryUtil.createCollectionIterators((Environment)env);
        OCLStandardLibraryImpl.stereotypeAsIterator(iterators);
        operations.addAll(iterators);
        operations = OCLStandardLibraryImpl.register(OCL_SET).getEOperations();
        operations.addAll(OCLStandardLibraryUtil.createSetOperations((Environment)env));
        iterators = OCLStandardLibraryUtil.createSetIterators((Environment)env);
        OCLStandardLibraryImpl.stereotypeAsIterator(iterators);
        operations.addAll(iterators);
        operations = OCLStandardLibraryImpl.register(OCL_ORDERED_SET).getEOperations();
        operations.addAll(OCLStandardLibraryUtil.createOrderedSetOperations((Environment)env));
        iterators = OCLStandardLibraryUtil.createOrderedSetIterators((Environment)env);
        OCLStandardLibraryImpl.stereotypeAsIterator(iterators);
        operations.addAll(iterators);
        operations = OCLStandardLibraryImpl.register(OCL_BAG).getEOperations();
        operations.addAll(OCLStandardLibraryUtil.createBagOperations((Environment)env));
        iterators = OCLStandardLibraryUtil.createBagIterators((Environment)env);
        OCLStandardLibraryImpl.stereotypeAsIterator(iterators);
        operations.addAll(iterators);
        operations = OCLStandardLibraryImpl.register(OCL_SEQUENCE).getEOperations();
        operations.addAll(OCLStandardLibraryUtil.createSequenceOperations((Environment)env));
        iterators = OCLStandardLibraryUtil.createSequenceIterators((Environment)env);
        OCLStandardLibraryImpl.stereotypeAsIterator(iterators);
        operations.addAll(iterators);
        OCLStandardLibraryImpl.register(OCL_T);
        OCLStandardLibraryImpl.register(OCL_T2);
        EPackage.Registry.INSTANCE.put((Object)stdlibPackage.getNsURI(), (Object)stdlibPackage);
        Environment.Registry.INSTANCE.registerEnvironment(old);
        return stdlibPackage;
    }

    private static EClass register(EClassifier stdType) {
        EClass result = stdType instanceof EClass ? (EClass)stdType : null;
        stdlibPackage.getEClassifiers().add((Object)stdType);
        if (stdType instanceof PredefinedType && !(stdType instanceof EClass)) {
            result = OCLStandardLibraryImpl.createShadowClass(stdType);
            stdlibPackage.getEClassifiers().add((Object)result);
        }
        return result;
    }

    public static EClassifier getOwner(EOperation operation) {
        EClassifier shadowed;
        EClass ownerClass;
        EClass result = ownerClass = operation.getEContainingClass();
        if (ownerClass != null && (shadowed = OCLStandardLibraryImpl.getRealClassifier(ownerClass)) != null) {
            result = shadowed;
        }
        return result;
    }

    public static EClassifier getOwner(EStructuralFeature property) {
        EClassifier shadowed;
        EClass ownerClass;
        EClass result = ownerClass = property.getEContainingClass();
        if (ownerClass != null && (shadowed = OCLStandardLibraryImpl.getRealClassifier(ownerClass)) != null) {
            result = shadowed;
        }
        return result;
    }

    public static EClass createShadowClass(EClassifier classifier) {
        EClass result = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEClass();
        result.setName(String.valueOf(classifier.getName()) + "_Class");
        EAnnotation ann = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEAnnotation();
        ann.setSource("http://www.eclipse.org/ocl/1.1.0/OCL");
        ann.getReferences().add((Object)classifier);
        result.getEAnnotations().add((Object)ann);
        return result;
    }

    public static EClass findShadowClass(EClassifier classifier, EPackage pkg) {
        for (EClassifier next : pkg.getEClassifiers()) {
            EClass eclass;
            EAnnotation ann;
            if (!(next instanceof EClass) || (ann = (eclass = (EClass)next).getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL")) == null || !ann.getReferences().contains((Object)classifier)) continue;
            return eclass;
        }
        return null;
    }

    public static EClassifier getRealClassifier(EClass shadowClass) {
        EClassifier result = null;
        EAnnotation ann = shadowClass.getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL");
        if (ann != null && !ann.getReferences().isEmpty()) {
            result = (EClassifier)ann.getReferences().get(0);
        }
        return result;
    }

    public static EList<EOperation> getExistingOperations(EClassifier type) {
        EList result = null;
        if (type instanceof EClass) {
            result = ((EClass)type).getEOperations();
        } else {
            EClass shadow;
            EPackage pkg = type.getEPackage();
            if (pkg != null && (shadow = OCLStandardLibraryImpl.findShadowClass(type, pkg)) != null) {
                result = shadow.getEOperations();
            }
        }
        return result == null ? ECollections.emptyEList() : result;
    }

    public static void stereotypeAsIterator(Collection<EOperation> operations) {
        for (EOperation oper : operations) {
            EAnnotation ann = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEAnnotation();
            ann.setSource("http://www.eclipse.org/ocl/1.1.0/OCL");
            ann.getDetails().put((Object)"keywords", (Object)"iterator");
            oper.getEAnnotations().add((Object)ann);
        }
    }

    public static EList<EOperation> selectIterators(Collection<EOperation> operations) {
        BasicEList.FastCompare result = new BasicEList.FastCompare();
        for (EOperation oper : operations) {
            EAnnotation ann = oper.getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL");
            if (ann == null || !"iterator".equals(ann.getDetails().get((Object)"keywords"))) continue;
            result.add((Object)oper);
        }
        return result;
    }
}

