/**
 * Copyright (c) 2006-2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.diagram.editpolicies;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class CompartmentItemSemanticEditPolicy {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  private childContainerCreateCommand xptChildContainerCreateCommand;
  
  @Inject
  private BaseItemSemanticEditPolicy xptBaseItemSemanticEditPolicy;
  
  public CharSequence className(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    String _itemSemanticEditPolicyClassName = it.getItemSemanticEditPolicyClassName();
    _builder.append(_itemSemanticEditPolicyClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPoliciesPackageName = it.getDiagram().getEditPoliciesPackageName();
    _builder.append(_editPoliciesPackageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence CompartmentItemSemanticEditPolicy(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" extends ");
    CharSequence _qualifiedClassName = this.xptBaseItemSemanticEditPolicy.qualifiedClassName(it.getDiagram());
    _builder.append(_qualifiedClassName);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence __constructor = this._constructor(it);
    _builder.append(__constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _childContainerCreateCommand = this.xptChildContainerCreateCommand.childContainerCreateCommand(it.getChildNodes());
    _builder.append(_childContainerCreateCommand, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence _constructor(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _defaultConstructorBody = this.xptBaseItemSemanticEditPolicy.defaultConstructorBody(it.getNode());
    _builder.append(_defaultConstructorBody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence additions(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
}
