/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package gmfgraph;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.gmfgraph.Figure;
import org.eclipse.papyrus.gmf.gmfgraph.SVGFigure;
import org.eclipse.papyrus.gmf.gmfgraph.SVGProperty;
import org.eclipse.papyrus.gmf.gmfgraph.SVGPropertyType;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class Extras {
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  @Extension
  private Common _common;
  
  protected CharSequence _extraMethods(final Figure it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  protected CharSequence _extraMethods(final SVGFigure it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<SVGProperty> _properties = it.getProperties();
      for(final SVGProperty p : _properties) {
        CharSequence _svgProperty = this.svgProperty(p);
        _builder.append(_svgProperty);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence svgProperty(final SVGProperty it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _getter = it.getGetter();
      boolean _notEquals = (!Objects.equal(_getter, null));
      if (_notEquals) {
        CharSequence _svgPropertyGetter = this.svgPropertyGetter(it);
        _builder.append(_svgPropertyGetter);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      String _setter = it.getSetter();
      boolean _notEquals_1 = (!Objects.equal(_setter, null));
      if (_notEquals_1) {
        CharSequence _svgPropertySetter = this.svgPropertySetter(it);
        _builder.append(_svgPropertySetter);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence svgPropertyGetter(final SVGProperty it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    String _svgPropertyType = this._utils_qvto.svgPropertyType(it);
    _builder.append(_svgPropertyType);
    _builder.append(" ");
    String _getter = it.getGetter();
    _builder.append(_getter);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("org.w3c.dom.NodeList nodes = getNodes(\"");
    String _query = it.getQuery();
    _builder.append(_query, "\t");
    _builder.append("\"); //$NON-NLS-1$");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (nodes.getLength() > 0) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.w3c.dom.Element element = (org.w3c.dom.Element) nodes.item(0);");
    _builder.newLine();
    {
      SVGPropertyType _type = it.getType();
      boolean _equals = Objects.equal(_type, SVGPropertyType.COLOR);
      if (_equals) {
        _builder.append("\t\t");
        _builder.append("return getColor(element, \"");
        String _attribute = it.getAttribute();
        _builder.append(_attribute, "\t\t");
        _builder.append("\"); ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append(_nonNLS, "\t\t");
        _builder.newLineIfNotEmpty();
      } else {
        SVGPropertyType _type_1 = it.getType();
        boolean _equals_1 = Objects.equal(_type_1, SVGPropertyType.FLOAT);
        if (_equals_1) {
          _builder.append("\t\t");
          _builder.append("String value = element.getAttributeNS(null, \"");
          String _attribute_1 = it.getAttribute();
          _builder.append(_attribute_1, "\t\t");
          _builder.append("\"); ");
          CharSequence _nonNLS_1 = this._common.nonNLS(1);
          _builder.append(_nonNLS_1, "\t\t");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("return Float.parseFloat(value);");
          _builder.newLine();
        } else {
          _builder.append("\t\t");
          _builder.append("return element.getAttributeNS(null, \"");
          String _attribute_2 = it.getAttribute();
          _builder.append(_attribute_2, "\t\t");
          _builder.append("\"); ");
          CharSequence _nonNLS_2 = this._common.nonNLS(1);
          _builder.append(_nonNLS_2, "\t\t");
          _builder.newLineIfNotEmpty();
        }
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    {
      SVGPropertyType _type_2 = it.getType();
      boolean _equals_2 = Objects.equal(_type_2, SVGPropertyType.FLOAT);
      if (_equals_2) {
        _builder.append("\t");
        _builder.append("return 0;");
        _builder.newLine();
      } else {
        _builder.append("\t");
        _builder.append("return null;");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence svgPropertySetter(final SVGProperty it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public void ");
    String _setter = it.getSetter();
    _builder.append(_setter);
    _builder.append("(");
    String _svgPropertyType = this._utils_qvto.svgPropertyType(it);
    _builder.append(_svgPropertyType);
    _builder.append(" value) {");
    _builder.newLineIfNotEmpty();
    {
      SVGPropertyType _type = it.getType();
      boolean _equals = Objects.equal(_type, SVGPropertyType.COLOR);
      if (_equals) {
        _builder.append("\t");
        _builder.append("String svalue = org.eclipse.gmf.runtime.lite.svg.SVGUtils.toSVGColor(getDocument(), value);");
        _builder.newLine();
      } else {
        SVGPropertyType _type_1 = it.getType();
        boolean _equals_1 = Objects.equal(_type_1, SVGPropertyType.FLOAT);
        if (_equals_1) {
          _builder.append("\t");
          _builder.append("String svalue = Float.toString(value);");
          _builder.newLine();
        }
      }
    }
    _builder.append("\t");
    _builder.append("org.w3c.dom.NodeList nodes = getNodes(\"");
    String _query = it.getQuery();
    _builder.append(_query, "\t");
    _builder.append("\"); ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("for (int i = 0; i < nodes.getLength(); i++) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("((org.w3c.dom.Element) nodes.item(i)).setAttributeNS(null, \"");
    String _attribute = it.getAttribute();
    _builder.append(_attribute, "\t\t");
    _builder.append("\", ");
    CharSequence _nonNLS_1 = this._common.nonNLS(1);
    _builder.append(_nonNLS_1, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    {
      SVGPropertyType _type_2 = it.getType();
      boolean _equals_2 = Objects.equal(_type_2, SVGPropertyType.STRING);
      if (_equals_2) {
        _builder.append("value");
      } else {
        _builder.append("svalue");
      }
    }
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    {
      boolean _isCallSuper = it.isCallSuper();
      if (_isCallSuper) {
        _builder.append("\t");
        _builder.append("super.");
        String _setter_1 = it.getSetter();
        _builder.append(_setter_1, "\t");
        _builder.append("(value);");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence extraMethods(final Figure it) {
    if (it instanceof SVGFigure) {
      return _extraMethods((SVGFigure)it);
    } else if (it != null) {
      return _extraMethods(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
