/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.parsers;

import java.math.BigDecimal;
import java.util.Date;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.Messages;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.parsers.AbstractFeatureParser;

public abstract class AbstractAttributeParser
extends AbstractFeatureParser {
    private String viewPattern;
    private String editorPattern;
    private String editPattern;
    protected final EAttribute[] features;
    protected final EAttribute[] editableFeatures;
    private static NumberCaster<Short> SHORT_CASTER = new NumberCaster<Short>(){

        @Override
        public Short castNumber(Number number) {
            return number instanceof Short ? ((Short)number).shortValue() : number.shortValue();
        }
    };
    private static NumberCaster<Byte> BYTE_CASTER = new NumberCaster<Byte>(){

        @Override
        public Byte castNumber(Number number) {
            return number instanceof Byte ? ((Byte)number).byteValue() : number.byteValue();
        }
    };
    private static NumberCaster<Integer> INT_CASTER = new NumberCaster<Integer>(){

        @Override
        public Integer castNumber(Number number) {
            return number instanceof Integer ? ((Integer)number).intValue() : number.intValue();
        }
    };
    private static NumberCaster<Long> LONG_CASTER = new NumberCaster<Long>(){

        @Override
        public Long castNumber(Number number) {
            return number instanceof Long ? ((Long)number).longValue() : number.longValue();
        }
    };
    private static NumberCaster<Double> DOUBLE_CASTER = new NumberCaster<Double>(){

        @Override
        public Double castNumber(Number number) {
            return number instanceof Double ? ((Double)number).doubleValue() : number.doubleValue();
        }
    };
    private static NumberCaster<Float> FLOAT_CASTER = new NumberCaster<Float>(){

        @Override
        public Float castNumber(Number number) {
            return Float.valueOf(number instanceof Float ? ((Float)number).floatValue() : number.floatValue());
        }
    };

    public AbstractAttributeParser(EAttribute[] features) {
        super((EStructuralFeature[])features);
        this.editableFeatures = features;
        this.features = features;
    }

    public AbstractAttributeParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super((EStructuralFeature[])features, (EStructuralFeature[])editableFeatures);
        this.features = features;
        this.editableFeatures = editableFeatures;
    }

    @Override
    protected Object getValue(EObject element, EStructuralFeature feature) {
        Object value = super.getValue(element, feature);
        Class iClass = ((EAttribute)feature).getEAttributeType().getInstanceClass();
        if (String.class.equals((Object)iClass) && value == null) {
            value = "";
        }
        return value;
    }

    @Override
    protected Object getValidNewValue(EStructuralFeature feature, Object value) {
        EClassifier type = feature.getEType();
        if (!(type instanceof EDataType)) {
            return value;
        }
        if (type instanceof EEnum) {
            return this.getValidEnumValue((EEnum)type, value);
        }
        if (value instanceof String) {
            try {
                return type.getEPackage().getEFactoryInstance().createFromString((EDataType)type, (String)value);
            }
            catch (Exception e) {
                String safeExceptionMsg = e == null || e.getMessage() == null ? "" : e.getMessage();
                return new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_WrongStringConversion, (Object)type.getName(), (Object)safeExceptionMsg));
            }
        }
        Class iClass = type.getInstanceClass();
        if (iClass == null) {
            return value;
        }
        if (value == null) {
            return iClass.isPrimitive() ? new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_NullIsNotAllowed, (Object)type.getName())) : null;
        }
        if (Boolean.TYPE.equals(iClass) || Boolean.class.equals((Object)iClass)) {
            return this.safeCast(value, type, Boolean.class);
        }
        if (Character.TYPE.equals(iClass) || Character.class.equals((Object)iClass)) {
            return this.safeCast(value, type, Character.class);
        }
        if (Byte.TYPE.equals(iClass) || Byte.class.equals((Object)iClass)) {
            return this.safeCastNumber(value, BYTE_CASTER);
        }
        if (Short.TYPE.equals(iClass) || Short.class.equals((Object)iClass)) {
            return this.safeCastNumber(value, SHORT_CASTER);
        }
        if (Integer.TYPE.equals(iClass) || Integer.class.equals((Object)iClass)) {
            return this.safeCastNumber(value, INT_CASTER);
        }
        if (Long.TYPE.equals(iClass) || Long.class.equals((Object)iClass)) {
            return this.safeCastNumber(value, LONG_CASTER);
        }
        if (Float.TYPE.equals(iClass) || Float.class.equals((Object)iClass)) {
            return this.safeCastNumber(value, FLOAT_CASTER);
        }
        if (Double.TYPE.equals(iClass) || Double.class.equals((Object)iClass)) {
            return this.safeCastNumber(value, DOUBLE_CASTER);
        }
        if (Date.class.equals((Object)iClass)) {
            return this.safeCast(value, type, Date.class);
        }
        if (BigDecimal.class.equals((Object)iClass)) {
            if (value == null || value instanceof BigDecimal) {
                return value;
            }
            if (value instanceof Number) {
                return new BigDecimal(((Number)value).doubleValue());
            }
            return new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_UnexpectedValueType, (Object)BigDecimal.class.getName()));
        }
        return value;
    }

    protected Object safeCast(Object value, EClassifier type, Class<?> clazz) {
        if (value == null) {
            return clazz.isPrimitive() ? new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_NullIsNotAllowed, (Object)type.getName())) : null;
        }
        return clazz.isInstance(value) ? clazz.cast(value) : new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_UnexpectedValueType, (Object)clazz.getName()));
    }

    protected <T extends Number> Object safeCastNumber(Object value, NumberCaster<T> caster) {
        if (value instanceof Number) {
            return caster.castNumber((Number)value);
        }
        return new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_UnexpectedValueType, (Object)Number.class.getName()));
    }

    protected Object getValidEnumValue(EEnum type, Object value) {
        EEnumLiteral literal = null;
        if (value instanceof String) {
            literal = type.getEEnumLiteralByLiteral((String)value);
        } else if (value instanceof Number) {
            literal = type.getEEnumLiteral(((Number)value).intValue());
        } else if (value instanceof Enumerator) {
            literal = type.getEEnumLiteral(((Enumerator)value).getValue());
        }
        return literal == null ? new AbstractFeatureParser.InvalidValue(NLS.bind((String)Messages.AbstractAttributeParser_UnknownLiteral, (Object)value)) : literal.getInstance();
    }

    public String getViewPattern() {
        return this.viewPattern;
    }

    public void setViewPattern(String viewPattern) {
        this.viewPattern = viewPattern;
    }

    public String getEditorPattern() {
        return this.editorPattern;
    }

    public void setEditorPattern(String editorPattern) {
        this.editorPattern = editorPattern;
    }

    public String getEditPattern() {
        return this.editPattern;
    }

    public void setEditPattern(String editPattern) {
        this.editPattern = editPattern;
    }

    private static abstract class NumberCaster<T extends Number> {
        private NumberCaster() {
        }

        public abstract T castNumber(Number var1);
    }
}

