/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.fillhandle.config;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.copy.command.InternalCopyDataCommandHandler;
import org.eclipse.nebula.widgets.nattable.fillhandle.FillHandleLayerPainter;
import org.eclipse.nebula.widgets.nattable.fillhandle.action.FillHandleCursorAction;
import org.eclipse.nebula.widgets.nattable.fillhandle.config.FillHandleConfiguration;
import org.eclipse.nebula.widgets.nattable.fillhandle.event.FillHandleEventMatcher;
import org.eclipse.nebula.widgets.nattable.fillhandle.event.FillHandleMarkupListener;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.action.ClearCursorAction;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.action.NoOpMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.papyrus.infra.nattable.fillhandle.action.PapyrusFillHandleDragMode;
import org.eclipse.papyrus.infra.nattable.fillhandle.command.PapyrusFillHandlePasteCommandHandler;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;

public class PapyrusFillHandleConfiguration
extends FillHandleConfiguration {
    protected INattableModelManager tableManager;

    public PapyrusFillHandleConfiguration(SelectionLayer selectionLayer, INattableModelManager tableManager) {
        super(selectionLayer);
        this.tableManager = tableManager;
    }

    public void configureTypedLayer(NatTable natTable) {
        this.clipboard = natTable.getInternalCellClipboard();
        this.painter = new FillHandleLayerPainter(true, false);
        this.selectionLayer.setLayerPainter((ILayerPainter)this.painter);
        this.selectionLayer.addLayerListener((ILayerListener)new FillHandleMarkupListener(this.selectionLayer));
        InternalCopyDataCommandHandler handler = new InternalCopyDataCommandHandler(this.selectionLayer, this.clipboard);
        handler.setCopyFormattedText(true);
        this.selectionLayer.registerCommandHandler((ILayerCommandHandler)handler);
        this.selectionLayer.registerCommandHandler((ILayerCommandHandler)new PapyrusFillHandlePasteCommandHandler(this.selectionLayer, this.clipboard, this.tableManager));
    }

    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        FillHandleEventMatcher matcher = new FillHandleEventMatcher(this.painter);
        uiBindingRegistry.registerFirstMouseMoveBinding((IMouseEventMatcher)matcher, (IMouseAction)new FillHandleCursorAction());
        uiBindingRegistry.registerMouseMoveBinding((IMouseEventMatcher)new MouseEventMatcher(), (IMouseAction)new ClearCursorAction());
        uiBindingRegistry.registerFirstMouseDragMode((IMouseEventMatcher)matcher, (IDragMode)new PapyrusFillHandleDragMode(this.selectionLayer, this.clipboard));
        uiBindingRegistry.registerFirstMouseDownBinding((IMouseEventMatcher)matcher, (IMouseAction)new NoOpMouseAction());
    }
}

