/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.quickfix;

import com.google.common.base.Functions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.AbstractMissingExtensionMarkerResolution;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginParent;

public final class SimpleMissingExtensionMarkerResolution
extends AbstractMissingExtensionMarkerResolution {
    private final String label;
    private final String description;
    private final Function<? super IMarker, String> extensionPointFunction;
    private final Function<? super IMarker, String> elementNameFunction;
    private final Function<? super IMarker, ? extends Map<String, String>> elementAttributesFunction;

    public SimpleMissingExtensionMarkerResolution(int problemID, String label, String description, Function<? super IMarker, String> extensionPointFunction, Function<? super IMarker, String> elementNameFunction, Function<? super IMarker, ? extends Map<String, String>> elementAttributesFunction) {
        super(problemID);
        this.label = label;
        this.description = description;
        this.extensionPointFunction = extensionPointFunction;
        this.elementNameFunction = elementNameFunction;
        this.elementAttributesFunction = elementAttributesFunction;
    }

    public SimpleMissingExtensionMarkerResolution(int problemID, String label, String description, String extensionPoint, String elementName, Map<String, String> elementAttributes) {
        this(problemID, label, description, (Function<? super IMarker, String>)Functions.constant((Object)extensionPoint), (Function<? super IMarker, String>)Functions.constant((Object)elementName), (Function<? super IMarker, ? extends Map<String, String>>)Functions.constant(elementAttributes));
    }

    @SafeVarargs
    public SimpleMissingExtensionMarkerResolution(int problemID, String label, String description, String extensionPoint, String elementName, BiConsumer<IMarker, Map<String, String>> ... elementAttributes) {
        this(problemID, label, description, (Function<? super IMarker, String>)Functions.constant((Object)extensionPoint), (Function<? super IMarker, String>)Functions.constant((Object)elementName), SimpleMissingExtensionMarkerResolution.attributes(elementAttributes));
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    protected String getExtensionPoint(IMarker marker) {
        return this.extensionPointFunction.apply((IMarker)marker);
    }

    @Override
    protected void configureExtension(IPluginExtension extension, IMarker marker) throws CoreException {
        IPluginElement element = this.createElement((IPluginParent)extension, this.elementNameFunction.apply((IMarker)marker));
        this.elementAttributesFunction.apply((IMarker)marker).forEach((name, value) -> {
            IPluginElement iPluginElement2 = this.setAttribute(element, (String)name, (String)value);
        });
    }

    @SafeVarargs
    public static Function<IMarker, Map<String, String>> attributes(BiConsumer<IMarker, Map<String, String>> ... attribute) {
        return marker -> {
            HashMap result = new HashMap();
            BiConsumer[] biConsumerArray2 = attribute;
            int n = attribute.length;
            int n2 = 0;
            while (n2 < n) {
                BiConsumer next = biConsumerArray2[n2];
                next.accept(marker, result);
                ++n2;
            }
            return result;
        };
    }

    public static BiConsumer<IMarker, Map<String, String>> attribute(String name, String value) {
        return (marker, attributes) -> {
            String string3 = attributes.put(name, value);
        };
    }

    public static BiConsumer<IMarker, Map<String, String>> attribute(Function<? super IMarker, String> name, String value) {
        return (marker, attributes) -> {
            String string2 = attributes.put((String)name.apply((IMarker)marker), value);
        };
    }

    public static BiConsumer<IMarker, Map<String, String>> attribute(String name, Function<? super IMarker, String> value) {
        return (marker, attributes) -> {
            String string2 = attributes.put(name, (String)value.apply((IMarker)marker));
        };
    }

    public static BiConsumer<IMarker, Map<String, String>> attribute(Function<? super IMarker, String> name, Function<? super IMarker, String> value) {
        return (marker, attributes) -> {
            String string = attributes.put((String)name.apply((IMarker)marker), (String)value.apply((IMarker)marker));
        };
    }

    public static BiConsumer<IMarker, Map<String, String>> optionalAttribute(String name, Function<? super IMarker, Optional<String>> value) {
        return (marker, attributes) -> ((Optional)value.apply((IMarker)marker)).ifPresent(v -> {
            String string2 = attributes.put(name, v);
        });
    }

    public static BiConsumer<IMarker, Map<String, String>> optionalAttribute(Function<? super IMarker, String> name, Function<? super IMarker, Optional<String>> value) {
        return (marker, attributes) -> ((Optional)value.apply((IMarker)marker)).ifPresent(v -> {
            String string = attributes.put((String)name.apply((IMarker)marker), v);
        });
    }
}

