/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.quickfix;

import java.util.stream.Stream;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.eclipse.project.editors.file.BuildEditor;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.messages.Messages;
import org.eclipse.papyrus.toolsmiths.validation.common.quickfix.AbstractPapyrusWorkbenchMarkerResolution;
import org.eclipse.ui.IMarkerResolution;

public abstract class ResourceMissingFromBinaryBuildMarkerResolution
extends AbstractPapyrusWorkbenchMarkerResolution {
    private ResourceMissingFromBinaryBuildMarkerResolution() {
        super(0xFF1000);
    }

    public String getDescription() {
        return Messages.ResourceMissingFromBinaryBuildMarkerResolution_description;
    }

    IPath getPathToAdd(IMarker marker) {
        return new Path(marker.getAttribute("binaryBuildPath", ""));
    }

    public void run(IMarker marker) {
        String path = this.getPathToAdd(marker).toPortableString();
        BuildEditor buildEditor = new BuildEditor(marker.getResource().getProject());
        buildEditor.init();
        buildEditor.addToBuild(path);
        buildEditor.save();
    }

    public static IMarkerResolution[] forMarker(IMarker marker) {
        Path binaryBuildPath = new Path(marker.getAttribute("binaryBuildPath", ""));
        switch (binaryBuildPath.segmentCount()) {
            case 0: {
                return new IMarkerResolution[0];
            }
            case 1: {
                return new IMarkerResolution[]{new File()};
            }
        }
        return new IMarkerResolution[]{new File(), new Folder()};
    }

    private static final class File
    extends ResourceMissingFromBinaryBuildMarkerResolution {
        private File() {
        }

        public String getLabel() {
            return NLS.bind((String)Messages.ResourceMissingFromBinaryBuildMarkerResolution_label, (Object)Messages.ResourceMissingFromBinaryBuildMarkerResolution_file);
        }
    }

    private static final class Folder
    extends ResourceMissingFromBinaryBuildMarkerResolution {
        private Folder() {
        }

        public String getLabel() {
            return NLS.bind((String)Messages.ResourceMissingFromBinaryBuildMarkerResolution_label, (Object)Messages.ResourceMissingFromBinaryBuildMarkerResolution_folder);
        }

        @Override
        IPath getPathToAdd(IMarker marker) {
            return super.getPathToAdd(marker).uptoSegment(1).addTrailingSeparator();
        }

        @Override
        protected Stream<IMarker> findSimilarMarkers(IMarker[] markers) {
            return super.findSimilarMarkers(markers).filter(m -> this.getPathToAdd((IMarker)m).segmentCount() > 0);
        }
    }
}

