/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.junit.matchers.MoreMatchers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.osgi.framework.Bundle;

public class LogTracker
implements ILogListener {
    private String bundle;
    private Predicate<? super IStatus> filter;
    private ILog log;
    private final List<IStatus> messages = Lists.newArrayList();

    public void start(String bundle) {
        this.start(bundle, null);
    }

    public void start(String bundle, Predicate<? super IStatus> filter) {
        if (filter == null) {
            filter = Predicates.alwaysTrue();
        }
        this.bundle = bundle;
        this.filter = filter;
        this.log = Platform.getLog((Bundle)Platform.getBundle((String)bundle));
        Platform.addLogListener((ILogListener)this);
    }

    public void dispose() {
        if (this.log != null) {
            Platform.removeLogListener((ILogListener)this);
            this.log = null;
            this.clear();
            this.bundle = null;
            this.filter = null;
        }
    }

    public void clear() {
        this.messages.clear();
    }

    public void logging(IStatus status, String plugin) {
        if ((plugin.equals(this.bundle) || status.getPlugin().equals(this.bundle)) && this.filter.apply((Object)status)) {
            this.messages.add(status);
        }
    }

    public void assertAll(Matcher<? super IStatus> assertion) {
        Matcher<? super IStatus> hamcrestSignatureWorkaround = assertion;
        MatcherAssert.assertThat(this.messages, (Matcher)CoreMatchers.either(MoreMatchers.emptyIterable()).or(CoreMatchers.everyItem(hamcrestSignatureWorkaround)));
    }

    public void assertExistAll(Matcher<? super IStatus> assertion) {
        Matcher<? super IStatus> hamcrestSignatureWorkaround = assertion;
        MatcherAssert.assertThat(this.messages, (Matcher)CoreMatchers.both((Matcher)CoreMatchers.not(MoreMatchers.emptyIterable())).and(CoreMatchers.everyItem(hamcrestSignatureWorkaround)));
    }

    public void assertNone(Matcher<? super IStatus> assertion) {
        Matcher<? super IStatus> hamcrestSignatureWorkaround = assertion;
        MatcherAssert.assertThat(this.messages, (Matcher)CoreMatchers.everyItem((Matcher)CoreMatchers.not(hamcrestSignatureWorkaround)));
    }
}

