/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.internal.property.section;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationImportDescription;

public final class SiriusPropertySectionHelper {
    private SiriusPropertySectionHelper() {
    }

    public static boolean isChildOfRepresentationDescription(EObject eObject, RepresentationDescription representationDescription) {
        if (eObject.equals(representationDescription)) {
            return true;
        }
        Option desc = new EObjectQuery(eObject).getFirstAncestorOfType(DescriptionPackage.Literals.REPRESENTATION_DESCRIPTION);
        return desc.some() && ((EObject)desc.get()).equals(representationDescription);
    }

    public static RepresentationImportDescription getRepresentationImportDescriptionInSelection(ISelection selection) {
        if (selection instanceof ITreeSelection) {
            TreePath treePath = ((ITreeSelection)selection).getPaths()[0];
            int i = 0;
            while (i < treePath.getSegmentCount()) {
                if (treePath.getSegment(i) instanceof RepresentationImportDescription) {
                    return (RepresentationImportDescription)treePath.getSegment(i);
                }
                ++i;
            }
        }
        return null;
    }
}

