/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.markerlistener.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.papyrus.infra.services.markerlistener.providers.IMarkerProvider;
import org.eclipse.papyrus.infra.services.markerlistener.providers.MarkerCache;
import org.eclipse.papyrus.infra.services.markerlistener.providers.MarkerProviderRegistry;

public interface IMarkerProvider2 {
    public boolean hasMarkers(Resource var1, EObject var2);

    public ICommand getMarkerDeletionCommand(Resource var1, EObject var2);

    public static class Adapter
    implements IMarkerProvider2 {
        private static MarkerCache markerCache = new MarkerCache(Adapter.createMarkerCacheLoader());
        private final IMarkerProvider provider;

        Adapter(IMarkerProvider provider) {
            this.provider = provider;
        }

        public static IMarkerProvider2 getExtendedProvider(IMarkerProvider provider) {
            return provider instanceof IMarkerProvider2 ? (IMarkerProvider2)((Object)provider) : new Adapter(provider);
        }

        @Override
        public boolean hasMarkers(Resource context, EObject object) {
            return !markerCache.getMarkers(context).isEmpty();
        }

        @Override
        public ICommand getMarkerDeletionCommand(Resource context, EObject object) {
            return new DeleteMarkersCommand(this.provider, context, object);
        }

        static MarkerCache.CacheLoader createMarkerCacheLoader() {
            return new MarkerCache.CacheLoader(){

                @Override
                public Collection<? extends IPapyrusMarker> getMarkers(Resource resource) throws CoreException {
                    List<IMarkerProvider> providers = MarkerProviderRegistry.INSTANCE.getMarkerProviders(resource);
                    return switch (providers.size()) {
                        case 0 -> Collections.emptyList();
                        case 1 -> providers.get(0).getMarkers(resource, null, true);
                        default -> {
                            ArrayList markers = new ArrayList();
                            for (IMarkerProvider provider : providers) {
                                markers.addAll(provider.getMarkers(resource, null, true));
                            }
                            yield markers;
                        }
                    };
                }
            };
        }

        private static class DeleteMarkersCommand
        extends AbstractCommand {
            private IMarkerProvider provider;
            private Resource context;
            private EObject object;
            private Diagnostic diagnosticForUndo;

            DeleteMarkersCommand(IMarkerProvider provider, Resource context, EObject object) {
                super("Delete markers");
                this.provider = provider;
                this.context = context;
                this.object = object;
            }

            public void dispose() {
                this.provider = null;
                this.context = null;
                this.object = null;
                this.diagnosticForUndo = null;
                super.dispose();
            }

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                Collection<IPapyrusMarker> markers = markerCache.getMarkers(this.context, this.object);
                if (markers.isEmpty()) {
                    return CommandResult.newOKCommandResult();
                }
                CoreException exception = null;
                BasicDiagnostic diagnostics = new BasicDiagnostic();
                for (IPapyrusMarker marker : markers) {
                    try {
                        int severity = marker.getAttribute("severity", 4);
                        String message = (String)marker.getAttribute("message");
                        String source = marker.getAttribute("sourceId", "org.eclipse.papyrus.infra.services.markerlistener");
                        diagnostics.add((Diagnostic)new BasicDiagnostic(DeleteMarkersCommand.toDiagnosticSeverity(severity), source, 0, message, new Object[]{this.object}));
                        marker.delete();
                    }
                    catch (CoreException e) {
                        if (exception != null) continue;
                        exception = e;
                    }
                }
                if (!diagnostics.getChildren().isEmpty()) {
                    this.diagnosticForUndo = diagnostics;
                }
                return exception == null ? CommandResult.newOKCommandResult() : CommandResult.newErrorCommandResult(exception);
            }

            protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                if (this.diagnosticForUndo == null) {
                    return CommandResult.newOKCommandResult();
                }
                CoreException exception = null;
                Diagnostic diagnostic = this.diagnosticForUndo;
                this.diagnosticForUndo = null;
                Resource resource = this.object.eResource();
                if (resource != null) {
                    this.context = resource;
                    try {
                        this.provider.createMarkers(resource, diagnostic, progressMonitor);
                    }
                    catch (CoreException e) {
                        exception = e;
                    }
                }
                return exception == null ? CommandResult.newOKCommandResult() : CommandResult.newErrorCommandResult(exception);
            }

            protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                return this.doExecuteWithResult(progressMonitor, info);
            }

            static int toDiagnosticSeverity(int markerSeverity) {
                switch (markerSeverity) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 4;
                    }
                }
                return 0;
            }
        }
    }
}

