/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.commands;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;

public abstract class AbstractRefreshConnectionElementsRunnable<T>
implements RunnableWithResult<T> {
    private IStatus status;
    private T result;
    private final IGraphicalEditPart containerEP;

    public AbstractRefreshConnectionElementsRunnable(IGraphicalEditPart containerEP) {
        this.containerEP = containerEP;
    }

    public final T getResult() {
        return this.result;
    }

    public final void setStatus(IStatus status) {
        this.status = status;
    }

    public final IStatus getStatus() {
        return this.status;
    }

    protected final IGraphicalEditPart getContainerEditPart() {
        return this.containerEP;
    }

    protected final void refreshConnection(AbstractConnectionEditPart connectionToRefresh) {
        EditPart targetEP;
        connectionToRefresh.refresh();
        EditPart sourceEp = connectionToRefresh.getSource();
        if (sourceEp != null) {
            sourceEp.refresh();
        }
        if ((targetEP = connectionToRefresh.getTarget()) != null) {
            targetEP.refresh();
        }
        List childrens = connectionToRefresh.getChildren();
        for (EditPart nextChild : childrens) {
            nextChild.refresh();
        }
        connectionToRefresh.getFigure().validate();
    }

    protected final IFigure getContainerFigure() {
        return this.containerEP.getFigure();
    }

    protected final void setResult(T result) {
        this.result = result;
    }
}

