/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.services;

import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sirius.uml.diagram.common.Activator;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.LabelElementNameProvider;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.NamedElementQualifiedNameProvider;
import org.eclipse.papyrus.uml.domain.services.directedit.ElementDirectEditInputValueProvider;
import org.eclipse.papyrus.uml.domain.services.directedit.ElementDirectEditValueConsumer;
import org.eclipse.papyrus.uml.domain.services.labels.ElementDomainBasedEdgeSourceLabelProvider;
import org.eclipse.papyrus.uml.domain.services.labels.ElementDomainBasedEdgeTargetLabelProvider;
import org.eclipse.papyrus.uml.domain.services.labels.ElementLabelProvider;
import org.eclipse.papyrus.uml.domain.services.labels.INamedElementNameProvider;
import org.eclipse.papyrus.uml.domain.services.labels.KeywordLabelProvider;
import org.eclipse.papyrus.uml.domain.services.labels.StereotypeLabelPrefixProvider;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.uml2.uml.Element;

public class UMLLabelServices {
    private static final String APPLIED_STEREOTYPE_LAYER_ID = "AppliedStereotypeLayer";
    private static final String QUALIFIED_NAMED_LAYER_ID = "QualifiedNameLayer";

    public String renderLabel(EObject semanticObject, DDiagram diagram) {
        ElementLabelProvider elementLabelProvider = this.getElementLabelProvider(diagram, false);
        return elementLabelProvider.getLabel(semanticObject);
    }

    public String renderLabelInline(EObject semanticObject, DDiagram diagram) {
        ElementLabelProvider elementLabelProvider = this.getElementLabelProvider(diagram, true);
        return elementLabelProvider.getLabel(semanticObject);
    }

    private ElementLabelProvider getElementLabelProvider(DDiagram diagram, boolean inline) {
        boolean showingQualifiedName = this.isShowingQualifiedName(diagram);
        boolean showingAppliedStereotype = this.isShowingAppliedStereotype(diagram);
        StereotypeLabelPrefixProvider stereotypeProvider = element -> "";
        Object elementNameProvider = new LabelElementNameProvider();
        if (showingAppliedStereotype) {
            stereotypeProvider = new StereotypeLabelPrefixProvider();
        }
        if (showingQualifiedName) {
            elementNameProvider = new NamedElementQualifiedNameProvider();
        }
        ElementLabelProvider.Builder elementLabelProviderBuilder = ElementLabelProvider.builder().withKeywordLabelProvider((Function)new KeywordLabelProvider()).withNameProvider((INamedElementNameProvider)elementNameProvider).withPrefixLabelProvider((Function)stereotypeProvider);
        if (inline) {
            elementLabelProviderBuilder.withKeywordSeparator(" ").withPrefixSeparator(" ");
        }
        return elementLabelProviderBuilder.build();
    }

    private boolean isShowingQualifiedName(DDiagram diagram) {
        return diagram.getActivatedLayers().stream().filter(layer -> QUALIFIED_NAMED_LAYER_ID.equals(layer.getName())).findFirst().isPresent();
    }

    private boolean isShowingAppliedStereotype(DDiagram diagram) {
        return diagram.getActivatedLayers().stream().filter(layer -> APPLIED_STEREOTYPE_LAYER_ID.equals(layer.getName())).findFirst().isPresent();
    }

    public String renderEdgeSourceLabel(EObject semanticObject, EObject semanticSource) {
        return ElementDomainBasedEdgeSourceLabelProvider.buildDefault().getLabel(semanticObject, semanticSource);
    }

    public String renderEdgeTargetLabel(EObject semanticObject, EObject semanticTarget) {
        return ElementDomainBasedEdgeTargetLabelProvider.buildDefault().getLabel(semanticObject, semanticTarget);
    }

    public String getDirectEditInputValue(Element element) {
        ElementDirectEditInputValueProvider provider = new ElementDirectEditInputValueProvider();
        return provider.getDirectEditInputValue((EObject)element);
    }

    public void consumeNewLabel(Element element, String input) {
        ElementDirectEditValueConsumer consumer = new ElementDirectEditValueConsumer();
        CheckStatus status = consumer.consumeNewLabel((EObject)element, input);
        if (!status.isValid()) {
            Activator.log.warn(status.getMessage());
        }
    }
}

