/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.services;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.EcoreUtil2;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class DiagramHelper {
    private static DiagramHelper instance;

    protected DiagramHelper() {
    }

    public static DiagramHelper getService() {
        if (instance == null) {
            instance = new DiagramHelper();
        }
        return instance;
    }

    public RepresentationDescription getDescription(DRepresentation representation) {
        return DialectManager.INSTANCE.getDescription(representation);
    }

    public boolean isA(DRepresentation diagram, String descriptionId) {
        if (diagram != null) {
            RepresentationDescription description = this.getDescription(diagram);
            return this.isA(description, descriptionId);
        }
        return false;
    }

    public boolean isA(RepresentationDescription description, String diagramDescriptionId) {
        if (description != null) {
            if (diagramDescriptionId == null) {
                return true;
            }
            return diagramDescriptionId.equals(description.getName());
        }
        return false;
    }

    public boolean hasKind(DRepresentation diagram, String diagramDescriptionId) {
        if (diagram != null) {
            RepresentationDescription description = this.getDescription(diagram);
            return this.hasKind(description, diagramDescriptionId);
        }
        return false;
    }

    private boolean hasKind(RepresentationDescription description, String diagramDescriptionId) {
        if (description != null) {
            if (diagramDescriptionId == null) {
                return true;
            }
            return description.getName().contains(diagramDescriptionId);
        }
        return false;
    }

    public DDiagram getDiagramContainer(EObject current) {
        if (current instanceof DDiagram) {
            return (DDiagram)current;
        }
        return (DDiagram)EcoreUtil2.getFirstContainer(current, DiagramPackage.Literals.DDIAGRAM);
    }

    public RepresentationDescription getDescription(Session session, String descriptionId) {
        Collection viewpoints = session.getSelectedViewpoints(true);
        for (Viewpoint viewpoint : viewpoints) {
            for (RepresentationDescription description : viewpoint.getOwnedRepresentations()) {
                if (!descriptionId.equals(description.getName())) continue;
                return description;
            }
        }
        return null;
    }

    public Session getSession(DRepresentation diagram) {
        if (diagram instanceof DSemanticDecorator) {
            EObject target = ((DSemanticDecorator)diagram).getTarget();
            if (target == null) {
                return null;
            }
            return SessionManager.INSTANCE.getSession(target);
        }
        return null;
    }

    public DRepresentation createDRepresentation(String name, EObject semantic, RepresentationDescription description, Session session, IProgressMonitor monitor) {
        return DialectManager.INSTANCE.createRepresentation(name, semantic, description, session, monitor);
    }

    public DRepresentation getRepresentation(DSemanticDecorator decorator) {
        if (decorator instanceof DRepresentation) {
            return (DRepresentation)decorator;
        }
        return (DRepresentation)EcoreUtil2.getFirstContainer((EObject)decorator, ViewpointPackage.Literals.DREPRESENTATION);
    }
}

