/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.dragtracker;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;

public class NoScrollDragEditPartsTrackerEx
extends DragEditPartsTrackerEx {
    private int border = 15;

    public NoScrollDragEditPartsTrackerEx(EditPart sourceEditPart) {
        super(sourceEditPart);
    }

    protected void updateTargetRequest() {
        super.updateTargetRequest();
        Dimension delta = this.getDragMoveDelta();
        if (this.getSourceEditPart() instanceof GraphicalEditPart) {
            Rectangle childRect = ((GraphicalEditPart)this.getSourceEditPart()).getFigure().getBounds();
            if (this.getSourceEditPart().getParent() instanceof GraphicalEditPart) {
                Rectangle parentRect = ((GraphicalEditPart)this.getSourceEditPart().getParent()).getFigure().getBounds();
                IFigure fig = ((GraphicalEditPart)this.getSourceEditPart().getParent()).getFigure();
                IFigure contentPane = ((GraphicalEditPart)this.getSourceEditPart().getParent()).getContentPane();
                Rectangle virtualPosition = childRect.getCopy();
                virtualPosition.x += delta.width;
                virtualPosition.y += delta.height;
                if (virtualPosition.x < 0) {
                    delta.width = 0 - childRect.x;
                }
                if (virtualPosition.y < 0) {
                    delta.height = 0 - childRect.y;
                }
                if (virtualPosition.x + virtualPosition.width + this.getBorder() > parentRect.width) {
                    delta.width = parentRect.width - childRect.width - childRect.x - this.getBorder();
                }
                if (virtualPosition.y + virtualPosition.height + 2 * this.getBorder() > parentRect.height) {
                    delta.height = parentRect.height - childRect.height - childRect.y - 2 * this.getBorder();
                }
                ChangeBoundsRequest request = this.getTargetRequest();
                Point moveDelta = new Point(delta.width, delta.height);
                request.setMoveDelta(moveDelta);
                this.setTargetEditPart(this.getSourceEditPart().getParent());
            }
        }
    }

    protected int getBorder() {
        return this.border;
    }

    protected void setBorder(int border) {
        this.border = border;
    }
}

