/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow.indicator;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeDetectUtil;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;

public class ColumnHideIndicatorEventMatcher
extends MouseEventMatcher {
    protected ILayer columnHeaderLayer;

    public ColumnHideIndicatorEventMatcher(int stateMask, String eventRegion, int button, ILayer columnHeaderLayer) {
        super(stateMask, eventRegion, button);
        this.columnHeaderLayer = columnHeaderLayer;
    }

    @Override
    public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
        return super.matches(natTable, event, regionLabels) && this.hasHiddenColumns(natTable, event);
    }

    private boolean hasHiddenColumns(ILayer natLayer, MouseEvent event) {
        int columnPosition = CellEdgeDetectUtil.getColumnPosition(natLayer, new Point(event.x, event.y));
        if (columnPosition < 0) {
            return false;
        }
        NatEventData eventData = NatEventData.createInstanceFromEvent(event);
        LabelStack customLabels = natLayer.getConfigLabelsByPosition(eventData.getColumnPosition(), this.columnHeaderLayer != null ? this.columnHeaderLayer.getRowCount() : eventData.getRowPosition());
        return customLabels.hasLabel("COLUMN_LEFT_HIDDEN") || customLabels.hasLabel("COLUMN_RIGHT_HIDDEN");
    }
}

