/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.modelelement;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.Configuration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.ElementDescriptor;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.IconDescriptor;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.PaletteconfigurationFactory;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.ToolConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.messages.Messages;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsFactory;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsPackage;
import org.eclipse.papyrus.infra.types.IconEntry;
import org.eclipse.papyrus.infra.ui.emf.databinding.EMFObservableValue;
import org.eclipse.papyrus.infra.widgets.Activator;

public class IconDescriptorObservableValue
extends EMFObservableValue {
    public IconDescriptorObservableValue(EObject eObject, EStructuralFeature eStructuralFeature, EditingDomain domain) {
        super(eObject, eStructuralFeature, domain);
    }

    protected void doSetValue(Object value) {
        CompoundCommand command = null;
        if (value instanceof String) {
            command = new CompoundCommand("set value");
            IconDescriptor descriptor = PaletteconfigurationFactory.eINSTANCE.createIconDescriptor();
            descriptor.setPluginID(Activator.retrieveBundleId((String)((String)value)));
            descriptor.setIconPath(Activator.retrieveLocalPath((String)((String)value)));
            command.append(this.getSetCommand(descriptor));
            Command setIconCommand = this.getSetElementTypeIconsCommand(descriptor);
            if (setIconCommand != null && setIconCommand.canExecute()) {
                command.append(setIconCommand);
            }
        } else {
            EObject eObject = EMFHelper.getEObject((Object)value);
            command = eObject != null ? this.getSetCommand(eObject) : this.getSetCommand(value);
        }
        if (command != null && command.canExecute()) {
            this.domain.getCommandStack().execute((Command)command);
        }
    }

    protected Object doGetValue() {
        String result = null;
        Object observed = this.getObserved();
        if (observed instanceof Configuration && ((Configuration)observed).getIcon() != null) {
            IconDescriptor icon = ((Configuration)observed).getIcon();
            result = Activator.getPath((String)icon.getPluginID(), (String)icon.getIconPath());
        }
        return result != null ? result : Messages.IconDescriptorObservableValue_Undefined;
    }

    private Command getSetElementTypeIconsCommand(IconDescriptor descriptor) {
        CompoundCommand command = new CompoundCommand();
        ElementTypeSetConfiguration uiElementTypeModel = this.getUIElementTypeModel();
        if (uiElementTypeModel != null && this.eObject instanceof ToolConfiguration) {
            for (ElementDescriptor elementDescriptor : ((ToolConfiguration)this.eObject).getElementDescriptors()) {
                ElementTypeConfiguration elementType = elementDescriptor.getElementType();
                if (elementType == null) continue;
                IconEntry icon = ElementTypesConfigurationsFactory.eINSTANCE.createIconEntry();
                icon.setBundleId(descriptor.getPluginID());
                icon.setIconPath(descriptor.getIconPath());
                command.append((Command)new SetCommand(this.domain, (EObject)elementType, (EStructuralFeature)ElementTypesConfigurationsPackage.eINSTANCE.getElementTypeConfiguration_IconEntry(), (Object)icon));
            }
        }
        return command;
    }

    private ElementTypeSetConfiguration getUIElementTypeModel() {
        Resource resource;
        EObject eObject;
        ElementTypeSetConfiguration elementTypeUI = null;
        Object object = this.domain.getResourceSet().getLoadOptions().get("resourceElementTypeUI");
        if (object instanceof Resource && (eObject = (EObject)(resource = (Resource)object).getContents().get(0)) instanceof ElementTypeSetConfiguration) {
            elementTypeUI = (ElementTypeSetConfiguration)eObject;
        }
        return elementTypeUI;
    }
}

