/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.commands;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.tools.AbstractConnectionCreationTool;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.editparts.IEditpartListenerAccess;
import org.eclipse.papyrus.uml.diagram.common.editparts.UMLConnectionNodeEditPart;

public class DeleteLinkDuringCreationCommand
extends DeleteCommand {
    protected Edge edge = null;
    protected EditPartViewer viewer = null;

    public DeleteLinkDuringCreationCommand(TransactionalEditingDomain editingDomain, Edge view, EditPartViewer viewer) {
        super(editingDomain, (View)view);
        assert (view != null);
        assert (viewer != null);
        this.edge = view;
        this.viewer = viewer;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        Map epRegistry = this.viewer.getEditPartRegistry();
        EditPartListener listenerToRemove = null;
        IGraphicalEditPart editPart = (IGraphicalEditPart)epRegistry.get(this.edge);
        if (editPart instanceof IEditpartListenerAccess) {
            Iterator iterlistener = ((UMLConnectionNodeEditPart)editPart).getEventListenerIterator(EditPartListener.class);
            while (iterlistener.hasNext()) {
                Object currentObject = iterlistener.next();
                Class<?> classobject = currentObject.getClass();
                Class<AbstractConnectionCreationTool> activeToolClass = AbstractConnectionCreationTool.class;
                String activeToolClassName = activeToolClass.getName();
                if (!classobject.getName().contains(activeToolClassName)) continue;
                listenerToRemove = (EditPartListener)currentObject;
            }
        }
        if (listenerToRemove != null) {
            editPart.removeEditPartListener(listenerToRemove);
        }
        CommandResult commandResult = super.doExecuteWithResult(progressMonitor, info);
        return commandResult;
    }
}

