/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.emf.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EObjectTreeElement;
import org.eclipse.papyrus.infra.services.labelprovider.service.IDetailLabelProvider;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.infra.ui.internal.emf.Activator;
import org.eclipse.papyrus.infra.ui.internal.emf.messages.Messages;
import org.eclipse.papyrus.infra.widgets.IFireDoubleClick;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.StringWithClearEditor;
import org.eclipse.papyrus.infra.widgets.providers.CollectionContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.PatternViewerFilter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class EMFGraphicalContentProvider
extends EncapsulatedContentProvider
implements ISelectionChangedListener {
    private static final String DIALOG_SETTINGS = EMFGraphicalContentProvider.class.getName();
    private static final String HISTORY_SETTINGS = "History";
    private static final String PREVIOUS_SELECTION = "PreviousSelection";
    private static final int HISTORY_MAX_SIZE = 15;
    private static final String ICONS_EXPAND_ALL = "/icons/expandAll.png";
    private static final String ICONS_COLLAPSE_ALL = "/icons/collapseAll.png";
    private ToolItem buttonExpand;
    private ToolItem buttonCollapse;
    private static final int MAX_SEARCH_DEPTH = 15;
    protected String historyId;
    protected ViewerFilter patternFilter;
    protected List<EObject> selectionHistory;
    protected CLabel detailLabel;
    protected Object selectedObject;
    protected StructuredViewer viewer;
    protected ResourceSet resourceSet;
    private String currentFilterPattern;
    private TableViewer historyViewer;
    private boolean buttonExpandCollapseEnable = true;

    public EMFGraphicalContentProvider(IStructuredContentProvider semanticProvider, ResourceSet resourceSet, String historyId) {
        super(semanticProvider);
        this.historyId = historyId;
        this.resourceSet = resourceSet;
    }

    public void createBefore(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        this.createPatternFilter(composite);
        this.createCaseSensitiveButton(composite);
    }

    public void createViewerToolbar(Composite parent) {
        this.createExpandCollapseButtons(parent);
    }

    protected void createExpandCollapseButtons(Composite parent) {
        ToolBar Toolbar = new ToolBar(parent, 0);
        this.buttonExpand = new ToolItem(Toolbar, 0);
        this.buttonExpand.setImage(Activator.getPluginIconImage("org.eclipse.papyrus.infra.widgets", ICONS_EXPAND_ALL));
        this.buttonExpand.setToolTipText(Messages.EMFGraphicalContentProvider_ExpandAllTooltip);
        this.buttonExpand.setEnabled(this.buttonExpandCollapseEnable);
        this.buttonExpand.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = EMFGraphicalContentProvider.this.viewer.getSelection();
                if (selection instanceof StructuredSelection && !selection.isEmpty()) {
                    Object[] objectArray = ((StructuredSelection)selection).toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        ((AbstractTreeViewer)EMFGraphicalContentProvider.this.viewer).expandToLevel(object, org.eclipse.papyrus.infra.widgets.Activator.getMaxLevelToExpandValue());
                        ++n2;
                    }
                } else {
                    ((AbstractTreeViewer)EMFGraphicalContentProvider.this.viewer).expandToLevel(org.eclipse.papyrus.infra.widgets.Activator.getMaxLevelToExpandValue());
                }
                EMFGraphicalContentProvider.this.viewer.refresh();
            }
        });
        this.buttonCollapse = new ToolItem(Toolbar, 0);
        this.buttonCollapse.setImage(Activator.getPluginIconImage("org.eclipse.papyrus.infra.widgets", ICONS_COLLAPSE_ALL));
        this.buttonCollapse.setToolTipText(Messages.EMFGraphicalContentProvider_CollapseAllTooltip);
        this.buttonCollapse.setEnabled(this.buttonExpandCollapseEnable);
        this.buttonCollapse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = ((AbstractTreeViewer)EMFGraphicalContentProvider.this.viewer).getSelection();
                if (selection instanceof StructuredSelection && !selection.isEmpty()) {
                    Object[] objectArray = ((StructuredSelection)selection).toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        ((AbstractTreeViewer)EMFGraphicalContentProvider.this.viewer).collapseToLevel(object, -1);
                        ++n2;
                    }
                } else {
                    ((AbstractTreeViewer)EMFGraphicalContentProvider.this.viewer).collapseAll();
                }
            }
        });
    }

    protected void createCaseSensitiveButton(Composite parent) {
        final Button checkBoxCaseSensitive = new Button(parent, 32);
        checkBoxCaseSensitive.setText(Messages.EMFGraphicalContentProvider_CaseSensitiveCheckBoxLabel);
        checkBoxCaseSensitive.setToolTipText(Messages.EMFGraphicalContentProvider_CaseSensitiveCheckBoxTooltip);
        checkBoxCaseSensitive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (EMFGraphicalContentProvider.this.patternFilter instanceof PatternViewerFilter) {
                    ((PatternViewerFilter)EMFGraphicalContentProvider.this.patternFilter).setIgnoreCase(!checkBoxCaseSensitive.getSelection());
                }
                EMFGraphicalContentProvider.this.viewer.refresh();
            }
        });
    }

    protected void createPatternFilter(Composite parent) {
        StringWithClearEditor editor = new StringWithClearEditor(parent, 2048);
        editor.setToolTipText(Messages.EMFGraphicalContentProvider_FilterFieldTooltip);
        editor.setValidateOnDelay(org.eclipse.papyrus.infra.widgets.Activator.getValidationDelay());
        editor.setValidateOnDelay(org.eclipse.papyrus.infra.widgets.Activator.isFilterValidateOnDelay());
        if (org.eclipse.papyrus.infra.widgets.Activator.isStereotypeDelimitersReplaced()) {
            editor.addStringToReplace("<<", "\u00ab");
            editor.addStringToReplace(">>", "\u00bb");
        } else {
            editor.clearStringToReplace();
        }
        GridLayoutFactory.fillDefaults().applyTo((Composite)editor);
        editor.setLayoutData((Object)new GridData(4, 4, true, false));
        this.patternFilter = new PatternViewerFilter();
        this.currentFilterPattern = "*";
        ((PatternViewerFilter)this.patternFilter).setPattern(this.currentFilterPattern);
        editor.setValue((Object)this.currentFilterPattern);
        editor.addCommitListener(new ICommitListener(){

            public void commit(AbstractEditor editor) {
                String filterPattern = ((StringWithClearEditor)editor).getValue();
                if (!filterPattern.equals(EMFGraphicalContentProvider.this.currentFilterPattern)) {
                    ((PatternViewerFilter)EMFGraphicalContentProvider.this.patternFilter).setPattern(filterPattern);
                    List<ViewerFilter> filtersAsList = Arrays.asList(EMFGraphicalContentProvider.this.viewer.getFilters());
                    if (!filtersAsList.contains(EMFGraphicalContentProvider.this.patternFilter)) {
                        EMFGraphicalContentProvider.this.viewer.addFilter(EMFGraphicalContentProvider.this.patternFilter);
                    }
                    EMFGraphicalContentProvider.this.viewer.refresh();
                    if (!"".equals(filterPattern) && !EMFGraphicalContentProvider.this.currentFilterPattern.equals(filterPattern)) {
                        EMFGraphicalContentProvider.this.findAndRevealFirstMatchingItem();
                        EMFGraphicalContentProvider.this.currentFilterPattern = filterPattern;
                    }
                }
            }
        });
        editor.getText().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    EMFGraphicalContentProvider.this.viewer.getControl().setFocus();
                }
            }
        });
    }

    protected EObject findAndRevealFirstMatchingItem() {
        Tree tree;
        if (this.viewer instanceof TreeViewer && (tree = ((TreeViewer)this.viewer).getTree()).getItems().length > 0) {
            return this.revealFirstLeaf(tree.getItem(0), 15);
        }
        return null;
    }

    private EObject revealFirstLeaf(TreeItem item, int maxSearchDepth) {
        if (maxSearchDepth < 1 || !(this.viewer instanceof TreeViewer)) {
            return null;
        }
        TreeViewer treeViewer = (TreeViewer)this.viewer;
        Object[] itemDataArray = Collections.singletonList(item.getData()).toArray();
        treeViewer.setExpandedElements(itemDataArray);
        if (item.getItems().length > 0) {
            return this.revealFirstLeaf(item.getItem(0), maxSearchDepth - 1);
        }
        Object data = item.getData();
        if (data instanceof EObjectTreeElement) {
            EObject semanticElement = ((EObjectTreeElement)data).getEObject();
            this.revealSemanticElement(Collections.singletonList(semanticElement));
            return semanticElement;
        }
        return null;
    }

    @Deprecated
    protected Object getFirstMatchingElement(Object parent) {
        if (parent == null) {
            Object[] objectArray = this.getElements(this.viewer.getInput());
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object parentElement = objectArray[n2];
                Object firstMatch = this.getFirstMatchingElement(parentElement);
                if (firstMatch != null) {
                    return firstMatch;
                }
                ++n2;
            }
            return null;
        }
        Object[] objectArray = this.viewer.getFilters();
        int n = objectArray.length;
        int n3 = 0;
        while (n3 < n) {
            ViewerFilter filter = objectArray[n3];
            if (!filter.select((Viewer)this.viewer, this.getParent(parent), parent)) {
                return null;
            }
            ++n3;
        }
        if (this.isValidValue(parent)) {
            return parent;
        }
        objectArray = this.getChildren(parent);
        n = objectArray.length;
        n3 = 0;
        while (n3 < n) {
            ViewerFilter childElement = objectArray[n3];
            Object firstMatch = this.getFirstMatchingElement(childElement);
            if (firstMatch != null) {
                return firstMatch;
            }
            ++n3;
        }
        return null;
    }

    public void createAfter(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.createHistory(parent);
        this.createDetailArea(parent);
    }

    protected void createHistory(Composite parent) {
        this.initSelectionHistory();
        Group historyGroup = new Group(parent, 0);
        historyGroup.setText(Messages.EMFGraphicalContentProvider_historyGroupLabel);
        historyGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        historyGroup.setLayout((Layout)new GridLayout(1, true));
        Table historyTable = new Table((Composite)historyGroup, 2052);
        GridData data = new GridData(4, 4, true, false);
        data.heightHint = 70;
        historyTable.setLayoutData((Object)data);
        this.historyViewer = new TableViewer(historyTable);
        this.historyViewer.setContentProvider((IContentProvider)CollectionContentProvider.instance);
        this.historyViewer.setLabelProvider((IBaseLabelProvider)new LabelProviderServiceImpl().getLabelProvider());
        this.historyViewer.setInput(this.selectionHistory);
        this.historyViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)EMFGraphicalContentProvider.this.historyViewer.getSelection();
                Object selectedObject = selection.getFirstElement();
                if (selectedObject instanceof EObject) {
                    EObject eObject = (EObject)selectedObject;
                    EMFGraphicalContentProvider.this.revealSemanticElement(Collections.singletonList(eObject));
                }
            }
        });
        this.historyViewer.addDoubleClickListener(event -> {
            if (this.viewer instanceof IFireDoubleClick) {
                ((IFireDoubleClick)this.viewer).fireDoubleClick(new DoubleClickEvent((Viewer)this.viewer, event.getSelection()));
            }
        });
    }

    protected void initSelectionHistory() {
        String[] uriHistory;
        this.selectionHistory = new ArrayList<EObject>(16);
        IDialogSettings historySettings = this.getDialogSettings().getSection(HISTORY_SETTINGS);
        if (historySettings != null && this.resourceSet != null && (uriHistory = historySettings.getArray(PREVIOUS_SELECTION)) != null) {
            String[] stringArray = uriHistory;
            int n = uriHistory.length;
            int n2 = 0;
            while (n2 < n) {
                String uri = stringArray[n2];
                try {
                    EObject object = this.resourceSet.getEObject(URI.createURI((String)uri), true);
                    if (object != null && !this.selectionHistory.contains(object)) {
                        this.selectionHistory.add(object);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }

    @Deprecated
    protected void createMetaclassFilter(Composite parent) {
    }

    protected void createDetailArea(Composite parent) {
        this.detailLabel = new CLabel(parent, 2048);
        this.detailLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.updateDetailLabel();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(this.getDialogSettingsIdentifier());
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(this.getDialogSettingsIdentifier());
        }
        return settings;
    }

    private String getDialogSettingsIdentifier() {
        return DIALOG_SETTINGS + "_" + this.historyId;
    }

    protected void storeDialog(IDialogSettings settings, Collection<EObject> newValues) {
        this.selectionHistory.removeAll(newValues);
        this.selectionHistory.addAll(0, newValues);
        if (this.selectionHistory.size() > 15) {
            this.selectionHistory = this.selectionHistory.subList(0, 15);
        }
        ArrayList<String> uriList = new ArrayList<String>();
        for (EObject object : this.selectionHistory) {
            URI uri = EcoreUtil.getURI((EObject)object);
            uriList.add(uri.toString());
        }
        IDialogSettings historySettings = settings.getSection(HISTORY_SETTINGS);
        if (historySettings == null) {
            historySettings = settings.addNewSection(HISTORY_SETTINGS);
        }
        historySettings.put(PREVIOUS_SELECTION, uriList.toArray(new String[uriList.size()]));
        this.historyViewer.setInput(this.selectionHistory);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.encapsulated.inputChanged(viewer, oldInput, newInput);
        if (viewer instanceof StructuredViewer) {
            this.viewer = (StructuredViewer)viewer;
            if (newInput != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
                this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        } else {
            this.viewer = null;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectedObject = ((IStructuredSelection)event.getSelection()).getFirstElement();
        this.updateDetailLabel();
    }

    private void updateDetailLabel() {
        if (this.detailLabel == null || this.detailLabel.isDisposed()) {
            return;
        }
        if (this.selectedObject == null) {
            this.detailLabel.setText("");
            this.detailLabel.setImage(null);
        } else {
            ILabelProvider labelProvider = (ILabelProvider)this.viewer.getLabelProvider();
            String description = labelProvider instanceof IDetailLabelProvider ? ((IDetailLabelProvider)labelProvider).getDetail(this.selectedObject) : labelProvider.getText(this.selectedObject);
            this.detailLabel.setText(description);
            this.detailLabel.setImage(labelProvider.getImage(this.selectedObject));
        }
        this.detailLabel.getParent().getParent().layout();
    }

    public void commit(AbstractEditor editor) {
        Iterator selectionIterator = ((IStructuredSelection)this.viewer.getSelection()).iterator();
        LinkedHashSet<EObject> eObjectsToStore = new LinkedHashSet<EObject>();
        while (selectionIterator.hasNext()) {
            Object semanticObject;
            Object selectedElement = selectionIterator.next();
            if (!this.isValidValue(selectedElement) || !((semanticObject = this.getAdaptedValue(selectedElement)) instanceof EObject)) continue;
            eObjectsToStore.add((EObject)semanticObject);
        }
        if (!eObjectsToStore.isEmpty()) {
            this.storeDialog(this.getDialogSettings(), eObjectsToStore);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.viewer != null) {
            this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public void setFlat(boolean isFlat) {
        super.setFlat(isFlat);
        if (this.patternFilter instanceof PatternViewerFilter) {
            ((PatternViewerFilter)this.patternFilter).clearCache();
        }
        if (this.viewer != null) {
            this.viewer.refresh();
        }
        if (this.buttonCollapse != null && this.buttonExpand != null) {
            this.buttonExpandCollapseEnable = !isFlat;
            this.buttonExpand.setEnabled(this.buttonExpandCollapseEnable);
            this.buttonCollapse.setEnabled(this.buttonExpandCollapseEnable);
        }
    }
}

