/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.resource;

import com.google.common.collect.SetMultimap;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.emf.internal.resource.AbstractCrossReferenceIndex;
import org.eclipse.papyrus.infra.emf.internal.resource.CrossReferenceIndex;
import org.eclipse.papyrus.infra.emf.internal.resource.InternalIndexUtil;
import org.eclipse.papyrus.infra.emf.internal.resource.OnDemandCrossReferenceIndex;

public interface ICrossReferenceIndex {
    public static ICrossReferenceIndex getInstance(ResourceSet resourceSet) {
        AbstractCrossReferenceIndex result = !EcorePlugin.IS_ECLIPSE_RUNNING || Job.getJobManager().isSuspended() ? new OnDemandCrossReferenceIndex(InternalIndexUtil.getSemanticModelFileExtensions(resourceSet)) : CrossReferenceIndex.getInstance();
        return result;
    }

    public static ICrossReferenceIndex getAlternate(ICrossReferenceIndex index, ResourceSet resourceSet) {
        return index instanceof OnDemandCrossReferenceIndex ? null : new OnDemandCrossReferenceIndex(resourceSet);
    }

    public ListenableFuture<SetMultimap<URI, URI>> getOutgoingCrossReferencesAsync();

    public SetMultimap<URI, URI> getOutgoingCrossReferences() throws CoreException;

    public ListenableFuture<Set<URI>> getOutgoingCrossReferencesAsync(URI var1);

    public Set<URI> getOutgoingCrossReferences(URI var1) throws CoreException;

    public ListenableFuture<SetMultimap<URI, URI>> getIncomingCrossReferencesAsync();

    public SetMultimap<URI, URI> getIncomingCrossReferences() throws CoreException;

    public ListenableFuture<Set<URI>> getIncomingCrossReferencesAsync(URI var1);

    public Set<URI> getIncomingCrossReferences(URI var1) throws CoreException;

    public ListenableFuture<Boolean> isShardAsync(URI var1);

    public boolean isShard(URI var1) throws CoreException;

    public ListenableFuture<SetMultimap<URI, URI>> getSubunitsAsync();

    public SetMultimap<URI, URI> getSubunits() throws CoreException;

    public ListenableFuture<Set<URI>> getSubunitsAsync(URI var1);

    public ListenableFuture<Set<URI>> getSubunitsAsync(URI var1, boolean var2);

    public Set<URI> getSubunits(URI var1) throws CoreException;

    public Set<URI> getSubunits(URI var1, boolean var2) throws CoreException;

    public ListenableFuture<Set<URI>> getParentsAsync(URI var1);

    public ListenableFuture<Set<URI>> getParentsAsync(URI var1, boolean var2);

    public Set<URI> getParents(URI var1) throws CoreException;

    public Set<URI> getParents(URI var1, ICrossReferenceIndex var2) throws CoreException;

    public Set<URI> getParents(URI var1, boolean var2) throws CoreException;

    public Set<URI> getParents(URI var1, boolean var2, ICrossReferenceIndex var3) throws CoreException;

    public ListenableFuture<Set<URI>> getRootsAsync(URI var1);

    public ListenableFuture<Set<URI>> getRootsAsync(URI var1, boolean var2);

    public Set<URI> getRoots(URI var1) throws CoreException;

    public Set<URI> getRoots(URI var1, ICrossReferenceIndex var2) throws CoreException;

    public Set<URI> getRoots(URI var1, boolean var2) throws CoreException;

    public Set<URI> getRoots(URI var1, boolean var2, ICrossReferenceIndex var3) throws CoreException;

    public static class Delegator
    implements ICrossReferenceIndex {
        private final ResourceSet resourceSet;

        public Delegator(ResourceSet resourceSet) {
            this.resourceSet = resourceSet;
        }

        protected final ResourceSet getResourceSet() {
            return this.resourceSet;
        }

        protected ICrossReferenceIndex getDelegate() {
            ICrossReferenceIndex result = ICrossReferenceIndex.getInstance(this.getResourceSet());
            if (InternalIndexUtil.isTracing()) {
                String indexName = result instanceof CrossReferenceIndex ? "standard index" : (result instanceof OnDemandCrossReferenceIndex ? "on-demand index" : result.getClass().getSimpleName());
                StackTraceElement[] stack = Thread.currentThread().getStackTrace();
                String calling = stack.length >= 3 ? stack[2].getMethodName() : "<unknown>";
                InternalIndexUtil.tracef("Delegating to %s for ICrossReferenceIndex::%s", indexName, calling);
            }
            return result;
        }

        @Override
        public ListenableFuture<SetMultimap<URI, URI>> getOutgoingCrossReferencesAsync() {
            return this.getDelegate().getOutgoingCrossReferencesAsync();
        }

        @Override
        public SetMultimap<URI, URI> getOutgoingCrossReferences() throws CoreException {
            return this.getDelegate().getOutgoingCrossReferences();
        }

        @Override
        public ListenableFuture<Set<URI>> getOutgoingCrossReferencesAsync(URI resourceURI) {
            return this.getDelegate().getOutgoingCrossReferencesAsync(resourceURI);
        }

        @Override
        public Set<URI> getOutgoingCrossReferences(URI resourceURI) throws CoreException {
            return this.getDelegate().getOutgoingCrossReferences(resourceURI);
        }

        @Override
        public ListenableFuture<SetMultimap<URI, URI>> getIncomingCrossReferencesAsync() {
            return this.getDelegate().getIncomingCrossReferencesAsync();
        }

        @Override
        public SetMultimap<URI, URI> getIncomingCrossReferences() throws CoreException {
            return this.getDelegate().getIncomingCrossReferences();
        }

        @Override
        public ListenableFuture<Set<URI>> getIncomingCrossReferencesAsync(URI resourceURI) {
            return this.getDelegate().getIncomingCrossReferencesAsync(resourceURI);
        }

        @Override
        public Set<URI> getIncomingCrossReferences(URI resourceURI) throws CoreException {
            return this.getDelegate().getIncomingCrossReferences(resourceURI);
        }

        @Override
        public ListenableFuture<Boolean> isShardAsync(URI resourceURI) {
            return this.getDelegate().isShardAsync(resourceURI);
        }

        @Override
        public boolean isShard(URI resourceURI) throws CoreException {
            return this.getDelegate().isShard(resourceURI);
        }

        @Override
        public ListenableFuture<SetMultimap<URI, URI>> getSubunitsAsync() {
            return this.getDelegate().getSubunitsAsync();
        }

        @Override
        public SetMultimap<URI, URI> getSubunits() throws CoreException {
            return this.getDelegate().getSubunits();
        }

        @Override
        public ListenableFuture<Set<URI>> getSubunitsAsync(URI resourceURI) {
            return this.getDelegate().getSubunitsAsync(resourceURI);
        }

        @Override
        public ListenableFuture<Set<URI>> getSubunitsAsync(URI resourceURI, boolean shardOnly) {
            return this.getDelegate().getSubunitsAsync(resourceURI, shardOnly);
        }

        @Override
        public Set<URI> getSubunits(URI resourceURI) throws CoreException {
            return this.getDelegate().getSubunits(resourceURI);
        }

        @Override
        public Set<URI> getSubunits(URI resourceURI, boolean shardOnly) throws CoreException {
            return this.getDelegate().getSubunits(resourceURI, shardOnly);
        }

        @Override
        public ListenableFuture<Set<URI>> getParentsAsync(URI shardURI) {
            return this.getDelegate().getParentsAsync(shardURI);
        }

        @Override
        public ListenableFuture<Set<URI>> getParentsAsync(URI resourceURI, boolean shardOnly) {
            return this.getDelegate().getParentsAsync(resourceURI, shardOnly);
        }

        @Override
        public Set<URI> getParents(URI shardURI) throws CoreException {
            ICrossReferenceIndex primary = this.getDelegate();
            ICrossReferenceIndex alternate = ICrossReferenceIndex.getAlternate(primary, this.getResourceSet());
            return primary.getParents(shardURI, alternate);
        }

        @Override
        public Set<URI> getParents(URI resourceURI, boolean shardOnly) throws CoreException {
            ICrossReferenceIndex primary = this.getDelegate();
            ICrossReferenceIndex alternate = ICrossReferenceIndex.getAlternate(primary, this.getResourceSet());
            return primary.getParents(resourceURI, shardOnly, alternate);
        }

        @Override
        public Set<URI> getParents(URI subunitURI, ICrossReferenceIndex alternate) throws CoreException {
            return this.getDelegate().getParents(subunitURI, alternate);
        }

        @Override
        public Set<URI> getParents(URI subunitURI, boolean shardOnly, ICrossReferenceIndex alternate) throws CoreException {
            return this.getDelegate().getParents(subunitURI, shardOnly, alternate);
        }

        @Override
        public ListenableFuture<Set<URI>> getRootsAsync(URI shardURI) {
            return this.getDelegate().getRootsAsync(shardURI);
        }

        @Override
        public ListenableFuture<Set<URI>> getRootsAsync(URI resourceURI, boolean shardOnly) {
            return this.getDelegate().getRootsAsync(resourceURI, shardOnly);
        }

        @Override
        public Set<URI> getRoots(URI shardURI) throws CoreException {
            ICrossReferenceIndex primary = this.getDelegate();
            ICrossReferenceIndex alternate = ICrossReferenceIndex.getAlternate(primary, this.getResourceSet());
            return primary.getRoots(shardURI, alternate);
        }

        @Override
        public Set<URI> getRoots(URI subunitURI, ICrossReferenceIndex alternate) throws CoreException {
            return this.getDelegate().getRoots(subunitURI, alternate);
        }

        @Override
        public Set<URI> getRoots(URI resourceURI, boolean shardOnly) throws CoreException {
            ICrossReferenceIndex primary = this.getDelegate();
            ICrossReferenceIndex alternate = ICrossReferenceIndex.getAlternate(primary, this.getResourceSet());
            return primary.getRoots(resourceURI, shardOnly, alternate);
        }

        @Override
        public Set<URI> getRoots(URI subunitURI, boolean shardOnly, ICrossReferenceIndex alternate) throws CoreException {
            return this.getDelegate().getRoots(subunitURI, shardOnly, alternate);
        }
    }
}

