/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.types.core.commands.StereotypePropertyReferenceEdgeUtil;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class StereotypePropertyReferenceSetEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getAfterSetCommand(SetRequest request) {
        EObject element = request.getElementToEdit();
        View view = StereotypePropertyReferenceEdgeUtil.findViewFromStereotype((EObject)element);
        TransactionalEditingDomain editingDomain = request.getEditingDomain();
        if (view != null) {
            EStructuralFeature structuralFeature = request.getFeature();
            Object value = request.getValue();
            if (structuralFeature instanceof EReference) {
                String stereotypeQualifyName;
                String featureName = structuralFeature.getName();
                Stereotype stereotype = UMLUtil.getStereotype((EObject)element);
                if (stereotype != null && (stereotypeQualifyName = stereotype.getQualifiedName()) != null && featureName != null) {
                    CompositeCommand command = new CompositeCommand("Clear stereotype property reference links");
                    for (Object edge : ViewUtil.getSourceConnections((View)view)) {
                        ICommand result;
                        if (!(edge instanceof Edge) || !"StereotypePropertyReferenceEdge".equals(((View)edge).getType())) continue;
                        Edge edgeToDestroy = null;
                        if (!StereotypePropertyReferenceEdgeUtil.checkNotOrphanStereotypePropertyReferenceEdgeNotYetSet((Edge)((Edge)edge), (String)stereotypeQualifyName, (String)featureName, (Object)value)) {
                            edgeToDestroy = (Edge)edge;
                        }
                        if (edgeToDestroy == null) continue;
                        DestroyElementRequest destroy = new DestroyElementRequest(editingDomain, (EObject)edgeToDestroy, false);
                        Object eHelperContext = destroy.getEditHelperContext();
                        IElementType context = ElementTypeRegistry.getInstance().getElementType(eHelperContext);
                        if (context == null || (result = context.getEditCommand((IEditCommandRequest)destroy)) == null) continue;
                        command.add((IUndoableOperation)result);
                    }
                    return command.isEmpty() ? null : command;
                }
            }
        }
        return null;
    }
}

