/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.uml.service.types.helper.ElementEditHelper;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Vertex;

public class TransitionEditHelper
extends ElementEditHelper {
    protected boolean canCreate(EObject source, EObject target) {
        if (!(source instanceof Vertex)) {
            return false;
        }
        if (target == null) {
            return true;
        }
        return true;
    }

    protected ICommand getCreateRelationshipCommand(CreateRelationshipRequest req) {
        EObject source = req.getSource();
        EObject target = req.getTarget();
        if (!(source instanceof Vertex)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (target == null) {
            return IdentityCommand.INSTANCE;
        }
        if (!(target instanceof Vertex)) {
            return UnexecutableCommand.INSTANCE;
        }
        Region container = (Region)TypeUtils.as((Object)req.getContainer(), Region.class);
        if (container == null && (container = this.findRegionContainer((Vertex)source)) == null && (container = this.findRegionContainer((Vertex)target)) == null && (container = this.getFirstRegionStateMachine((Vertex)source)) == null) {
            return UnexecutableCommand.INSTANCE;
        }
        this.setContainerAndFeature(req, container);
        return super.getCreateRelationshipCommand(req);
    }

    private void setContainerAndFeature(CreateRelationshipRequest req, Region container) {
        req.setContainer((EObject)container);
        req.setContainmentFeature(UMLPackage.eINSTANCE.getRegion_Transition());
    }

    private Region findRegionContainer(Vertex source) {
        if (source == null || source.eContainer() == null) {
            return null;
        }
        if (source.eContainer() instanceof Vertex) {
            return this.findRegionContainer((Vertex)source.eContainer());
        }
        return source.eContainer() instanceof Region ? (Region)source.eContainer() : null;
    }

    private Region getFirstRegionStateMachine(Vertex source) {
        EObject eContainer = source.eContainer();
        if (eContainer != null) {
            if (eContainer instanceof StateMachine) {
                EList regions = ((StateMachine)eContainer).getRegions();
                if (!regions.isEmpty()) {
                    return (Region)regions.get(0);
                }
            } else if (eContainer instanceof Vertex) {
                return this.findRegionContainer((Vertex)eContainer);
            }
        }
        return null;
    }

    @Override
    protected ICommand getConfigureCommand(final ConfigureRequest req) {
        ConfigureElementCommand configureCommand = new ConfigureElementCommand(req){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                EObject elementToConfigure = req.getElementToConfigure();
                if (!(elementToConfigure instanceof Transition)) {
                    return CommandResult.newErrorCommandResult((String)("This configure command should be run against a transition. element to configure was: " + String.valueOf(elementToConfigure)));
                }
                Transition transition = (Transition)elementToConfigure;
                Object source = req.getParameter("CreateRelationshipRequest.source");
                Object target = req.getParameter("CreateRelationshipRequest.target");
                if (source instanceof Vertex) {
                    transition.setSource((Vertex)source);
                }
                if (target instanceof Vertex) {
                    transition.setTarget((Vertex)target);
                }
                return CommandResult.newOKCommandResult((Object)transition);
            }
        };
        return CompositeCommand.compose((ICommand)configureCommand, (ICommand)super.getConfigureCommand(req));
    }

    protected ICommand getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        return new ReorientTransitionCommand(req);
    }

    private static class ReorientTransitionCommand
    extends EditElementCommand {
        private final EObject myNewEnd;
        private final int myReorientDirection;

        protected ReorientTransitionCommand(ReorientRelationshipRequest req) {
            super("Reorient Transition Command", req.getRelationship(), (IEditCommandRequest)req);
            this.myNewEnd = req.getNewRelationshipEnd();
            this.myReorientDirection = req.getDirection();
        }

        public boolean canExecute() {
            if (!(this.myNewEnd instanceof Vertex)) {
                return false;
            }
            if (!(this.getElementToEdit() instanceof Transition)) {
                return false;
            }
            if (this.myReorientDirection != 1 && this.myReorientDirection != 2) {
                return false;
            }
            return super.canExecute();
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            Transition link = (Transition)this.getElementToEdit();
            Vertex newLinkEnd = (Vertex)this.myNewEnd;
            if (this.myReorientDirection == 1) {
                link.setSource(newLinkEnd);
            } else if (this.myReorientDirection == 2) {
                link.setTarget(newLinkEnd);
            } else {
                return CommandResult.newErrorCommandResult((String)"Wrong direction");
            }
            return CommandResult.newOKCommandResult();
        }
    }
}

