/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.core.factories.impl;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.IconEntry;
import org.eclipse.papyrus.infra.types.core.factories.IElementTypeConfigurationFactory;
import org.osgi.framework.Bundle;

public abstract class AbstractElementTypeConfigurationFactory<T extends ElementTypeConfiguration>
implements IElementTypeConfigurationFactory<T> {
    protected String getDisplayName(T elementTypeConfiguration) {
        return elementTypeConfiguration.getName();
    }

    protected URL getIconURL(T elementTypeConfiguration) {
        IconEntry entry = elementTypeConfiguration.getIconEntry();
        URL iconURL = null;
        if (entry != null) {
            iconURL = this.getURLFromEntry(entry);
        }
        return iconURL;
    }

    protected String getID(T elementTypeConfiguration) {
        return elementTypeConfiguration.getIdentifier();
    }

    protected String getSemanticHint(T elementTypeConfiguration) {
        return elementTypeConfiguration.getHint();
    }

    protected URL getURLFromEntry(IconEntry entry) {
        Bundle bundle = Platform.getBundle((String)entry.getBundleId());
        if (bundle == null) {
            return null;
        }
        URL result = bundle.getEntry(entry.getIconPath());
        if (result == null) {
            try {
                result = new URL(entry.getIconPath());
            }
            catch (MalformedURLException e) {
                result = null;
            }
        }
        return result;
    }
}

