/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.scaling;

import java.util.function.Consumer;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.NatTableConfigAttributes;
import org.eclipse.nebula.widgets.nattable.layer.FixedScalingDpiConverter;
import org.eclipse.nebula.widgets.nattable.layer.IDpiConverter;
import org.eclipse.nebula.widgets.nattable.layer.command.ConfigureScalingCommand;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;

public final class ScalingUtil {
    private ScalingUtil() {
    }

    public static void zoomIn(NatTable natTable, Consumer<IConfigRegistry> registryUpdater) {
        IConfigRegistry configRegistry = natTable.getConfigRegistry();
        IDpiConverter hDpiConverter = configRegistry.getConfigAttribute(NatTableConfigAttributes.HORIZONTAL_DPI_CONVERTER, DisplayMode.NORMAL, new String[0]);
        int hdpi = hDpiConverter.getDpi();
        int newHorizontalDpi = ScalingUtil.getNewZoomInDPI(hdpi);
        IDpiConverter vDpiConverter = configRegistry.getConfigAttribute(NatTableConfigAttributes.VERTICAL_DPI_CONVERTER, DisplayMode.NORMAL, new String[0]);
        int vdpi = vDpiConverter.getDpi();
        int newVerticalDpi = ScalingUtil.getNewZoomInDPI(vdpi);
        if (hdpi != newHorizontalDpi || vdpi != newVerticalDpi) {
            natTable.doCommand(new ConfigureScalingCommand(new FixedScalingDpiConverter(newHorizontalDpi), new FixedScalingDpiConverter(newVerticalDpi)));
            if (registryUpdater != null) {
                registryUpdater.accept(configRegistry);
            }
            natTable.refresh(false);
        }
    }

    public static void zoomOut(NatTable natTable, Consumer<IConfigRegistry> registryUpdater) {
        IConfigRegistry configRegistry = natTable.getConfigRegistry();
        IDpiConverter hDpiConverter = configRegistry.getConfigAttribute(NatTableConfigAttributes.HORIZONTAL_DPI_CONVERTER, DisplayMode.NORMAL, new String[0]);
        int hdpi = hDpiConverter.getDpi();
        int newHorizontalDpi = ScalingUtil.getNewZoomOutDPI(hdpi);
        IDpiConverter vDpiConverter = configRegistry.getConfigAttribute(NatTableConfigAttributes.VERTICAL_DPI_CONVERTER, DisplayMode.NORMAL, new String[0]);
        int vdpi = vDpiConverter.getDpi();
        int newVerticalDpi = ScalingUtil.getNewZoomOutDPI(vdpi);
        if (hdpi != newHorizontalDpi || vdpi != newVerticalDpi) {
            natTable.doCommand(new ConfigureScalingCommand(new FixedScalingDpiConverter(newHorizontalDpi), new FixedScalingDpiConverter(newVerticalDpi)));
            if (registryUpdater != null) {
                registryUpdater.accept(configRegistry);
            }
            natTable.refresh(false);
        }
    }

    public static int getNewZoomOutDPI(int currentDPI) {
        int dpi = currentDPI;
        if (currentDPI == 288) {
            dpi = 192;
        } else if (currentDPI == 192) {
            dpi = 144;
        } else if (currentDPI == 144) {
            dpi = 120;
        } else if (currentDPI == 120) {
            dpi = 96;
        } else if (currentDPI <= 96) {
            dpi = Math.max(12, dpi / 2);
        }
        return dpi;
    }

    public static int getNewZoomInDPI(int currentDPI) {
        int dpi = currentDPI;
        if (currentDPI == 192) {
            dpi = 288;
        } else if (currentDPI == 144) {
            dpi = 192;
        } else if (currentDPI == 120) {
            dpi = 144;
        } else if (currentDPI == 96) {
            dpi = 120;
        } else if (currentDPI < 96) {
            dpi *= 2;
        }
        return dpi;
    }
}

