/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.performance.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderEndCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class GroupColumnReorderEndCommandHandler
extends AbstractLayerCommandHandler<ColumnReorderEndCommand> {
    private final ColumnGroupHeaderLayer columnGroupHeaderLayer;

    public GroupColumnReorderEndCommandHandler(ColumnGroupHeaderLayer columnGroupHeaderLayer) {
        this.columnGroupHeaderLayer = columnGroupHeaderLayer;
    }

    @Override
    protected boolean doCommand(ColumnReorderEndCommand command) {
        boolean reorderToLeftEdge;
        int toColumnPosition;
        int fromColumnPosition = this.columnGroupHeaderLayer.getReorderFromColumnPosition();
        boolean isValid = ColumnGroupUtils.isReorderValid(this.columnGroupHeaderLayer, fromColumnPosition, toColumnPosition = command.getToColumnPosition(), reorderToLeftEdge = command.isReorderToLeftEdge());
        if (isValid) {
            int fromIndex = this.columnGroupHeaderLayer.getPositionLayer().getColumnIndexByPosition(fromColumnPosition);
            int toIndex = this.columnGroupHeaderLayer.getPositionLayer().getColumnIndexByPosition(toColumnPosition);
            SelectionLayer.MoveDirectionEnum moveDirection = PositionUtil.getHorizontalMoveDirection(fromColumnPosition, toColumnPosition);
            int fromPositionToCheck = fromColumnPosition;
            int toPositionToCheck = toColumnPosition;
            if (SelectionLayer.MoveDirectionEnum.RIGHT == moveDirection && reorderToLeftEdge) {
                --toPositionToCheck;
            }
            boolean toggleCoordinateByEdge = false;
            GroupModel.Group groupToEnd = null;
            GroupModel.Group groupToStart = null;
            int level = 0;
            while (level < this.columnGroupHeaderLayer.getLevelCount()) {
                GroupModel.Group fromGroup = this.columnGroupHeaderLayer.getGroupByPosition(level, fromPositionToCheck);
                GroupModel.Group toGroup = this.columnGroupHeaderLayer.getGroupByPosition(level, toPositionToCheck);
                if (fromGroup != null && fromGroup.isCollapsed() && (!ColumnGroupUtils.isInTheSameGroup(this.columnGroupHeaderLayer, level, fromPositionToCheck, toPositionToCheck) || fromPositionToCheck == toPositionToCheck)) {
                    this.columnGroupHeaderLayer.expandGroup(this.columnGroupHeaderLayer.getGroupModel(level), fromGroup);
                    if (moveDirection != SelectionLayer.MoveDirectionEnum.RIGHT) {
                        fromPositionToCheck = this.columnGroupHeaderLayer.getPositionLayer().getColumnPositionByIndex(fromIndex);
                        this.columnGroupHeaderLayer.setReorderFromColumnPosition(fromPositionToCheck);
                    } else {
                        toPositionToCheck = this.columnGroupHeaderLayer.getPositionLayer().getColumnPositionByIndex(toIndex);
                        command.updateToColumnPosition(toPositionToCheck);
                        if (SelectionLayer.MoveDirectionEnum.RIGHT == moveDirection && reorderToLeftEdge) {
                            --toPositionToCheck;
                        }
                    }
                }
                if (toGroup != null && SelectionLayer.MoveDirectionEnum.RIGHT == moveDirection && toGroup.isGroupEnd(toPositionToCheck)) {
                    toggleCoordinateByEdge = true;
                    if (toGroup.isUnbreakable() && toGroup.getVisibleSpan() < toGroup.getOriginalSpan()) {
                        groupToEnd = toGroup;
                    }
                } else if (toGroup != null && SelectionLayer.MoveDirectionEnum.LEFT == moveDirection && toGroup.isGroupStart(toPositionToCheck) && toGroup.isUnbreakable() && toGroup.getVisibleSpan() < toGroup.getOriginalSpan()) {
                    groupToStart = toGroup;
                }
                ++level;
            }
            if (toggleCoordinateByEdge) {
                command.toggleCoordinateByEdge();
            }
            if (groupToEnd != null) {
                return this.columnGroupHeaderLayer.getPositionLayer().getUnderlyingLayerByPosition(0, 0).doCommand(new ColumnReorderEndToGroupEndCommand(command, groupToEnd));
            }
            if (groupToStart != null) {
                return this.columnGroupHeaderLayer.getPositionLayer().getUnderlyingLayerByPosition(0, 0).doCommand(new ColumnReorderEndToGroupStartCommand(command, groupToStart));
            }
        }
        return !isValid;
    }

    @Override
    public Class<ColumnReorderEndCommand> getCommandClass() {
        return ColumnReorderEndCommand.class;
    }

    class ColumnReorderEndToGroupEndCommand
    extends ColumnReorderEndCommand {
        private final GroupModel.Group group;

        public ColumnReorderEndToGroupEndCommand(ColumnReorderEndCommand command, GroupModel.Group group) {
            super(command);
            this.group = group;
        }

        protected ColumnReorderEndToGroupEndCommand(ColumnReorderEndToGroupEndCommand command) {
            super(command);
            this.group = command.group;
        }

        @Override
        public boolean convertToTargetLayer(ILayer targetLayer) {
            int groupEndPosition;
            boolean convert = super.convertToTargetLayer(targetLayer);
            if (convert && !this.isReorderToLeftEdge() && targetLayer instanceof IUniqueIndexLayer && (groupEndPosition = this.group.getGroupEndPosition((IUniqueIndexLayer)targetLayer)) >= 0 && groupEndPosition > this.getToColumnPosition()) {
                this.updateToColumnPosition(groupEndPosition);
            }
            return convert;
        }

        @Override
        public ColumnReorderEndToGroupEndCommand cloneCommand() {
            return new ColumnReorderEndToGroupEndCommand(this);
        }
    }

    class ColumnReorderEndToGroupStartCommand
    extends ColumnReorderEndCommand {
        private final GroupModel.Group group;

        public ColumnReorderEndToGroupStartCommand(ColumnReorderEndCommand command, GroupModel.Group group) {
            super(command);
            this.group = group;
        }

        protected ColumnReorderEndToGroupStartCommand(ColumnReorderEndToGroupStartCommand command) {
            super(command);
            this.group = command.group;
        }

        @Override
        public boolean convertToTargetLayer(ILayer targetLayer) {
            int groupStartPosition;
            boolean convert = super.convertToTargetLayer(targetLayer);
            if (convert && this.isReorderToLeftEdge() && targetLayer instanceof IUniqueIndexLayer && (groupStartPosition = ((IUniqueIndexLayer)targetLayer).getColumnPositionByIndex(this.group.getStartIndex())) >= 0 && groupStartPosition < this.getToColumnPosition()) {
                this.updateToColumnPosition(groupStartPosition);
            }
            return convert;
        }

        @Override
        public ColumnReorderEndToGroupStartCommand cloneCommand() {
            return new ColumnReorderEndToGroupStartCommand(this);
        }
    }
}

