/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.wizard.pages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.factory.IAxisFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IdTreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.wizard.CategoriesWizardUtils;
import org.eclipse.papyrus.infra.nattable.wizard.pages.ITreeItemContentProvider;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.editors.InputDialog;
import org.eclipse.papyrus.infra.widgets.widgets.MultipleValueEditAndSelectionWidget;
import org.eclipse.swt.widgets.Control;

public class ChooseCategoriesSelectionWidget
extends MultipleValueEditAndSelectionWidget {
    public ChooseCategoriesSelectionWidget(IElementSelector selector) {
        super(selector);
    }

    public ChooseCategoriesSelectionWidget(IElementSelector selector, boolean unique) {
        super(selector, unique);
    }

    public ChooseCategoriesSelectionWidget(IElementSelector selector, boolean unique, boolean ordered) {
        super(selector, unique, ordered);
    }

    public ChooseCategoriesSelectionWidget(IElementSelector selector, boolean unique, boolean ordered, int upperBound) {
        super(selector, unique, ordered, upperBound);
    }

    protected void init() {
        this.setFactory(new CategoriesValueFactory());
        this.setAllowEdition(true);
    }

    public List<Object> getSelection() {
        return new ArrayList<Object>(this.initialSelection);
    }

    protected Object getContextForCreateAction() {
        Object first;
        ISelection selection;
        if (this.selectedElementsViewer != null && (selection = this.selectedElementsViewer.getSelection()) instanceof IStructuredSelection && (first = ((IStructuredSelection)selection).getFirstElement()) instanceof ITreeItemAxis) {
            ITreeItemAxis context = (ITreeItemAxis)first;
            while (context.getParent() != null) {
                context = context.getParent();
            }
            return context;
        }
        return null;
    }

    protected void createAction() {
        Object context = this.getContextForCreateAction();
        if (this.factory == null || context == null) {
            return;
        }
        try {
            this.factory.createObject((Control)this.create, context);
        }
        catch (OperationCanceledException operationCanceledException) {
            // empty catch block
        }
        if (!this.selectedElementsViewer.getExpandedState(context)) {
            this.selectedElementsViewer.setExpandedElements(new Object[]{context});
        }
        this.selectedElementsViewer.refresh();
    }

    protected void edit() {
        List<ITreeItemAxis> selectedAxis = this.getSelectedAxisInSelectedElementsViewer();
        if (selectedAxis.size() == 1 && CategoriesWizardUtils.isCategoryItem(selectedAxis.get(0))) {
            this.factory.edit((Control)this.edit, (Object)selectedAxis.get(0));
        }
    }

    protected boolean canEdit() {
        List<ITreeItemAxis> selectedAxis = this.getSelectedAxisInSelectedElementsViewer();
        if (selectedAxis.size() == 1) {
            return CategoriesWizardUtils.isCategoryItem(selectedAxis.get(0));
        }
        return false;
    }

    protected IContentProvider createListSectionContentProvider() {
        return new ITreeItemContentProvider(){

            @Override
            public Object[] getChildren(Object arg0) {
                return super.getChildren(arg0);
            }

            @Override
            public boolean hasChildren(Object arg0) {
                if (arg0 instanceof ITreeItemAxis && CategoriesWizardUtils.isCategoryItem((ITreeItemAxis)arg0)) {
                    return false;
                }
                return super.hasChildren(arg0);
            }
        };
    }

    protected void upAction() {
        this.moveAction(true);
    }

    protected List<ITreeItemAxis> getSelectedAxisInSelectedElementsViewer() {
        if (this.selectedElementsViewer != null && this.selectedElementsViewer.getSelection() instanceof IStructuredSelection) {
            ArrayList<ITreeItemAxis> selection = new ArrayList<ITreeItemAxis>();
            for (Object curr : ((IStructuredSelection)this.selectedElementsViewer.getSelection()).toList()) {
                if (!(curr instanceof ITreeItemAxis)) continue;
                selection.add((ITreeItemAxis)curr);
            }
            return selection;
        }
        return Collections.emptyList();
    }

    protected List<ITreeItemAxis> getConsistentSelectionInSelectedElementsViewer() {
        if (this.selectedElementsViewer == null) {
            return Collections.emptyList();
        }
        ISelection tmp = this.selectedElementsViewer.getSelection();
        if (tmp instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)tmp;
            ArrayList<ITreeItemAxis> fillingAxis = new ArrayList<ITreeItemAxis>();
            ArrayList<ITreeItemAxis> rootAxis = new ArrayList<ITreeItemAxis>();
            for (Object current : selection.toList()) {
                if (!(current instanceof ITreeItemAxis)) continue;
                ITreeItemAxis axis = (ITreeItemAxis)current;
                if (axis.getParent() == null) {
                    rootAxis.add(axis);
                    continue;
                }
                if (!rootAxis.isEmpty() || !(axis.getElement() instanceof String)) continue;
                fillingAxis.add(axis);
            }
            if (rootAxis.isEmpty()) {
                return fillingAxis;
            }
            return rootAxis;
        }
        return Collections.emptyList();
    }

    protected List<ITreeItemAxis> getSelectedFillingConfigurantionInSelectedElementsViewer() {
        List<ITreeItemAxis> axis = this.getConsistentSelectionInSelectedElementsViewer();
        if (!axis.isEmpty() && axis.get(0).getElement() instanceof TreeFillingConfiguration) {
            return axis;
        }
        return Collections.emptyList();
    }

    protected void deleteAction() {
        List<ITreeItemAxis> axis = this.getSelectionInSelectedElementsViewer();
        for (ITreeItemAxis current : axis) {
            int depth;
            if (CategoriesWizardUtils.isDepthItem(current) && (depth = Integer.valueOf((String)current.getElement()).intValue()) == 0 || current.getParent() == null) continue;
            current.setParent(null);
            EcoreUtil.delete((EObject)current);
        }
        this.selectedElementsViewer.refresh();
    }

    protected boolean canRemove() {
        List<ITreeItemAxis> axis = this.getSelectionInSelectedElementsViewer();
        for (ITreeItemAxis current : axis) {
            if (CategoriesWizardUtils.isCategoryItem(current)) continue;
            return false;
        }
        return super.canRemove();
    }

    protected boolean canDelete() {
        for (ITreeItemAxis curr : this.getSelectionInSelectedElementsViewer()) {
            int depth;
            if (!CategoriesWizardUtils.isDepthItem(curr) && !CategoriesWizardUtils.isCategoryItem(curr)) {
                return false;
            }
            if (!CategoriesWizardUtils.isDepthItem(curr) || (depth = Integer.valueOf((String)curr.getElement()).intValue()) != 0) continue;
            return false;
        }
        return true;
    }

    protected boolean canAdd() {
        return this.isCategorySelection() || this.isRootSelection();
    }

    protected boolean isRootSelection() {
        List<ITreeItemAxis> axis = this.getSelectedAxisInSelectedElementsViewer();
        for (ITreeItemAxis curr : axis) {
            if (CategoriesWizardUtils.isRootItem(curr)) continue;
            return false;
        }
        return true;
    }

    protected boolean isCategorySelection() {
        List<ITreeItemAxis> axis = this.getSelectedAxisInSelectedElementsViewer();
        for (ITreeItemAxis curr : axis) {
            if (CategoriesWizardUtils.isDepthItem(curr)) continue;
            return false;
        }
        return true;
    }

    protected List<ITreeItemAxis> getSelectedCategoriesInSelectedElementsViewer() {
        List<ITreeItemAxis> selection = this.getSelectedAxisInSelectedElementsViewer();
        ITreeItemAxis parent = null;
        ArrayList<ITreeItemAxis> returnedSelection = new ArrayList<ITreeItemAxis>();
        for (ITreeItemAxis curr : selection) {
            ITreeItemAxis tmp = curr.getParent();
            if (tmp == null) {
                return Collections.emptyList();
            }
            if (parent == null && tmp instanceof IdTreeItemAxis) {
                parent = tmp;
                returnedSelection.add(curr);
                continue;
            }
            if (parent != null && parent == tmp) {
                returnedSelection.add(curr);
                continue;
            }
            return Collections.emptyList();
        }
        return returnedSelection;
    }

    protected void downAction() {
        this.moveAction(false);
    }

    protected boolean canMove(boolean up) {
        List<ITreeItemAxis> categories = this.getSelectedCategoriesInSelectedElementsViewer();
        if (categories.isEmpty()) {
            return false;
        }
        ITreeItemAxis parent = categories.get(0).getParent();
        EList children = parent.getChildren();
        int forbiddenIndex = up ? 0 : children.size() - 1;
        for (ITreeItemAxis child : categories) {
            if (children.indexOf(child) != forbiddenIndex) continue;
            return false;
        }
        return true;
    }

    protected void moveAction(boolean up) {
        List<ITreeItemAxis> categories = this.getSelectedCategoriesInSelectedElementsViewer();
        ITreeItemAxis parent = categories.get(0).getParent();
        List<ITreeItemAxis> children = Collections.unmodifiableList(parent.getChildren());
        if (categories.isEmpty()) {
            return;
        }
        Collections.sort(categories, new CategoriesComparator(children));
        if (!up) {
            Collections.reverse(categories);
        }
        for (ITreeItemAxis child : categories) {
            int index = parent.getChildren().indexOf((Object)child);
            index = up ? index - 1 : index + 1;
            parent.getChildren().move(index, (Object)child);
        }
        this.selectedElementsViewer.refresh();
    }

    public void addElements(Object[] elements) {
        List<ITreeItemAxis> selectedElements = this.getSelectedAxisInSelectedElementsViewer();
        if (selectedElements.isEmpty()) {
            return;
        }
        ITreeItemAxis root = null;
        for (ITreeItemAxis current : selectedElements) {
            if (!CategoriesWizardUtils.isRootItem(current)) continue;
            root = current;
            break;
        }
        ArrayList<ITreeItemAxis> depthToEdit = new ArrayList<ITreeItemAxis>();
        if (root != null) {
            depthToEdit.addAll((Collection<ITreeItemAxis>)root.getChildren());
        } else {
            for (ITreeItemAxis current : selectedElements) {
                if (!CategoriesWizardUtils.isDepthItem(current)) continue;
                depthToEdit.add(current);
            }
        }
        for (ITreeItemAxis curr : depthToEdit) {
            ArrayList<Object> alreadyManagedObject = new ArrayList<Object>();
            for (ITreeItemAxis category : curr.getChildren()) {
                alreadyManagedObject.add(category.getElement());
            }
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object el = objectArray[n2];
                if (!alreadyManagedObject.contains(el)) {
                    IAxisFactory.createITreeItemAxis((ITreeItemAxis)curr, (Object)el, null, null);
                }
                ++n2;
            }
        }
        this.selectedElementsViewer.refresh();
    }

    protected void removeAllAction() {
        Object input = this.selectedElementsViewer.getInput();
        if (input instanceof List) {
            for (Object curr : (List)input) {
                if (!(curr instanceof ITreeItemAxis)) continue;
                this.destroyCategoriesAxis((ITreeItemAxis)curr);
            }
            this.selectedElementsViewer.refresh();
        }
    }

    protected void destroyCategoriesAxis(ITreeItemAxis axis) {
        for (ITreeItemAxis child : axis.getChildren()) {
            this.destroyCategoriesAxis(child);
        }
        if (CategoriesWizardUtils.isCategoryItem(axis)) {
            axis.setParent(null);
            EcoreUtil.delete((EObject)axis);
        }
    }

    protected void removeAction() {
        IStructuredSelection selection = (IStructuredSelection)this.selectedElementsViewer.getSelection();
        for (Object current : selection.toList()) {
            if (!(current instanceof ITreeItemAxis) || ((ITreeItemAxis)current).getParent() == null) continue;
            ITreeItemAxis axis = (ITreeItemAxis)current;
            axis.setParent(null);
            EcoreUtil.delete((EObject)axis);
        }
        this.selectedElementsViewer.refresh();
    }

    protected List<ITreeItemAxis> getSelectionInSelectedElementsViewer() {
        ISelection selection;
        if (this.selectedElementsViewer != null && (selection = this.selectedElementsViewer.getSelection()) instanceof IStructuredSelection) {
            ArrayList<ITreeItemAxis> returnedValues = new ArrayList<ITreeItemAxis>();
            for (Object current : ((IStructuredSelection)selection).toList()) {
                if (!(current instanceof ITreeItemAxis)) continue;
                returnedValues.add((ITreeItemAxis)current);
            }
            return returnedValues;
        }
        return Collections.emptyList();
    }

    public static final class CategoriesComparator
    implements Comparator<ITreeItemAxis> {
        private List<ITreeItemAxis> children;

        public CategoriesComparator(List<ITreeItemAxis> children) {
            this.children = Collections.unmodifiableList(children);
        }

        @Override
        public int compare(ITreeItemAxis o1, ITreeItemAxis o2) {
            int index2;
            int index1 = this.children.indexOf(o1);
            if (index1 < (index2 = this.children.indexOf(o2))) {
                return -1;
            }
            return 1;
        }
    }

    public class CategoriesValueFactory
    implements ReferenceValueFactory {
        public Collection<Object> validateObjects(Collection<Object> objectsToValidate) {
            return null;
        }

        public Object edit(Control widget, Object object) {
            String existingAlias = ((IAxis)object).getAlias();
            InputDialog dialog = new InputDialog(widget.getShell(), Messages.ChooseCategoriesSelectionWidget_EditAlias, Messages.ChooseCategoriesSelectionWidget_EnterAliasToUseForTheCategory, existingAlias, null);
            int result = dialog.open();
            if (result == 0) {
                String newValue = dialog.getText();
                ((IAxis)object).setAlias(newValue);
            }
            return object;
        }

        public Object createObject(Control widget, Object context) {
            Assert.isTrue((boolean)(context instanceof ITreeItemAxis));
            ITreeItemAxis rootItem = (ITreeItemAxis)context;
            Assert.isTrue((rootItem.getParent() == null ? 1 : 0) != 0);
            int maxDepth = -1;
            for (ITreeItemAxis axis : rootItem.getChildren()) {
                Assert.isTrue((boolean)(axis instanceof IdTreeItemAxis));
                maxDepth = Math.max(maxDepth, Integer.parseInt((String)axis.getElement()));
            }
            int nextDepth = maxDepth + 1;
            return IAxisFactory.createITreeItemAxis((ITreeItemAxis)rootItem, (Object)nextDepth, null, null);
        }

        public boolean canEdit() {
            List<ITreeItemAxis> selectedAxis = ChooseCategoriesSelectionWidget.this.getSelectedAxisInSelectedElementsViewer();
            if (selectedAxis.size() == 1) {
                return CategoriesWizardUtils.isCategoryItem(selectedAxis.get(0));
            }
            return false;
        }

        public boolean canCreateObject() {
            return ChooseCategoriesSelectionWidget.this.getContextForCreateAction() != null;
        }
    }
}

