/**
 * Copyright (c) 2007-2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.diagram.commands;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class CreateShortcutDecorationsCommand {
  @Inject
  @Extension
  private Common _common;

  public CharSequence className(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _createShortcutDecorationsCommandClassName = it.getCreateShortcutDecorationsCommandClassName();
    _builder.append(_createShortcutDecorationsCommandClassName);
    return _builder;
  }

  public CharSequence packageName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editCommandsPackageName = it.getEditCommandsPackageName();
    _builder.append(_editCommandsPackageName);
    return _builder;
  }

  public CharSequence qualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }

  public CharSequence fullPath(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  public CharSequence CreateShortcutDecorationsCommand(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("extends org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private java.util.List myDescriptors;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public ");
    CharSequence _className_1 = this.className(it);
    _builder.append(_className_1, "\t");
    _builder.append("(");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.emf.transaction.TransactionalEditingDomain editingDomain,");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View parentView,");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("java.util.List viewDescriptors) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("super(editingDomain, \"Create Shortcuts\", getWorkspaceFiles(parentView)); //$NON-NLS-1$");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("myDescriptors = viewDescriptors;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public ");
    CharSequence _className_2 = this.className(it);
    _builder.append(_className_2, "\t");
    _builder.append("(");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.emf.transaction.TransactionalEditingDomain editingDomain,");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View parentView,");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest.ViewDescriptor viewDescriptor) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("this(editingDomain, parentView, java.util.Collections.singletonList(viewDescriptor));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_3, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected org.eclipse.gmf.runtime.common.core.command.CommandResult doExecuteWithResult(");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.core.runtime.IProgressMonitor monitor, org.eclipse.core.runtime.IAdaptable info)");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("throws org.eclipse.core.commands.ExecutionException {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (java.util.Iterator it = myDescriptors.iterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest.ViewDescriptor nextDescriptor =");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("(org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest.ViewDescriptor) it.next();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View view =");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("(org.eclipse.gmf.runtime.notation.View) nextDescriptor.getAdapter(");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View.class);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (view != null && view.getEAnnotation(\"Shortcut\") == null) { //$NON-NLS-1$");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    CharSequence _addShortcutAnnotation = this._common.addShortcutAnnotation(it, "view");
    _builder.append(_addShortcutAnnotation, "\t\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return org.eclipse.gmf.runtime.common.core.command.CommandResult.newOKCommandResult();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence additions(final GenDiagram diagram) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
}
