/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.eclipse.papyrus.uml.diagram.common.util.CrossReferencerUtil;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.RefreshCommandForDo;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.RefreshCommandForUndo;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EcoreUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.OccurrenceSpecificationUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.Utils;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.timing.providers.UMLElementTypes;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageKind;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public final class MessageUtils {
    private static final String MESSAGE_CONNECTOR_LOCATION = "messageConnectorLocation";
    private static final String START_LOCATION = "startLocation";
    private static final String X = "x";
    private static final String Y = "y";
    public static Point lastStartLocation = new Point();

    private MessageUtils() {
    }

    public static boolean isMessage(IElementType requestElementType) {
        return requestElementType == UMLElementTypes.Message_SynchEdge || requestElementType == UMLElementTypes.Message_AsynchEdge || requestElementType == UMLElementTypes.Message_ReplyEdge || requestElementType == UMLElementTypes.Message_CreateEdge || requestElementType == UMLElementTypes.Message_DeleteEdge || requestElementType == UMLElementTypes.Message_LostEdge || requestElementType == UMLElementTypes.Message_FoundEdge;
    }

    public static boolean isMessage(String visualID) {
        return "Message_SynchEdge".equals(visualID) || "Message_AsynchEdge".equals(visualID) || "Message_ReplyEdge".equals(visualID) || "Message_CreateEdge".equals(visualID) || "Message_DeleteEdge".equals(visualID) || "Message_FoundEdge".equals(visualID) || "Message_LostEdge".equals(visualID);
    }

    public static MessageKind getMessageKind(IElementType requestElementType) {
        if (requestElementType == UMLElementTypes.Message_SynchEdge || requestElementType == UMLElementTypes.Message_AsynchEdge || requestElementType == UMLElementTypes.Message_ReplyEdge || requestElementType == UMLElementTypes.Message_CreateEdge || requestElementType == UMLElementTypes.Message_DeleteEdge) {
            return MessageKind.UNKNOWN_LITERAL;
        }
        if (requestElementType == UMLElementTypes.Message_LostEdge) {
            return MessageKind.LOST_LITERAL;
        }
        if (requestElementType == UMLElementTypes.Message_FoundEdge) {
            return MessageKind.FOUND_LITERAL;
        }
        return null;
    }

    public static MessageSort getMessageSort(IElementType requestElementType) {
        if (requestElementType == UMLElementTypes.Message_SynchEdge) {
            return MessageSort.SYNCH_CALL_LITERAL;
        }
        if (requestElementType == UMLElementTypes.Message_AsynchEdge) {
            return MessageSort.ASYNCH_CALL_LITERAL;
        }
        if (requestElementType == UMLElementTypes.Message_ReplyEdge) {
            return MessageSort.REPLY_LITERAL;
        }
        if (requestElementType == UMLElementTypes.Message_CreateEdge) {
            return MessageSort.CREATE_MESSAGE_LITERAL;
        }
        if (requestElementType == UMLElementTypes.Message_DeleteEdge) {
            return MessageSort.DELETE_MESSAGE_LITERAL;
        }
        if (requestElementType == UMLElementTypes.Message_LostEdge || requestElementType == UMLElementTypes.Message_FoundEdge) {
            return MessageSort.SYNCH_CALL_LITERAL;
        }
        return null;
    }

    public static IElementType getElementType(Message message) {
        switch (message.getMessageKind()) {
            case LOST_LITERAL: {
                return UMLElementTypes.Message_LostEdge;
            }
            case FOUND_LITERAL: {
                return UMLElementTypes.Message_FoundEdge;
            }
        }
        switch (message.getMessageSort()) {
            case SYNCH_CALL_LITERAL: {
                return UMLElementTypes.Message_SynchEdge;
            }
            case ASYNCH_CALL_LITERAL: {
                return UMLElementTypes.Message_AsynchEdge;
            }
            case REPLY_LITERAL: {
                return UMLElementTypes.Message_ReplyEdge;
            }
            case CREATE_MESSAGE_LITERAL: {
                return UMLElementTypes.Message_CreateEdge;
            }
            case DELETE_MESSAGE_LITERAL: {
                return UMLElementTypes.Message_DeleteEdge;
            }
        }
        throw new IllegalArgumentException("Unknown message type");
    }

    public static Command createMoveMessageAnchorCommand(LocationRequest request, ConnectionEditPart connectionEditPart, IFigure referenceFigure, String commandName, TransactionalEditingDomain editingDomain) {
        final Connector connector = (Connector)connectionEditPart.getModel();
        Point location = request.getLocation();
        Point figureLocation = new Point(referenceFigure.getBounds().getCenter());
        referenceFigure.getParent().translateToAbsolute((Translatable)figureLocation);
        double scale = FigureUtils.getScale((IFigure)connectionEditPart.getFigure());
        final Point anchorLocation = new Point(location.x - figureLocation.x, location.y - figureLocation.y).scale(1.0 / scale);
        CompoundCommand compoundCommand = new CompoundCommand();
        compoundCommand.add((Command)new RefreshCommandForUndo((GraphicalEditPart)connectionEditPart));
        compoundCommand.add((Command)new ICommandProxy((ICommand)new AbstractTransactionalCommand(editingDomain, commandName, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                MessageUtils.setMessageConnectorLocation(connector, anchorLocation);
                return CommandResult.newOKCommandResult();
            }
        }));
        compoundCommand.add((Command)new RefreshCommandForDo((GraphicalEditPart)connectionEditPart));
        return compoundCommand;
    }

    public static void setMessageConnectorLocation(Connector connector, Point location) {
        EAnnotation eAnnotation = connector.getEAnnotation(MESSAGE_CONNECTOR_LOCATION);
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(MESSAGE_CONNECTOR_LOCATION);
            connector.getEAnnotations().add((Object)eAnnotation);
        }
        eAnnotation.getDetails().put((Object)X, (Object)Integer.toString(location.x));
        eAnnotation.getDetails().put((Object)Y, (Object)Integer.toString(location.y));
    }

    public static Point getMessageConnectorLocation(ConnectionEditPart connectionEditPart) {
        double scale = FigureUtils.getScale((IFigure)connectionEditPart.getFigure());
        Connector connector = (Connector)connectionEditPart.getModel();
        EAnnotation eAnnotation = connector.getEAnnotation(MESSAGE_CONNECTOR_LOCATION);
        if (eAnnotation != null) {
            return new Point(Integer.parseInt((String)eAnnotation.getDetails().get((Object)X)), Integer.parseInt((String)eAnnotation.getDetails().get((Object)Y))).scale(scale);
        }
        return null;
    }

    public static void saveRequestStartLocation(CreateRequest request) {
        Map extendedData = request.getExtendedData();
        Point location = request.getLocation();
        extendedData.put(START_LOCATION, location);
        lastStartLocation = new Point(location);
    }

    public static Point retrieveRequestStartLocation(CreateRequest request) {
        Map extendedData = request.getExtendedData();
        return (Point)extendedData.get(START_LOCATION);
    }

    public static Point getLastStartLocation() {
        return lastStartLocation;
    }

    public static Collection<? extends EObject> getReferencingMessagesToRemove(EObject element, boolean hideOnly, View expectedParentView) {
        EReference[] references = new EReference[]{UMLPackage.eINSTANCE.getMessage_ReceiveEvent(), UMLPackage.eINSTANCE.getMessage_SendEvent()};
        Class[] expectedClasses = new Class[]{Message.class};
        return Utils.getReferencingElementsToRemove(element, references, hideOnly, expectedParentView, expectedClasses);
    }

    public static MessageEnd convertToMessageOccurrenceSpecification(EObject element, boolean destruction) {
        if (element instanceof MessageEnd && !destruction || element instanceof DestructionOccurrenceSpecification) {
            return (MessageEnd)element;
        }
        if (element instanceof OccurrenceSpecification) {
            OccurrenceSpecification occurrenceSpecification = (OccurrenceSpecification)element;
            boolean autogeneratedName = OccurrenceSpecificationUtils.isAutogeneratedName(occurrenceSpecification);
            Set views = CrossReferencerUtil.getCrossReferencingViews((EObject)occurrenceSpecification, (String)"PapyrusUMLTimingDiagram");
            DestructionOccurrenceSpecification messageOccurrenceSpecification = destruction ? UMLFactory.eINSTANCE.createDestructionOccurrenceSpecification() : UMLFactory.eINSTANCE.createMessageOccurrenceSpecification();
            OccurrenceSpecificationUtils.setAutogeneratedName((OccurrenceSpecification)messageOccurrenceSpecification, autogeneratedName);
            EcoreUtils.replaceEObjectInstance((EObject)occurrenceSpecification, (EObject)messageOccurrenceSpecification);
            for (View view : views) {
                String type = UMLVisualIDRegistry.getVisualID(view);
                if (!OccurrenceSpecificationUtils.isOccurrenceSpecificationEditPart(type)) continue;
                view.setType(destruction ? "DestructionOccurrenceSpecification_Shape" : "MessageOccurrenceSpecification_Shape");
                ArrayList children = new ArrayList(view.getChildren());
                for (View childView : children) {
                    String childType = UMLVisualIDRegistry.getVisualID(childView);
                    if (!"OccurrenceSpecification_NameLabel".equals(childType) && !"MessageOccurrenceSpecification_NameLabel".equals(childType)) continue;
                    childView.setElement((EObject)messageOccurrenceSpecification);
                    childView.setType(destruction ? "DestructionOccurrenceSpecification_NameLabel" : "MessageOccurrenceSpecification_NameLabel");
                }
            }
            return messageOccurrenceSpecification;
        }
        return null;
    }

    public static boolean isPotentialMessageEnd(EObject element) {
        return element instanceof MessageEnd || element instanceof OccurrenceSpecification;
    }

    public static Collection<EClass> getAllowedMessageTargets() {
        return Arrays.asList(UMLPackage.eINSTANCE.getOccurrenceSpecification(), UMLPackage.eINSTANCE.getGate());
    }

    public static boolean isValidMessage(MessageSort messageSort, MessageKind messageKind, EObject source, EObject target) {
        if (source == null != (messageKind == MessageKind.FOUND_LITERAL)) {
            return false;
        }
        if (target == null != (messageKind == MessageKind.LOST_LITERAL)) {
            return false;
        }
        if ((messageSort == MessageSort.DELETE_MESSAGE_LITERAL || messageSort == MessageSort.CREATE_MESSAGE_LITERAL) && target instanceof Gate) {
            return false;
        }
        return messageSort != MessageSort.CREATE_MESSAGE_LITERAL || !(target instanceof DestructionOccurrenceSpecification);
    }
}

