/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.util.jface.ui.internal.imageprovider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.papyrus.emf.facet.util.core.DebugUtils;
import org.eclipse.papyrus.emf.facet.util.jface.ui.imageprovider.IImageProvider;
import org.eclipse.papyrus.emf.facet.util.jface.ui.internal.Activator;
import org.eclipse.papyrus.emf.facet.util.swt.imageprovider.IImageProviderFactory;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public final class ImageProvider
implements IImageProvider {
    private static final boolean DEBUG = DebugUtils.getDebugStatus((Plugin)Activator.getDefault());
    private final Map<Object, Image> map = new HashMap<Object, Image>();
    private final Plugin plugin;
    private final org.eclipse.papyrus.emf.facet.util.swt.imageprovider.IImageProvider delegate;

    ImageProvider(Plugin plugin) {
        this.plugin = plugin;
        this.delegate = IImageProviderFactory.DEFAULT.createIImageProvider(plugin);
    }

    @Override
    public Image getImage(DecorationOverlayIcon imgDescriptor) {
        Image result = this.map.get(imgDescriptor);
        if (result == null) {
            result = imgDescriptor.createImage();
            this.map.put(imgDescriptor, result);
            if (DEBUG) {
                Bundle bundle = this.plugin.getBundle();
                String bundleId = bundle.getSymbolicName();
                String message = String.format("New image loaded from an overlay icon (bundle=%s)", bundleId);
                DebugUtils.debug((String)message);
            }
        }
        return result;
    }

    @Override
    public Image getImage(String path) {
        return this.delegate.getImage(path);
    }

    @Override
    public ImageDescriptor createImageDescriptor(String resourcePath) {
        return this.delegate.createImageDescriptor(resourcePath);
    }

    @Override
    public Image getImage(ImageDescriptor imgDescriptor) {
        return this.delegate.getImage(imgDescriptor);
    }
}

