/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.menu.handlers;

import java.util.List;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.IStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.IPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.PasteStrategyManager;
import org.eclipse.papyrus.infra.gmfdiag.menu.handlers.AbstractGraphicalCommandHandler;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PasteInDiagramHandler
extends AbstractGraphicalCommandHandler {
    @Override
    protected Command getCommand() {
        PapyrusClipboard.getInstance().resetTarget();
        List<IGraphicalEditPart> selectedElements = this.getSelectedElements();
        if (selectedElements.size() == 1 && selectedElements.get(0) instanceof GraphicalEditPart) {
            GraphicalEditPart targetOwnerEditPart = (GraphicalEditPart)selectedElements.get(0);
            CompoundCommand compoundCommand = new CompoundCommand("Paste all elements");
            List allStrategies = PasteStrategyManager.getInstance().getAllActiveStrategies();
            for (IStrategy iStrategy : allStrategies) {
                IPasteStrategy iPasteStrategy = (IPasteStrategy)iStrategy;
                Command graphicalCommand = iPasteStrategy.getGraphicalCommand((EditingDomain)this.getEditingDomain(), targetOwnerEditPart, PapyrusClipboard.getInstance());
                if (graphicalCommand == null) continue;
                compoundCommand.add(graphicalCommand);
            }
            return compoundCommand;
        }
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public void setEnabled(Object evaluationContext) {
        if (!PapyrusClipboard.getInstance().isEmpty()) {
            if (evaluationContext instanceof IEvaluationContext) {
                IEvaluationContext iEvaluationContext = (IEvaluationContext)evaluationContext;
                Object activeFocusControl = iEvaluationContext.getVariable("activeFocusControl");
                Object activeShell = iEvaluationContext.getVariable("activeShell");
                Control focusControl = null;
                if (activeShell instanceof Shell) {
                    Display display;
                    Shell shell = (Shell)activeShell;
                    Display display2 = display = !shell.isDisposed() ? shell.getDisplay() : null;
                    if (display != null) {
                        focusControl = display.getFocusControl();
                    }
                }
                if (activeFocusControl instanceof StyledText || focusControl instanceof Text) {
                    this.setBaseEnabled(false);
                } else {
                    super.setEnabled(evaluationContext);
                }
            }
        } else {
            this.setBaseEnabled(false);
        }
    }
}

