/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.resourceloading.internal.ui.strategy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.resourceloading.ILoadingStrategy;
import org.eclipse.papyrus.infra.services.resourceloading.strategies.Messages;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.INotification;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.NotificationRunnable;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.Type;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.IContext;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class AskUserStrategy
implements ILoadingStrategy {
    private Map<URI, Set<URI>> alreadyGuessed = new HashMap<URI, Set<URI>>();
    Map<URI, Set<URI>> authorized = new HashMap<URI, Set<URI>>();
    Map<URI, Map<URI, Set<String>>> mappingURIExtensions = new HashMap<URI, Map<URI, Set<String>>>();
    Map<URI, EditorCloseListener> listeners = new HashMap<URI, EditorCloseListener>();
    Map<URI, List<INotification>> notifications = new HashMap<URI, List<INotification>>();
    public static final URI YesForAllURI = URI.createURI((String)Messages.AskUserStrategy_YES_FOR_ALL_URI);
    private static final URI NoForAllURI = URI.createURI((String)Messages.AskUserStrategy_NO_FOR_ALL_URI);

    public boolean loadResource(ModelSet modelSet, URI uri) {
        boolean result = !modelSet.isUserModelResource(uri);
        URI initialURI = modelSet.getURIWithoutExtension();
        this.addClosingEditorListener(initialURI);
        URI trimFileExtensionAndFragment = uri.trimFragment().trimFileExtension();
        if (!result) {
            result = initialURI.equals(trimFileExtensionAndFragment);
        }
        if (!result) {
            this.manageExtensions(initialURI, uri);
            Set<URI> uris = this.authorized.get(initialURI);
            if (uris != null && (uris.contains(YesForAllURI) || uris.contains(trimFileExtensionAndFragment))) {
                result = true;
            }
            if (uris != null && uris.contains(NoForAllURI)) {
                return false;
            }
            if (!result) {
                this.manageGuess(modelSet, initialURI, trimFileExtensionAndFragment);
            }
        }
        return result;
    }

    protected void manageGuess(ModelSet modelSet, URI initialURI, URI trimFragment) {
        if (!(this.alreadyGuessed(initialURI, trimFragment) || this.alreadyGuessed(initialURI, YesForAllURI) || this.alreadyGuessed(initialURI, NoForAllURI))) {
            String message = new StringBuffer(Messages.AskUserStrategy_MESSAGE_PART_1).append(initialURI.lastSegment()).append(Messages.AskUserStrategy_MESSAGE_PART_2).append(trimFragment.toString()).append(Messages.AskUserStrategy_MESSAGE_PART3).toString();
            this.addGuessed(initialURI, trimFragment);
            NotificationBuilder builder = this.getNotification(message, trimFragment, modelSet, initialURI);
            INotification notification = builder.run();
            this.addNotification(initialURI, new EncapsulatedNotification(notification, trimFragment));
        }
    }

    private void addClosingEditorListener(URI initialURI) {
        EditorCloseListener value;
        if (!this.listeners.containsKey(initialURI) && this.addPageListener(value = new EditorCloseListener())) {
            this.listeners.put(initialURI, value);
        }
    }

    private void addGuessed(URI initialURI, URI guessed) {
        Set<URI> set = this.alreadyGuessed.get(initialURI);
        if (set == null) {
            set = new HashSet<URI>();
            this.alreadyGuessed.put(initialURI, set);
        }
        set.add(guessed);
    }

    private boolean alreadyGuessed(URI initialURI, URI toLoad) {
        Set<URI> guessed = this.alreadyGuessed.get(initialURI);
        if (guessed != null) {
            return guessed.contains(toLoad);
        }
        return false;
    }

    private void manageExtensions(URI initialURI, URI toLoad) {
        Set<String> extensions;
        Map<URI, Set<String>> map = this.mappingURIExtensions.get(initialURI);
        if (map == null) {
            map = new HashMap<URI, Set<String>>();
            this.mappingURIExtensions.put(initialURI, map);
        }
        if ((extensions = map.get(toLoad.trimFileExtension())) == null) {
            extensions = new HashSet<String>();
            map.put(toLoad.trimFileExtension(), extensions);
        }
        extensions.add(toLoad.fileExtension());
    }

    protected IMultiDiagramEditor getCurrentEditor() {
        IEditorPart editor = this.getEditor();
        if (editor instanceof IMultiDiagramEditor) {
            return (IMultiDiagramEditor)editor;
        }
        return null;
    }

    protected NotificationBuilder getNotification(String message, URI uri, ModelSet modelSet, URI initialURI) {
        LoadAndRefreshRunnable yes = this.getYesRunnable(uri, modelSet, initialURI);
        LoadAndRefreshRunnable no = this.getNoRunnable(uri, modelSet, initialURI);
        LoadAndRefreshRunnable yesForAll = this.getYesForAllRunnable(uri, modelSet, initialURI);
        LoadAndRefreshRunnable noForAll = this.getNoForAllRunnable(uri, modelSet, initialURI);
        return new NotificationBuilder().setType(Type.QUESTION).setAsynchronous(true).setTemporary(false).setMessage(message).setHTML(true).setAsynchronous(true).setTitle(Messages.AskUserStrategy_LOAD_RESOURCE + uri.toString()).addAction((NotificationRunnable)yes).addAction((NotificationRunnable)no).addAction((NotificationRunnable)yesForAll).addAction((NotificationRunnable)noForAll);
    }

    protected LoadAndRefreshRunnable getNoForAllRunnable(URI uri, ModelSet modelSet, URI initialURI) {
        return new LoadAndRefreshRunnable(this, initialURI, uri, modelSet, Messages.AskUserStrategy_NO_FOR_ALL){

            @Override
            public void run(IContext context) {
                this.addGuessed(this.getInitialURI(), NoForAllURI);
                super.run(context);
            }

            @Override
            protected void manageRefresh(IEditorReference ref, IEditorPart part) {
                this.addAuthorized(this.getInitialURI(), NoForAllURI);
                List<INotification> list = notifications.get(this.getInitialURI());
                if (list != null) {
                    for (INotification n : notifications.get(this.getInitialURI())) {
                        if (n == this.getNotification()) continue;
                        n.delete();
                    }
                }
            }

            @Override
            public int getActionValue() {
                return 128;
            }
        };
    }

    protected LoadAndRefreshRunnable getYesForAllRunnable(URI uri, ModelSet modelSet, URI initialURI) {
        return new LoadAndRefreshRunnable(this, initialURI, uri, modelSet, Messages.AskUserStrategy_0){

            @Override
            public void run(IContext context) {
                this.addGuessed(this.getInitialURI(), YesForAllURI);
                super.run(context);
            }

            @Override
            RefreshRunnable getRunnable() {
                return new RefreshRunnable(this, this.modelSet, this.uri, this.initialURI, true, true){

                    @Override
                    public void run(IMultiDiagramEditor editor) {
                        List<INotification> list = notifications.get(this.getInitialURI());
                        if (list != null) {
                            for (INotification n : notifications.get(this.getInitialURI())) {
                                if (!(n instanceof EncapsulatedNotification)) continue;
                                EncapsulatedNotification encapsulated = (EncapsulatedNotification)n;
                                new RefreshRunnable(this.modelSet, encapsulated.getURIToLoad(), this.getInitialURI(), false, false).run(editor);
                            }
                        }
                        new RefreshRunnable(this.modelSet, null, this.getInitialURI(), true, true).run(editor);
                    }
                };
            }

            @Override
            protected void manageRefresh(IEditorReference ref, IEditorPart part) {
                this.addAuthorized(this.getInitialURI(), YesForAllURI);
                INotification currentNotification = this.getNotification();
                List<INotification> list = notifications.get(this.getInitialURI());
                if (list != null) {
                    for (INotification n : notifications.get(this.getInitialURI())) {
                        if (n == currentNotification) continue;
                        n.delete();
                    }
                }
                super.manageRefresh(ref, part);
            }

            @Override
            public int getActionValue() {
                return 64;
            }
        };
    }

    protected LoadAndRefreshRunnable getNoRunnable(URI uri, ModelSet modelSet, URI initialURI) {
        return new LoadAndRefreshRunnable(this, initialURI, uri, modelSet, Messages.AskUserStrategy_NO){

            @Override
            protected void manageRefresh(IEditorReference ref, IEditorPart part) {
            }

            @Override
            public int getActionValue() {
                return 128;
            }
        };
    }

    protected LoadAndRefreshRunnable getYesRunnable(URI uri, ModelSet modelSet, URI initialURI) {
        return new LoadAndRefreshRunnable(initialURI, uri, modelSet, Messages.AskUserStrategy_YES);
    }

    protected void addNotification(URI initialURI, INotification notification) {
        List<INotification> notifs = this.notifications.get(initialURI);
        if (notifs == null) {
            notifs = new LinkedList<INotification>();
            this.notifications.put(initialURI, notifs);
        }
        notifs.add(notification);
    }

    protected IEditorPart getEditor() {
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWorkbenchWindow = this.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null) {
            return activePage.getActiveEditor();
        }
        return null;
    }

    protected IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            return workbench.getActiveWorkbenchWindow();
        }
        return null;
    }

    protected IWorkbenchPage getActivePage() {
        IWorkbenchWindow activeWorkbenchWindow = this.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            return activeWorkbenchWindow.getActivePage();
        }
        return null;
    }

    protected boolean addPageListener(IPartListener listener) {
        IWorkbenchPage page = this.getActivePage();
        if (page != null) {
            page.addPartListener(listener);
            return true;
        }
        return false;
    }

    protected boolean addPerspectiveListener(IPerspectiveListener listener) {
        if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener(listener);
            return true;
        }
        return false;
    }

    protected void removePerspectiveListener(IPerspectiveListener listener) {
        if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().removePerspectiveListener(listener);
        }
    }

    protected void removePageListener(IPartListener listener) {
        IWorkbenchPage page = this.getActivePage();
        if (page != null) {
            page.removePartListener(listener);
        }
    }

    protected void addAuthorized(URI initial, URI toAutorized) {
        Set<URI> uris = this.authorized.get(initial);
        if (uris == null) {
            uris = new HashSet<URI>();
            this.authorized.put(initial, uris);
        }
        uris.add(toAutorized);
    }

    protected static URI getURI(IEditorInput input) {
        IFile file = (IFile)input.getAdapter(IFile.class);
        URI result = file != null && file.getFullPath() != null ? URI.createPlatformResourceURI((String)file.getFullPath().removeFileExtension().toString(), (boolean)true) : (URI)input.getAdapter(URI.class);
        return result;
    }

    private class EditorActivateListener
    extends EditorAdapter {
        private final IEditorReference reference;
        private final RefreshRunnable refreshRunnable;

        public EditorActivateListener(IEditorReference reference, ModelSet set, URI uri, URI initialURI, RefreshRunnable refreshRunnable) {
            this.reference = reference;
            this.refreshRunnable = refreshRunnable;
        }

        @Override
        public void partActivated(IWorkbenchPart part) {
            if (this.reference.getPart(false) == part && part instanceof IMultiDiagramEditor) {
                this.refreshRunnable.run((IMultiDiagramEditor)part);
                AskUserStrategy.this.removePageListener(this);
            }
        }
    }

    private class EditorAdapter
    implements IPartListener {
        private EditorAdapter() {
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }

    private class EditorCloseListener
    extends EditorAdapter {
        private EditorCloseListener() {
        }

        @Override
        public void partClosed(IWorkbenchPart part) {
            IMultiDiagramEditor editor;
            URI uri;
            super.partClosed(part);
            if (part instanceof IMultiDiagramEditor && (uri = AskUserStrategy.getURI((editor = (IMultiDiagramEditor)part).getEditorInput())) != null) {
                uri = uri.trimFileExtension();
                AskUserStrategy.this.addPerspectiveListener(new EditorClosePerspectiveListener(uri));
                AskUserStrategy.this.removePageListener(this);
                AskUserStrategy.this.listeners.remove(uri);
            }
        }
    }

    protected class EditorClosePerspectiveListener
    implements IPerspectiveListener {
        private final URI uri;

        public EditorClosePerspectiveListener(URI uri) {
            this.uri = uri;
        }

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        }

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            AskUserStrategy.this.authorized.remove(this.uri);
            AskUserStrategy.this.mappingURIExtensions.remove(this.uri);
            AskUserStrategy.this.alreadyGuessed.remove(this.uri);
            List<INotification> list = AskUserStrategy.this.notifications.get(this.uri);
            if (list != null) {
                for (INotification n : list) {
                    n.delete();
                }
            }
            AskUserStrategy.this.notifications.remove(this.uri);
            AskUserStrategy.this.removePerspectiveListener(this);
        }
    }

    public class EncapsulatedNotification
    implements INotification {
        private final INotification notification;
        private final URI uri;

        public EncapsulatedNotification(INotification notification, URI uri) {
            this.notification = notification;
            this.uri = uri;
        }

        public void delete() {
            this.notification.delete();
        }

        public boolean isDeleted() {
            return this.notification.isDeleted();
        }

        public URI getURIToLoad() {
            return this.uri;
        }
    }

    private class LoadAndRefreshRunnable
    implements NotificationRunnable {
        protected URI initialURI;
        protected URI uri;
        protected ModelSet modelSet;
        protected final String label;
        protected IContext theContext;

        public LoadAndRefreshRunnable(URI initialURI, URI uri, ModelSet modelSet, String label) {
            this(initialURI, uri, modelSet, label, false);
        }

        public LoadAndRefreshRunnable(URI initialURI, URI uri, ModelSet modelSet, String label, boolean refreshAll) {
            this.initialURI = initialURI;
            this.uri = uri;
            this.modelSet = modelSet;
            this.label = label;
        }

        public URI getInitialURI() {
            return this.initialURI;
        }

        public void run(IContext context) {
            context.put("action_id", (Object)this.getActionValue());
            this.theContext = context;
            IWorkbenchPage activePage = AskUserStrategy.this.getActivePage();
            if (activePage != null) {
                IEditorReference[] iEditorReferenceArray = activePage.getEditorReferences();
                int n = iEditorReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference ref = iEditorReferenceArray[n2];
                    try {
                        URI uri = AskUserStrategy.getURI(ref.getEditorInput());
                        if (uri != null && uri.trimFileExtension().equals(this.initialURI)) {
                            IEditorPart part = (IEditorPart)ref.getPart(false);
                            this.manageRefresh(ref, part);
                        }
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
            } else {
                PlatformUI.getWorkbench().addWindowListener(new IWindowListener(){

                    public void windowOpened(IWorkbenchWindow window) {
                    }

                    public void windowDeactivated(IWorkbenchWindow window) {
                    }

                    public void windowClosed(IWorkbenchWindow window) {
                    }

                    public void windowActivated(IWorkbenchWindow window) {
                        if (window.getActivePage() != null) {
                            LoadAndRefreshRunnable.this.run((IContext)new IContext.Context());
                            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
                        }
                    }
                });
            }
        }

        public int getActionValue() {
            return 64;
        }

        public INotification getNotification() {
            return new EncapsulatedNotification((INotification)this.theContext.get("notification_object_please_check_IContext_Constant"), this.uri);
        }

        protected void manageRefresh(IEditorReference ref, IEditorPart part) {
            AskUserStrategy.this.addAuthorized(this.initialURI, this.uri);
            if (part != null) {
                this.getRunnable().run((IMultiDiagramEditor)part);
            } else {
                AskUserStrategy.this.addPageListener(new EditorActivateListener(ref, this.modelSet, this.uri, this.initialURI, this.getRunnable()));
            }
        }

        RefreshRunnable getRunnable() {
            return new RefreshRunnable(this.modelSet, this.uri, this.initialURI, false, true);
        }

        public String getLabel() {
            return this.label;
        }
    }

    public class RefreshRunnable {
        protected IPageManager pageMngr;
        protected URI uri;
        protected final ModelSet modelSet;
        protected final URI initialURI;
        private final boolean refreshAll;
        private final boolean refreshTab;

        public RefreshRunnable(ModelSet modelSet, URI uriToLoad, URI initialURI, boolean refreshAll, boolean refreshTab) {
            this.modelSet = modelSet;
            this.uri = uriToLoad;
            this.initialURI = initialURI;
            this.refreshAll = refreshAll;
            this.refreshTab = refreshTab;
        }

        public void run(IMultiDiagramEditor editor) {
            HashSet<URI> alreadyLoaded = new HashSet<URI>();
            try {
                this.pageMngr = (IPageManager)editor.getServicesRegistry().getService(IPageManager.class);
                List allPages = this.pageMngr.allPages();
                NotificationBuilder error = NotificationBuilder.createAsyncPopup((String)Messages.AskUserStrategy_ERROR, (String)String.format(Messages.AskUserStrategy_UNABLE_TO_LOAD, this.uri != null ? this.uri.toString() : Messages.AskUserStrategy_12)).setType(Type.ERROR).setDelay(2000L);
                Set<String> extensions = this.getExtensions();
                if (extensions != null) {
                    for (String s : extensions) {
                        try {
                            if (s == null) continue;
                            URI uriToLoad = URI.createURI((String)this.uri.toString());
                            if (s != null) {
                                uriToLoad = uriToLoad.appendFileExtension(s);
                            }
                            if (alreadyLoaded.contains(uriToLoad)) continue;
                            Resource r = this.modelSet.getResource(uriToLoad, true);
                            alreadyLoaded.add(uriToLoad);
                            if (r != null) continue;
                            error.run();
                        }
                        catch (Exception re) {
                            error.run();
                            re.printStackTrace();
                        }
                    }
                }
                for (String o : allPages) {
                    if (!(o instanceof EObject)) continue;
                    EObject eobject = (EObject)o;
                    URI eobjectURI = EcoreUtil.getURI((EObject)eobject);
                    if (!this.refreshAll && (!this.refreshTab || !eobjectURI.trimFileExtension().trimFragment().equals(this.uri))) continue;
                    this.pageMngr.selectPage((Object)eobject);
                }
            }
            catch (ServiceException e1) {
                e1.printStackTrace();
            }
        }

        public Set<String> getExtensions() {
            Map<URI, Set<String>> map = AskUserStrategy.this.mappingURIExtensions.get(this.initialURI);
            if (map != null) {
                return map.get(this.uri);
            }
            return null;
        }

        public IWorkbenchPage getActivePage() {
            IWorkbenchWindow activeWorkbenchWindow;
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null && (activeWorkbenchWindow = workbench.getActiveWorkbenchWindow()) != null && activeWorkbenchWindow.getActivePage() != null) {
                return activeWorkbenchWindow.getActivePage();
            }
            return null;
        }
    }
}

