/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.properties.services.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.eef.ide.ui.internal.preferences.EEFPreferences;
import org.eclipse.eef.ide.ui.internal.widgets.EEFTextLifecycleManager;
import org.eclipse.eef.properties.ui.api.AbstractEEFTabbedPropertySheetPageContributorWrapper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.impl.EObjectTreeElementImpl;
import org.eclipse.papyrus.infra.properties.ui.providers.PropertiesHeaderLabelProvider;
import org.eclipse.papyrus.sirius.properties.common.utils.SiriusInterpreterHelper;
import org.eclipse.sirius.properties.core.api.SiriusInputDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.LiteralSpecification;
import org.eclipse.uml2.uml.MultiplicityElement;

public class CustomSiriusContributorWrapper
extends AbstractEEFTabbedPropertySheetPageContributorWrapper {
    private List<EObject> currentElements;
    private List<EObject> formerElements;

    public CustomSiriusContributorWrapper() {
        super(null, null);
    }

    public CustomSiriusContributorWrapper(Object realContributor, List<String> contributorIds) {
        super(realContributor, contributorIds);
        this.initEEFProperties();
    }

    public CustomSiriusContributorWrapper(Object realContributor, String contributorId) {
        super(realContributor, contributorId);
        this.initEEFProperties();
    }

    public void updateFormTitle(Form form, ISelection selection) {
        if (form.isDisposed()) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            List list = structuredSelection.toList();
            ArrayList<EObject> semanticElements = new ArrayList<EObject>();
            SiriusInputDescriptor inputDescriptor = null;
            if (!list.isEmpty()) {
                inputDescriptor = new SiriusInputDescriptor(list.get(0), list);
                semanticElements.addAll(inputDescriptor.getSemanticElements());
                if (semanticElements.isEmpty() && list.size() == 1 && list.get(0) instanceof EObjectTreeElementImpl && ((EObjectTreeElementImpl)list.get(0)).getEObject() != null) {
                    EObjectTreeElementImpl eObjectTreeElementImpl = (EObjectTreeElementImpl)list.get(0);
                    semanticElements.add(eObjectTreeElementImpl.getEObject());
                }
            }
            this.cleanInterpreter(inputDescriptor, semanticElements);
            if (!semanticElements.isEmpty()) {
                Image firstImage = null;
                String text = "";
                PropertiesHeaderLabelProvider provider = new PropertiesHeaderLabelProvider();
                if (provider != null) {
                    int i = 0;
                    while (i < semanticElements.size()) {
                        EObject semantic = (EObject)semanticElements.get(i);
                        if (semantic != null) {
                            if (i == 0) {
                                firstImage = provider.getImage((Object)semantic);
                                text = provider.getText((Object)semantic);
                            } else {
                                text = text.concat(", ".concat(provider.getText((Object)semantic)));
                            }
                        }
                        ++i;
                    }
                }
                if (semanticElements.size() != 1) {
                    firstImage = null;
                }
                form.setText(text);
                form.setImage(ExtendedImageRegistry.INSTANCE.getImage(firstImage));
            } else {
                form.setText("");
                form.setImage(null);
            }
        }
    }

    private void cleanInterpreter(SiriusInputDescriptor inputDescriptor, List<EObject> semanticElements) {
        this.currentElements = semanticElements;
        if (this.currentElements != this.formerElements) {
            if (this.currentElements != null && this.formerElements != null && !this.currentElements.isEmpty() && !this.formerElements.isEmpty()) {
                EObject obj1 = this.currentElements.get(0);
                EObject obj2 = this.formerElements.get(0);
                if (!obj2.equals(obj1)) {
                    this.formerElements = this.currentElements;
                    if (this.interpreterVariablesHasBeenDefined(obj1) || this.interpreterVariablesHasBeenDefined(obj2)) {
                        SiriusInterpreterHelper.getInstance().clearValidationVariablesFromInterpreter(inputDescriptor);
                    }
                }
            } else {
                this.formerElements = this.currentElements;
            }
        }
    }

    private boolean interpreterVariablesHasBeenDefined(EObject obj1) {
        return obj1 instanceof LiteralSpecification || obj1 instanceof MultiplicityElement || obj1 instanceof Association;
    }

    private void initEEFProperties() {
        EEFPreferences.setTextConflictResolutionMode((EEFTextLifecycleManager.ConflictResolutionMode)EEFTextLifecycleManager.ConflictResolutionMode.USE_MODEL_VERSION);
    }
}

