package org.eclipse.papyrus.robotics.xtext.compdef.generator;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.InputOutput;

/**
 * Generates code from your model files on save.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#code-generation
 */
@SuppressWarnings("all")
public class CompDefGenerator extends AbstractGenerator {
  @Override
  public void doGenerate(final Resource resource, final IFileSystemAccess2 fsa, final IGeneratorContext context) {
    final IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.robotics.xtext.compdef.ComponentGeneratorEP");
    try {
      for (final IConfigurationElement ext : config) {
        {
          final Object obj = ext.createExecutableExtension("class");
          if ((obj instanceof AbstractGenerator)) {
            ISafeRunnable runnable = new ISafeRunnable() {
              @Override
              public void handleException(final Throwable e) {
                String _message = e.getMessage();
                String _plus = ("Exception on client: " + _message);
                InputOutput.<String>println(_plus);
              }

              @Override
              public void run() throws Exception {
                ((AbstractGenerator) obj).doGenerate(resource, fsa, context);
              }
            };
            SafeRunner.run(runnable);
          }
        }
      }
    } catch (final Throwable _t) {
      if (_t instanceof CoreException) {
        final CoreException ex = (CoreException)_t;
        InputOutput.<String>println(ex.getMessage());
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
}
