/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.reverse.utils;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.designer.transformation.base.utils.ModelManagement;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ExtensionServicesRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.robotics.profile.robotics.commobject.CommunicationObject;
import org.eclipse.papyrus.robotics.ros2.reverse.Activator;
import org.eclipse.papyrus.uml.diagram.wizards.command.InitFromTemplateCommand;
import org.eclipse.papyrus.uml.diagram.wizards.command.NewPapyrusModelCommand;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class ReverseUtils {
    public static Package createMsgPackage(IFolder folder, String msgPkgName) {
        try {
            ExtensionServicesRegistry registry = new ExtensionServicesRegistry("org.eclipse.papyrus.infra.core");
            registry.startServicesByClassKeys(new Class[]{ModelSet.class});
            ModelSet modelSet = (ModelSet)registry.getService(ModelSet.class);
            TransactionalEditingDomain domain = modelSet.getTransactionalEditingDomain();
            URI newURI = ReverseUtils.getURIfromFolder(folder, msgPkgName);
            NewPapyrusModelCommand command = new NewPapyrusModelCommand(modelSet, newURI);
            domain.getCommandStack().execute((Command)command);
            InitFromTemplateCommand tp = new InitFromTemplateCommand(modelSet.getTransactionalEditingDomain(), modelSet, "org.eclipse.papyrus.robotics.wizards", "templates/robotics.servicedef.uml", "templates/robotics.servicedef.notation", "templates/robotics.servidedef.di");
            domain.getCommandStack().execute((Command)tp);
            modelSet.save((IProgressMonitor)new NullProgressMonitor());
            registry.disposeRegistry();
            Resource r = ModelManagement.getResourceSet().getResource(newURI, true);
            Package pkg = (Package)r.getContents().get(0);
            pkg.setName(msgPkgName);
            ReverseUtils.setXmlID((NamedElement)pkg);
            return pkg;
        }
        catch (IOException | ServiceException e) {
            Activator.log.error(e);
            return null;
        }
    }

    public static URI getURIfromFolder(IFolder folder, String msgPkgName) {
        String path = String.valueOf(folder.getProjectRelativePath()) + "/" + msgPkgName + ".servicedef.uml";
        return URI.createPlatformResourceURI((String)(folder.getProject().getName() + "/" + path), (boolean)true);
    }

    public static Package getOrCreatePackage(Package pkg, String nestedName) {
        Package nested = pkg.getNestedPackage(nestedName);
        if (nested == null) {
            nested = pkg.createNestedPackage(nestedName);
            ReverseUtils.setXmlID((NamedElement)nested);
        }
        return nested;
    }

    public static boolean existsAlready(IFolder folder, List<URI> pathMapURIs, String msgPkgName) {
        String fileName = ReverseUtils.fileName(msgPkgName);
        IFile file = folder.getFile(fileName);
        if (file != null && file.exists()) {
            return true;
        }
        for (URI pathURI : pathMapURIs) {
            if (!pathURI.toString().endsWith(fileName)) continue;
            return true;
        }
        return false;
    }

    public static boolean loadMessagePackage(IFolder folder, List<URI> pathMapURIs, String msgPkgName) {
        String fileName = ReverseUtils.fileName(msgPkgName);
        IFile file = folder.getFile(fileName);
        if (file != null && file.exists()) {
            URI uri = ReverseUtils.getURIfromFolder(folder, msgPkgName);
            return ModelManagement.getResourceSet().getResource(uri, true) != null;
        }
        for (URI pathURI : pathMapURIs) {
            if (!pathURI.toString().endsWith(fileName)) continue;
            return ModelManagement.getResourceSet().getResource(pathURI, true) != null;
        }
        return false;
    }

    public static String fileName(String msgPkgName) {
        return msgPkgName + ".servicedef.uml";
    }

    public static boolean getOrCreateCommObject(Package pkg, List<DataType> commObjects, String name) {
        DataType commObject = (DataType)pkg.getOwnedType(name);
        if (commObject == null) {
            commObject = (DataType)pkg.createOwnedType(name, UMLPackage.eINSTANCE.getDataType());
            StereotypeUtil.apply((Element)commObject, CommunicationObject.class);
            ReverseUtils.setXmlID((NamedElement)commObject);
            commObjects.add(commObject);
            return true;
        }
        commObjects.add(commObject);
        return false;
    }

    public static void setXmlID(NamedElement ne) {
        Package root = PackageUtil.getRootPackage((Element)ne);
        ReverseUtils.setXmlID((EObject)ne, "ID" + ne.getQualifiedName().replaceFirst(root.getName(), "").replaceAll("::", "_"));
    }

    public static void setXmlID(EObject eObject, String uniqueID) {
        Resource eObjectRes = eObject.eResource();
        if (eObjectRes instanceof XMLResource) {
            XMLResource xmlResource = (XMLResource)eObjectRes;
            xmlResource.setID(eObject, uniqueID);
        }
    }
}

