/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.reverse.fromfile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.internal.core.model.ASTStringUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.designer.infra.base.StringUtils;
import org.eclipse.papyrus.designer.languages.common.base.StdUriConstants;
import org.eclipse.papyrus.designer.languages.cpp.library.CppUriConstants;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.papyrus.robotics.core.utils.ParameterUtils;
import org.eclipse.papyrus.robotics.profile.robotics.parameters.ParameterEntry;
import org.eclipse.papyrus.robotics.ros2.reverse.ParamInfo;
import org.eclipse.papyrus.uml.diagram.wizards.Activator;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class ReverseParametersFromSource {
    private static final String ADD_PARAMETER = "add_parameter";
    private static final String GET_PARAMETER = "get_parameter";
    private static final String DECLARE_PARAMETER = "declare_parameter";
    protected Class component;
    protected IASTTranslationUnit ast;
    protected List<ParamInfo> paramInfos;
    protected Map<String, ParamInfo> paramInfoMap;

    public ReverseParametersFromSource(Class component, IASTTranslationUnit ast) {
        this.component = component;
        this.ast = ast;
        this.paramInfoMap = new HashMap<String, ParamInfo>();
        this.paramInfos = new ArrayList<ParamInfo>();
    }

    public ParamInfo getParamInfo(String paramName) {
        ParamInfo paramInfo = this.paramInfoMap.get(paramName);
        if (paramInfo == null) {
            paramInfo = new ParamInfo();
            this.paramInfos.add(paramInfo);
            this.paramInfoMap.put(paramName, paramInfo);
        }
        return paramInfo;
    }

    public List<ParamInfo> getParamInfos() {
        return this.paramInfos;
    }

    public void updateParameters() {
        Class paramSet = ParameterUtils.getParameterClass((Class)this.component);
        this.scanFunctions((IASTNode)this.ast);
        for (ParamInfo pi : this.paramInfos) {
            Property paramUML = paramSet.createOwnedAttribute(pi.name, pi.type);
            ParameterEntry entry = (ParameterEntry)StereotypeUtil.applyApp((Element)paramUML, ParameterEntry.class);
            if (pi.defaultValue != null) {
                paramUML.setDefault(pi.defaultValue);
            }
            if (pi.description != null) {
                entry.setDescription(pi.description);
            }
            if (!pi.isList) continue;
            paramUML.setUpper(-1);
        }
    }

    public void scanFunctions(IASTNode node) {
        IASTNode[] iASTNodeArray = node.getChildren();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode child = iASTNodeArray[n2];
            if (child instanceof IASTFunctionDefinition) {
                IASTFunctionDefinition definition = (IASTFunctionDefinition)child;
                this.scanBody((IASTNode)definition.getBody());
            }
            if (child instanceof ICPPASTNamespaceDefinition) {
                this.scanFunctions(child);
            }
            ++n2;
        }
    }

    public static String getASTName(IASTExpression expr) {
        if (expr instanceof IASTFieldReference) {
            IASTName fieldName = ((IASTFieldReference)expr).getFieldName();
            if (fieldName != null) {
                return fieldName.toString();
            }
            return "";
        }
        return expr.toString();
    }

    public static EParam getProviderFromCall(String fctName) {
        if (fctName.equals(DECLARE_PARAMETER)) {
            return EParam.ADD_OR_DECLARE;
        }
        if (fctName.equals(ADD_PARAMETER)) {
            return EParam.ADD_OR_DECLARE;
        }
        if (fctName.equals(GET_PARAMETER)) {
            return EParam.GET_PARAM;
        }
        return EParam.NONE;
    }

    public static String deduceDefaultValue(IASTFunctionCallExpression fCallExpr) {
        IASTInitializerClause[] arguments = fCallExpr.getArguments();
        if (arguments.length > 0) {
            if (arguments[0] instanceof IASTLiteralExpression) {
                return StringUtils.unquote((String)arguments[0].toString());
            }
            if (arguments[0] instanceof IASTUnaryExpression) {
                IASTUnaryExpression unaryExpr = (IASTUnaryExpression)arguments[0];
                return ASTStringUtil.getExpressionString((IASTExpression)unaryExpr);
            }
            if (arguments[0] instanceof IASTFunctionCallExpression) {
                return ReverseParametersFromSource.deduceDefaultValue((IASTFunctionCallExpression)arguments[0]);
            }
        }
        return null;
    }

    public static String deduceTypeName(IASTFunctionCallExpression fCallExpr) {
        IType type;
        IASTInitializerClause[] arguments = fCallExpr.getArguments();
        if (arguments.length > 0 && arguments[0] instanceof IASTLiteralExpression && (type = ((IASTLiteralExpression)arguments[0]).getExpressionType()) != null) {
            if (type.toString().startsWith("const char [")) {
                return "string";
            }
            return type.toString();
        }
        return null;
    }

    public void obtainDeclOrAddDetails(IASTFunctionCallExpression fCallExpr) {
        IASTInitializerClause[] arguments = fCallExpr.getArguments();
        String paramName = StringUtils.unquote((String)arguments[0].toString());
        String defaultValue = null;
        String description = null;
        boolean isList = false;
        if (arguments.length > 1) {
            String literal;
            String typeName = null;
            if (arguments[1] instanceof IASTFunctionCallExpression) {
                IASTFunctionCallExpression fNestedCallExpr = (IASTFunctionCallExpression)arguments[1];
                defaultValue = ReverseParametersFromSource.deduceDefaultValue(fNestedCallExpr);
                typeName = ReverseParametersFromSource.deduceTypeName(fNestedCallExpr);
            } else if (arguments[1] instanceof IASTIdExpression && (typeName = (literal = arguments[1].toString()).replaceFirst("rclcpp::PARAMETER_", "").toLowerCase()).endsWith("_array")) {
                typeName = typeName.replace("_array", "");
                isList = true;
            }
            this.deduceParamType(paramName, typeName);
        }
        if (arguments.length > 2) {
            description = StringUtils.unquote((String)arguments[2].toString());
        }
        ParamInfo paramInfo = this.getParamInfo(paramName);
        paramInfo.name = paramName;
        paramInfo.isList = isList;
        paramInfo.description = description;
        paramInfo.defaultValue = defaultValue;
    }

    public void obtainGetDetails(IASTFunctionCallExpression fCallExpr) {
    }

    protected void deduceParamType(String paramName, String typeName) {
        if (typeName != null) {
            ResourceSet rs = this.component.eResource().getResourceSet();
            PackageUtil.loadPackage((URI)StdUriConstants.UML_PRIM_TYPES_URI, (ResourceSet)rs);
            PackageUtil.loadPackage((URI)CppUriConstants.STL_LIB_URI, (ResourceSet)rs);
            NamedElement ne = ElementUtils.getQualifiedElementFromRS((Element)this.component, (String)typeName);
            if (ne == null) {
                String qName = "AnsiCLibrary::" + typeName;
                ne = ElementUtils.getQualifiedElementFromRS((Element)this.component, (String)qName);
            }
            if (ne == null) {
                String shortName = typeName;
                if (typeName.equals("std::__cxx11::string") || typeName.equals("std::string")) {
                    shortName = "string";
                } else if (typeName.equals("std::vector<string,allocator<string>>")) {
                    shortName = "vector<std::string>";
                }
                NamedElement stdlib = ElementUtils.getQualifiedElementFromRS((Element)this.component, (String)"std");
                if (stdlib instanceof Package) {
                    ne = ((Package)stdlib).getMember(shortName);
                }
            }
            if (ne instanceof Type) {
                ParamInfo paramInfo = this.getParamInfo(paramName);
                paramInfo.name = paramName;
                paramInfo.type = (Type)ne;
            } else {
                Activator.log.debug(String.format("Cannot find type %s", typeName));
            }
        } else {
            Activator.log.debug(String.format("Cannot find type for parameter", paramName));
        }
    }

    public void scanBody(IASTNode node) {
        if (node instanceof IASTFunctionCallExpression) {
            IASTFunctionCallExpression fCallExpr = (IASTFunctionCallExpression)node;
            IASTExpression nameExpr = fCallExpr.getFunctionNameExpression();
            IASTName astName = null;
            if (nameExpr instanceof IASTFieldReference) {
                IASTFieldReference ref = (IASTFieldReference)nameExpr;
                astName = ref.getFieldName();
            } else if (nameExpr instanceof IASTIdExpression) {
                IASTIdExpression nameId = (IASTIdExpression)nameExpr;
                astName = nameId.getName();
            }
            if (astName != null) {
                String fctName = astName.toString();
                EParam param = ReverseParametersFromSource.getProviderFromCall(fctName);
                if (param == EParam.ADD_OR_DECLARE) {
                    this.obtainDeclOrAddDetails(fCallExpr);
                } else if (param == EParam.GET_PARAM) {
                    this.obtainGetDetails(fCallExpr);
                }
            }
        }
        IASTNode[] iASTNodeArray = node.getChildren();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode child = iASTNodeArray[n2];
            this.scanBody(child);
            ++n2;
        }
    }

    static enum EParam {
        ADD_OR_DECLARE,
        GET_PARAM,
        NONE;

    }
}

