/**
 * Copyright (c) 2020 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *  Matteo MORELLI      matteo.morelli@cea.fr - Bug #566899
 */
package org.eclipse.papyrus.robotics.ros2.codegen.python.build;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.papyrus.designer.languages.common.base.file.IPFileSystemAccess;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillDefinition;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillSemantic;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.SkillRealizBuildUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.SkillUtils;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * Create CMakeLists file for a list of skill realizations
 */
@SuppressWarnings("all")
public class CreateSkillRealizCMakeLists {
  public static CharSequence createCMakeLists(final org.eclipse.uml2.uml.Package pkg, final Set<SkillDefinition> skills, final List<String> serviceDependNames) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("cmake_minimum_required(VERSION 3.5.0)");
    _builder.newLine();
    _builder.append("project(");
    String _realizationPackageName = SkillUtils.realizationPackageName(pkg);
    _builder.append(_realizationPackageName);
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("# Default to C++14");
    _builder.newLine();
    _builder.append("if(NOT CMAKE_CXX_STANDARD)");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("set(CMAKE_CXX_STANDARD 14)");
    _builder.newLine();
    _builder.append("endif()");
    _builder.newLine();
    _builder.newLine();
    _builder.append("if(CMAKE_COMPILER_IS_GNUCXX OR CMAKE_CXX_COMPILER_ID MATCHES \"Clang\")");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("add_compile_options(-Wall -Wextra -Wpedantic)");
    _builder.newLine();
    _builder.append("endif()");
    _builder.newLine();
    _builder.newLine();
    _builder.append("find_package(ament_cmake REQUIRED)");
    _builder.newLine();
    _builder.append("find_package(nav2_common REQUIRED)");
    _builder.newLine();
    _builder.append("find_package(rclcpp REQUIRED)");
    _builder.newLine();
    _builder.append("find_package(rclcpp_action REQUIRED)");
    _builder.newLine();
    _builder.append("find_package(behaviortree_cpp_v3 REQUIRED)");
    _builder.newLine();
    _builder.append("find_package(nav2_behavior_tree REQUIRED)");
    _builder.newLine();
    {
      for(final String pkgName : serviceDependNames) {
        _builder.append("find_package(");
        _builder.append(pkgName);
        _builder.append(" REQUIRED)");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("nav2_package()");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("set(dependencies");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("rclcpp");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("rclcpp_action");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("behaviortree_cpp_v3");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("nav2_behavior_tree");
    _builder.newLine();
    {
      for(final String pkgName_1 : serviceDependNames) {
        _builder.append("  ");
        _builder.append(pkgName_1, "  ");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append(")");
    _builder.newLine();
    _builder.newLine();
    {
      for(final SkillDefinition skill : skills) {
        _builder.append("add_library(");
        String _realizationFileName = SkillUtils.realizationFileName(skill);
        _builder.append(_realizationFileName);
        _builder.append("_bt_node SHARED src/");
        String _realizationFileName_1 = SkillUtils.realizationFileName(skill);
        _builder.append(_realizationFileName_1);
        _builder.append(".cpp)");
        _builder.newLineIfNotEmpty();
        _builder.append("list(APPEND plugin_libs ");
        String _realizationFileName_2 = SkillUtils.realizationFileName(skill);
        _builder.append(_realizationFileName_2);
        _builder.append("_bt_node)");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("foreach(bt_plugin ${plugin_libs})");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("ament_target_dependencies(${bt_plugin} ${dependencies})");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("target_compile_definitions(${bt_plugin} PRIVATE BT_PLUGIN_EXPORT)");
    _builder.newLine();
    _builder.append("endforeach()");
    _builder.newLine();
    _builder.newLine();
    _builder.append("install(TARGETS ${plugin_libs}");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("ARCHIVE DESTINATION lib");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("LIBRARY DESTINATION lib");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("RUNTIME DESTINATION lib/${PROJECT_NAME}");
    _builder.newLine();
    _builder.append(")");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("if(BUILD_TESTING)");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("find_package(ament_lint_auto REQUIRED)");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("ament_lint_auto_find_test_dependencies()");
    _builder.newLine();
    _builder.append("endif()");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("ament_export_libraries(");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("${plugin_libs}");
    _builder.newLine();
    _builder.append(")");
    _builder.newLine();
    _builder.newLine();
    _builder.append("ament_export_dependencies(${dependencies})");
    _builder.newLine();
    _builder.newLine();
    _builder.append("ament_package()");
    _builder.newLine();
    return _builder;
  }

  public static void generate(final IPFileSystemAccess fileAccess, final org.eclipse.uml2.uml.Package pkg, final Map<SkillDefinition, SkillSemantic> skdefToSemanticsMap) {
    final List<String> serviceDependNames = SkillRealizBuildUtils.calcDependencies(skdefToSemanticsMap);
    fileAccess.generateFile("CMakeLists.txt", CreateSkillRealizCMakeLists.createCMakeLists(pkg, skdefToSemanticsMap.keySet(), serviceDependNames).toString());
  }
}
