/**
 * Copyright (c) 2020 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *  Ansgar Radermacher  ansgar.radermacher@cea.fr
 */
package org.eclipse.papyrus.robotics.ros2.codegen.cpp.component;

import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.ConstInit;
import org.eclipse.papyrus.robotics.codegen.common.component.CodeSkeleton;
import org.eclipse.papyrus.robotics.profile.robotics.functions.Function;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * Create a template for the code that needs to be filled by a developer.
 */
@SuppressWarnings("all")
public class Ros2CodeSkeleton extends CodeSkeleton {
  public Ros2CodeSkeleton(final org.eclipse.uml2.uml.Class component) {
    super(component);
  }

  @Override
  public Operation addConstrOp(final org.eclipse.uml2.uml.Class skeleton) {
    this.component.createUsage(skeleton);
    final Operation constructorOp = Constructor.addConstrOp(skeleton);
    if ((constructorOp != null)) {
      final ConstInit constInit = UMLUtil.<ConstInit>getStereotypeApplication(constructorOp, ConstInit.class);
      if ((constInit != null)) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = this.component.getName();
        _builder.append(_name);
        _builder.append("(options)");
        constInit.setInitialisation(_builder.toString());
      }
    }
    return constructorOp;
  }

  @Override
  public boolean moveFunction(final org.eclipse.uml2.uml.Class skeleton, final Function function) {
    return super.moveFunction(skeleton, function);
  }
}
