/**
 * Copyright (c) 2020 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *  Ansgar Radermacher  ansgar.radermacher@cea.fr
 */
package org.eclipse.papyrus.robotics.ros2.codegen.cpp.component;

import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.PackageXMLUtils;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * Provide a simple header for components in order to comply with ROS 2 conventions
 */
@SuppressWarnings("all")
public class ComponentHeader {
  public static CharSequence getHeader(final org.eclipse.uml2.uml.Package model) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// --------------------------------------------------------");
    _builder.newLine();
    _builder.append("// Copyright (c)");
    _builder.newLine();
    _builder.append("//");
    _builder.newLine();
    _builder.append("// contributions by ");
    String _authorName = PackageXMLUtils.getAuthorName(model);
    _builder.append(_authorName);
    _builder.newLineIfNotEmpty();
    _builder.append("//                  ");
    String _authorMail = PackageXMLUtils.getAuthorMail(model);
    _builder.append(_authorMail);
    _builder.newLineIfNotEmpty();
    _builder.append("// maintained by    ");
    String _maintainerName = PackageXMLUtils.getMaintainerName(model);
    _builder.append(_maintainerName);
    _builder.newLineIfNotEmpty();
    _builder.append("//                  ");
    String _maintainerMail = PackageXMLUtils.getMaintainerMail(model);
    _builder.append(_maintainerMail);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    return _builder;
  }
}
