/**
 * Copyright (c) 2020 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *  Ansgar Radermacher  ansgar.radermacher@cea.fr
 */
package org.eclipse.papyrus.robotics.ros2.codegen.cpp.build;

import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.papyrus.designer.languages.common.base.file.IPFileSystemAccess;
import org.eclipse.papyrus.designer.languages.common.base.file.ProtSection;
import org.eclipse.papyrus.robotics.codegen.common.utils.PackageTools;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.MessageUtils;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * Create CMakeLists file for a message package
 */
@SuppressWarnings("all")
public class CreateMsgPkgCMakeLists {
  public static CharSequence createCMakeLists(final org.eclipse.uml2.uml.Package msgPackage) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("cmake_minimum_required(VERSION 3.5.0)");
    _builder.newLine();
    _builder.append("project(");
    String _pkgName = PackageTools.pkgName(msgPackage);
    _builder.append(_pkgName);
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("# Default to C++14");
    _builder.newLine();
    _builder.append("if(NOT CMAKE_CXX_STANDARD)");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("set(CMAKE_CXX_STANDARD 14)");
    _builder.newLine();
    _builder.append("endif()");
    _builder.newLine();
    _builder.newLine();
    _builder.append("if(CMAKE_COMPILER_IS_GNUCXX OR CMAKE_CXX_COMPILER_ID MATCHES \"Clang\")");
    _builder.newLine();
    _builder.append("  ");
    _builder.append("add_compile_options(-Wall -Wextra -Wpedantic)");
    _builder.newLine();
    _builder.append("endif()");
    _builder.newLine();
    _builder.newLine();
    final UniqueEList<org.eclipse.uml2.uml.Package> requiredPkgs = MessageUtils.calcDependencies(msgPackage);
    _builder.newLineIfNotEmpty();
    {
      for(final org.eclipse.uml2.uml.Package requiredPkg : requiredPkgs) {
        _builder.append("find_package(");
        String _lowerCase = requiredPkg.getName().toLowerCase();
        _builder.append(_lowerCase);
        _builder.append(" REQUIRED)");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("# ");
    String _protSection = ProtSection.protSection("dependencies");
    _builder.append(_protSection);
    _builder.newLineIfNotEmpty();
    _builder.append("# ");
    String _protSection_1 = ProtSection.protSection();
    _builder.append(_protSection_1);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    final UniqueEList<String> msgFileNames = MessageUtils.getMsgFileNames(msgPackage);
    _builder.newLineIfNotEmpty();
    final UniqueEList<String> srvFileNames = MessageUtils.getSrvFileNames(msgPackage);
    _builder.newLineIfNotEmpty();
    final UniqueEList<String> actFileNames = MessageUtils.getActFileNames(msgPackage);
    _builder.newLineIfNotEmpty();
    {
      if ((((msgFileNames.size() > 0) || (srvFileNames.size() > 0)) || (actFileNames.size() > 0))) {
        _builder.append("find_package(rosidl_default_generators REQUIRED)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Generate messages, services or actions");
        _builder.newLine();
        _builder.append("rosidl_generate_interfaces(");
        _builder.newLine();
        _builder.append("\t");
        String _pkgName_1 = PackageTools.pkgName(msgPackage);
        _builder.append(_pkgName_1, "\t");
        _builder.newLineIfNotEmpty();
        {
          for(final String messageFN : msgFileNames) {
            _builder.append("\t");
            _builder.append("\"msg/");
            _builder.append(messageFN, "\t");
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
          }
        }
        {
          for(final String serviceFN : srvFileNames) {
            _builder.append("\t");
            _builder.append("\"srv/");
            _builder.append(serviceFN, "\t");
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
          }
        }
        {
          for(final String actionFN : actFileNames) {
            _builder.append("\t");
            _builder.append("\"action/");
            _builder.append(actionFN, "\t");
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("DEPENDENCIES ");
        {
          boolean _hasElements = false;
          for(final org.eclipse.uml2.uml.Package requiredPkg_1 : requiredPkgs) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(" ", "\t");
            }
            String _name = requiredPkg_1.getName();
            _builder.append(_name, "\t");
          }
        }
        _builder.newLineIfNotEmpty();
        _builder.append(")");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("ament_package()");
    _builder.newLine();
    return _builder;
  }

  public static void generate(final IPFileSystemAccess fileAccess, final org.eclipse.uml2.uml.Package pkg) {
    fileAccess.generateFile("CMakeLists.txt", CreateMsgPkgCMakeLists.createCMakeLists(pkg).toString());
  }
}
