/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.common.builder;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.papyrus.robotics.ros2.codegen.common.Activator;

public class ColconBuilderUtils {
    public static boolean add(IProject project) {
        if (project != null) {
            block4: {
                if (!ColconBuilderUtils.hasBuilder(project)) break block4;
                return false;
            }
            try {
                IProjectDescription description = project.getDescription();
                ICommand buildCommand = description.newCommand();
                buildCommand.setBuilderName("org.eclipse.papyrus.robotics.ros2.colconbuilder");
                ArrayList<ICommand> commands = new ArrayList<ICommand>();
                commands.addAll(Arrays.asList(description.getBuildSpec()));
                commands.add(buildCommand);
                description.setBuildSpec(commands.toArray(new ICommand[commands.size()]));
                project.setDescription(description, null);
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean hasBuilder(IProject project) {
        try {
            ICommand[] iCommandArray = project.getDescription().getBuildSpec();
            int n = iCommandArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ICommand buildSpec = iCommandArray[n2];
                if ("org.eclipse.papyrus.robotics.ros2.colconbuilder".equals(buildSpec.getBuilderName())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
        return false;
    }
}

