/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.parameters.utils;

import org.eclipse.papyrus.robotics.parameters.utils.RegisteredLibraryLoadAndSearchUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Type;

public class UMLPrimitiveTypesUtils {
    private static final String INTEGER_TYPE_NAME = "PrimitiveTypes::Integer";
    private static final String STRING_TYPE_NAME = "PrimitiveTypes::String";
    private static final String BOOLEAN_TYPE_NAME = "PrimitiveTypes::Boolean";
    private static final String UNLIMITED_NATURAL_TYPE_NAME = "PrimitiveTypes::UnlimitedNatural";
    private static final String REAL_TYPE_NAME = "PrimitiveTypes::Real";
    private static final String UML_PRIMITIVE_TYPES_LIBRARY_NAME = "UMLPrimitiveTypes";

    private static Type getUMLPrimitiveType(Element context, String qualifiedTypeName) {
        NamedElement element = RegisteredLibraryLoadAndSearchUtils.getNamedElement(context, qualifiedTypeName, UML_PRIMITIVE_TYPES_LIBRARY_NAME);
        if (element != null && element instanceof Type) {
            return (Type)element;
        }
        return null;
    }

    public static Type getInteger(Element context) {
        return UMLPrimitiveTypesUtils.getUMLPrimitiveType(context, INTEGER_TYPE_NAME);
    }

    public static Type getBoolean(Element context) {
        return UMLPrimitiveTypesUtils.getUMLPrimitiveType(context, BOOLEAN_TYPE_NAME);
    }

    public static Type getUnlimitedNatural(Element context) {
        return UMLPrimitiveTypesUtils.getUMLPrimitiveType(context, UNLIMITED_NATURAL_TYPE_NAME);
    }

    public static Type getReal(Element context) {
        return UMLPrimitiveTypesUtils.getUMLPrimitiveType(context, REAL_TYPE_NAME);
    }

    public static Type getString(Element context) {
        return UMLPrimitiveTypesUtils.getUMLPrimitiveType(context, STRING_TYPE_NAME);
    }
}

