/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.assertions.languages.othello;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class OCRAIntegration {
    public static final String COMMAND_CHECK_REFINEMENT = "ocra_check_refinement";
    public static final String COMMAND_CHECK_CONSISTENCY = "ocra_check_consistency";
    protected static final String ERROR = "ERROR";
    protected static final String OUTPUT = "OUTPUT";

    public static String getConsoleResult(String absolutePathToOCRA, String absolutePathToOSSFile, String command) {
        try {
            OCRAIntegration ocraInt;
            StringBuffer processText = new StringBuffer();
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(absolutePathToOCRA);
            OCRAIntegration oCRAIntegration = ocraInt = new OCRAIntegration();
            oCRAIntegration.getClass();
            ProcessReaderThread errorStream = oCRAIntegration.new ProcessReaderThread(proc.getErrorStream(), ERROR, processText);
            OCRAIntegration oCRAIntegration2 = ocraInt;
            oCRAIntegration2.getClass();
            ProcessReaderThread outputStream = oCRAIntegration2.new ProcessReaderThread(proc.getInputStream(), OUTPUT, processText);
            errorStream.start();
            outputStream.start();
            BufferedWriter processInput = new BufferedWriter(new OutputStreamWriter(proc.getOutputStream()));
            Object commandToSend = command + " -i " + absolutePathToOSSFile + "\n";
            processInput.write((String)commandToSend);
            processInput.flush();
            commandToSend = "quit\n";
            processInput.write((String)commandToSend);
            processInput.flush();
            proc.waitFor();
            String result = processText.toString();
            result = result.replaceAll("\\*\\*\\*.*\\n", "");
            result = result.replaceAll("ocra >", "");
            result = result.replaceAll("(?m)^[ \t]*\r?\n", "");
            return result;
        }
        catch (Exception t) {
            t.printStackTrace();
            return null;
        }
    }

    public static void writeFile(File file, String text) throws Exception {
        BufferedWriter output = new BufferedWriter(new FileWriter(file, false));
        output.append(text);
        output.close();
    }

    public class ProcessReaderThread
    extends Thread {
        InputStream is;
        String type;
        StringBuffer processText;

        public ProcessReaderThread(InputStream is, String type, StringBuffer processText) {
            this.is = is;
            this.type = type;
            this.processText = processText;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (this.type.equals(OCRAIntegration.OUTPUT)) {
                        this.processText.append(line);
                        this.processText.append("\n");
                    }
                    if (!this.type.equals(OCRAIntegration.ERROR)) continue;
                    this.processText.append(line);
                    this.processText.append("\n");
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

