/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.internal.pdf;

import com.sun.star.beans.PropertyValue;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.odt.Activator;
import org.eclipse.papyrus.model2doc.odt.internal.editor.ODTEditor;
import org.eclipse.papyrus.model2doc.odt.internal.editor.ODTFilterName;
import org.eclipse.papyrus.model2doc.odt.internal.message.Messages;
import org.eclipse.papyrus.model2doc.odt.internal.pdf.PDFVersion;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class PDFExporter {
    private PDFVersion pdfVersion = PDFVersion.PDF_DEFAULT;
    private boolean overwrite = true;
    private static final String DOT = ".";
    private static final String PDF_EXTENSION = "pdf";
    private boolean openEndDialog = false;

    private void refreshWorkspace(String outputFileURI) {
        IProject project;
        int i;
        String wsPath = "file:/" + ResourcesPlugin.getWorkspace().getRoot().getLocation().toPortableString() + "/";
        String pathInWS = outputFileURI.replaceAll(wsPath, "");
        String projectToRefresh = pathInWS.substring(0, i = pathInWS.indexOf("/"));
        if (projectToRefresh != null && !projectToRefresh.isEmpty() && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectToRefresh)) != null) {
            try {
                project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.log.error(NLS.bind((String)"An exception occured during the refresh of the project {0}", (Object)projectToRefresh), (Throwable)e);
            }
        }
    }

    public String exportToPDF(String inputFileURI) throws Exception {
        int lastDot = inputFileURI.lastIndexOf(DOT);
        String filePathWithoutExtension = inputFileURI.substring(0, lastDot);
        StringBuilder outputFilePathBuilder = new StringBuilder(filePathWithoutExtension);
        outputFilePathBuilder.append(DOT);
        outputFilePathBuilder.append(PDF_EXTENSION);
        return this.exportFile(inputFileURI, outputFilePathBuilder.toString());
    }

    public String exportToPDF(String inputFileURI, String outputFolderURI) throws Exception {
        int lastSeparator = inputFileURI.lastIndexOf("/");
        String outputFileName = inputFileURI.substring(lastSeparator + 1, inputFileURI.lastIndexOf(DOT));
        StringBuffer outputFilePathBuilder = new StringBuffer(outputFolderURI);
        if (!outputFolderURI.endsWith("/")) {
            outputFilePathBuilder.append("/");
        }
        outputFilePathBuilder.append(outputFileName);
        outputFilePathBuilder.append(DOT);
        outputFilePathBuilder.append(PDF_EXTENSION);
        return this.exportFile(inputFileURI, outputFilePathBuilder.toString());
    }

    public String exportToPDF(String inputFileURI, String outputFolderURI, String outputFileName) throws Exception {
        if (outputFileName.contains(DOT)) {
            throw new Exception("The fileURI is not conform to the expected one");
        }
        StringBuffer outputFilePathBuilder = new StringBuffer(outputFolderURI);
        if (!outputFolderURI.endsWith("/")) {
            outputFilePathBuilder.append("/");
        }
        outputFilePathBuilder.append(outputFileName);
        outputFilePathBuilder.append(DOT);
        outputFilePathBuilder.append(PDF_EXTENSION);
        return this.exportFile(inputFileURI, outputFilePathBuilder.toString());
    }

    protected final String exportFile(String inputFileURI, String outputFileURI) {
        ODTEditor odtEditor = new ODTEditor();
        PropertyValue[] storeProperties = this.createStoreProperties();
        String savedFilePath = null;
        try {
            savedFilePath = odtEditor.exportDocument(inputFileURI, outputFileURI, storeProperties);
            if (this.openEndDialog) {
                this.openEndDialog(savedFilePath.replaceAll("file:///", ""));
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
        this.refreshWorkspace(outputFileURI);
        return savedFilePath;
    }

    private void openEndDialog(String generatedFilePath) {
        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.PDFExporter_GeneratePDF, (String)NLS.bind((String)Messages.PDFExporter_PDFHasBeenGenerated, (Object)generatedFilePath));
    }

    public void setPDFVersion(PDFVersion pdfVersion) {
        this.pdfVersion = pdfVersion;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setOpenEndDialog(boolean openEndDialog) {
        this.openEndDialog = openEndDialog;
    }

    private final PropertyValue[] createStoreProperties() {
        List<PropertyValue> values = this.doCreateStoreProperties();
        return values.toArray(new PropertyValue[values.size()]);
    }

    protected List<PropertyValue> doCreateStoreProperties() {
        ArrayList<PropertyValue> values = new ArrayList<PropertyValue>();
        PropertyValue storeProps = new PropertyValue();
        values.add(storeProps);
        storeProps = new PropertyValue();
        storeProps.Name = "Overwrite";
        storeProps.Value = this.overwrite;
        storeProps = new PropertyValue();
        values.add(storeProps);
        storeProps.Name = "FilterName";
        storeProps.Value = ODTFilterName.WRITER_PDF_EXPORT.getFilterName();
        storeProps = new PropertyValue();
        values.add(storeProps);
        storeProps.Name = "FilterData";
        storeProps.Value = this.createFilterData();
        return values;
    }

    private final PropertyValue[] createFilterData() {
        List<PropertyValue> values = this.doCreateFilterData();
        return values.toArray(new PropertyValue[values.size()]);
    }

    protected List<PropertyValue> doCreateFilterData() {
        ArrayList<PropertyValue> values = new ArrayList<PropertyValue>();
        PropertyValue storeProps = new PropertyValue();
        values.add(storeProps);
        storeProps.Name = "SelectPdfVersion";
        storeProps.Value = this.pdfVersion.getCode();
        return values;
    }
}

