/*****************************************************************************
 * Copyright (c) 2023 CEA LIST and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 *
 *****************************************************************************/

package org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.internal.operations;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.IBodySectionPartTemplate;
import org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.CommentInMarkupToFile;
import org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.StereotypePropertyAttributeInMarkupToFile;
import org.eclipse.papyrus.model2doc.uml.documentstructuretemplate.operations.UMLBodySectionPartTemplateTitleHelper;

/**
 * Title builder helper for Markup UML PartTemplate
 */
public class MarkupUMLBodySectionPartTemplateTitleHelper extends UMLBodySectionPartTemplateTitleHelper {

	/**
	 * Shared instance of {@link MarkupUMLBodySectionPartTemplateTitleHelper}
	 */
	public static final MarkupUMLBodySectionPartTemplateTitleHelper MARKUP_UML_INSTANCE = new MarkupUMLBodySectionPartTemplateTitleHelper();

	/**
	 * @see org.eclipse.papyrus.model2doc.uml.documentstructuretemplate.operations.UMLBodySectionPartTemplateTitleHelper#internalBuildPartTemplateTitle(org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.IBodySectionPartTemplate,
	 *      org.eclipse.emf.ecore.EObject)
	 *
	 * @param partTemplate
	 * @param parameter
	 * @return
	 */
	@Override
	protected String internalBuildPartTemplateTitle(final IBodySectionPartTemplate partTemplate, final EObject parameter) {
		if (partTemplate instanceof StereotypePropertyAttributeInMarkupToFile) {
			return buildStereotypePropertyAttributeInMarkupToFileTitle((StereotypePropertyAttributeInMarkupToFile) partTemplate);
		} else if (partTemplate instanceof CommentInMarkupToFile) {
			return buildCommentInMarkupToFileTitle((CommentInMarkupToFile) partTemplate);
		}
		return null;
	}

	/**
	 *
	 * @param stereotypePropertyAttributeInMarkupToHtmlFile
	 *            a stereotype part Template
	 * @param parameter
	 *            the eobject for which we want to build the title
	 * @return
	 *         the string to use for the tile of the element
	 */
	private String buildStereotypePropertyAttributeInMarkupToFileTitle(final StereotypePropertyAttributeInMarkupToFile stereotypePropertyAttributeInMarkupToHtmlFile) {
		if (null != stereotypePropertyAttributeInMarkupToHtmlFile.getPropertyName() && false == stereotypePropertyAttributeInMarkupToHtmlFile.getPropertyName().isEmpty()) {
			return stereotypePropertyAttributeInMarkupToHtmlFile.getPropertyName();
		}
		return "No Property Name"; //$NON-NLS-1$
	}

	/**
	 *
	 * @param commentInMarkupToFile
	 *            a {@link CommentInMarkupToFile} object
	 * @return
	 *         the title to use for this element
	 */
	private String buildCommentInMarkupToFileTitle(final CommentInMarkupToFile commentInMarkupToFile) {
		switch (commentInMarkupToFile.getCommentChoice()) {
		case FIRST_OWNED_COMMENT:
			return "Comment"; //$NON-NLS-1$
		case ALL_OWNED_COMMENTS:
		default:
			return "Comments"; //$NON-NLS-1$
		}
	}

}
