/**
 * Copyright (c) 2023 CEA LIST.
 *
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License 2.0
 *  which accompanies this distribution, and is available at
 *  https://www.eclipse.org/legal/epl-2.0/
 *
 *  SPDX-License-Identifier: EPL-2.0
 *
 *  Contributors:
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 */
package org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentStructureTemplatePackage;

import org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.MarkupEMFDocumentStructureTemplatePackage;
import org.eclipse.papyrus.model2doc.uml.documentstructuretemplate.UMLDocumentStructureTemplatePackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 * <li>each class,</li>
 * <li>each feature of each class,</li>
 * <li>each operation of each class,</li>
 * <li>each enum,</li>
 * <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 *
 * @see org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.MarkupUMLDocumentStructureTemplateFactory
 * @model kind="package"
 *        annotation="http://www.eclipse.org/uml2/2.0.0/UML originalName='markupumldocumentstructuretemplate'"
 * @generated
 */
public interface MarkupUMLDocumentStructureTemplatePackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	String eNAME = "documentstructuretemplate"; //$NON-NLS-1$

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/papyrus/model2doc/markup/uml/1.0.0/documentstructuretemplate"; //$NON-NLS-1$

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	String eNS_PREFIX = "markup.uml.documentstructuretemplate"; //$NON-NLS-1$

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	MarkupUMLDocumentStructureTemplatePackage eINSTANCE = org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.impl.MarkupUMLDocumentStructureTemplatePackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.impl.StereotypePropertyAttributeInMarkupToFileImpl <em>Stereotype Property Attribute In Markup To File</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.impl.StereotypePropertyAttributeInMarkupToFileImpl
	 * @see org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.impl.MarkupUMLDocumentStructureTemplatePackageImpl#getStereotypePropertyAttributeInMarkupToFile()
	 * @generated
	 */
	int STEREOTYPE_PROPERTY_ATTRIBUTE_IN_MARKUP_TO_FILE = 0;

	/**
	 * The feature id for the '<em><b>Stereotype Filter Rule</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_PROPERTY_ATTRIBUTE_IN_MARKUP_TO_FILE__STEREOTYPE_FILTER_RULE = UMLDocumentStructureTemplatePackage.STEREOTYPE_PROPERTY_TEMPLATE__STEREOTYPE_FILTER_RULE;

	/**
	 * The feature id for the '<em><b>Stereotype Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_PROPERTY_ATTRIBUTE_IN_MARKUP_TO_FILE__STEREOTYPE_QUALIFIED_NAME = UMLDocumentStructureTemplatePackage.STEREOTYPE_PROPERTY_TEMPLATE__STEREOTYPE_QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Property Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_PROPERTY_ATTRIBUTE_IN_MARKUP_TO_FILE__PROPERTY_NAME = UMLDocumentStructureTemplatePackage.STEREOTYPE_PROPERTY_TEMPLATE__PROPERTY_NAME;

	/**
	 * The feature id for the '<em><b>Generate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_PROPERTY_ATTRIBUTE_IN_MARKUP_TO_FILE__GENERATE = UMLDocumentStructureTemplatePackage.STEREOTYPE_PROPERTY_TEMPLATE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Generate Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_PROPERTY_ATTRIBUTE_IN_MARKUP_TO_FILE__GENERATE_TITLE = UMLDocumentStructureTemplatePackage.STEREOTYPE_PROPERTY_TEMPLATE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Custom Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_PROPERTY_ATTRIBUTE_IN_MARKUP_TO_FILE__CUSTOM_TITLE = UMLDocumentStructureTemplatePackage.STEREOTYPE_PROPERTY_TEMPLATE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Generate Branch Condition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_PROPERTY_ATTRIBUTE_IN_MARKUP_TO_FILE__GENERATE_BRANCH_CONDITION = UMLDocumentStructureTemplatePackage.STEREOTYPE_PROPERTY_TEMPLATE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Generate If Empty</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_PROPERTY_ATTRIBUTE_IN_MARKUP_TO_FILE__GENERATE_IF_EMPTY = UMLDocumentStructureTemplatePackage.STEREOTYPE_PROPERTY_TEMPLATE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Default Text If Empty</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_PROPERTY_ATTRIBUTE_IN_MARKUP_TO_FILE__DEFAULT_TEXT_IF_EMPTY = UMLDocumentStructureTemplatePackage.STEREOTYPE_PROPERTY_TEMPLATE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Input Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_PROPERTY_ATTRIBUTE_IN_MARKUP_TO_FILE__INPUT_FORMAT = UMLDocumentStructureTemplatePackage.STEREOTYPE_PROPERTY_TEMPLATE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Output Fomat</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_PROPERTY_ATTRIBUTE_IN_MARKUP_TO_FILE__OUTPUT_FOMAT = UMLDocumentStructureTemplatePackage.STEREOTYPE_PROPERTY_TEMPLATE_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>Stereotype Property Attribute In Markup To File</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_PROPERTY_ATTRIBUTE_IN_MARKUP_TO_FILE_FEATURE_COUNT = UMLDocumentStructureTemplatePackage.STEREOTYPE_PROPERTY_TEMPLATE_FEATURE_COUNT + 8;

	/**
	 * The operation id for the '<em>Get First Matching Stereotype Application</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_PROPERTY_ATTRIBUTE_IN_MARKUP_TO_FILE___GET_FIRST_MATCHING_STEREOTYPE_APPLICATION__EOBJECT = UMLDocumentStructureTemplatePackage.STEREOTYPE_PROPERTY_TEMPLATE___GET_FIRST_MATCHING_STEREOTYPE_APPLICATION__EOBJECT;

	/**
	 * The operation id for the '<em>Get Stereotype Property Values</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_PROPERTY_ATTRIBUTE_IN_MARKUP_TO_FILE___GET_STEREOTYPE_PROPERTY_VALUES__EOBJECT = UMLDocumentStructureTemplatePackage.STEREOTYPE_PROPERTY_TEMPLATE___GET_STEREOTYPE_PROPERTY_VALUES__EOBJECT;

	/**
	 * The operation id for the '<em>Build Part Template Title</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_PROPERTY_ATTRIBUTE_IN_MARKUP_TO_FILE___BUILD_PART_TEMPLATE_TITLE__EOBJECT = UMLDocumentStructureTemplatePackage.STEREOTYPE_PROPERTY_TEMPLATE_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Generate Branch</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_PROPERTY_ATTRIBUTE_IN_MARKUP_TO_FILE___GENERATE_BRANCH__EOBJECT = UMLDocumentStructureTemplatePackage.STEREOTYPE_PROPERTY_TEMPLATE_OPERATION_COUNT + 1;

	/**
	 * The number of operations of the '<em>Stereotype Property Attribute In Markup To File</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_PROPERTY_ATTRIBUTE_IN_MARKUP_TO_FILE_OPERATION_COUNT = UMLDocumentStructureTemplatePackage.STEREOTYPE_PROPERTY_TEMPLATE_OPERATION_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.IMarkupUMLBodyPartTemplateTitle <em>IMarkup UML Body Part Template Title</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.IMarkupUMLBodyPartTemplateTitle
	 * @see org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.impl.MarkupUMLDocumentStructureTemplatePackageImpl#getIMarkupUMLBodyPartTemplateTitle()
	 * @generated
	 */
	int IMARKUP_UML_BODY_PART_TEMPLATE_TITLE = 1;

	/**
	 * The feature id for the '<em><b>Generate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int IMARKUP_UML_BODY_PART_TEMPLATE_TITLE__GENERATE = MarkupEMFDocumentStructureTemplatePackage.IMARKUP_TO_FILE_BODY_PART_TEMPLATE__GENERATE;

	/**
	 * The feature id for the '<em><b>Generate Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int IMARKUP_UML_BODY_PART_TEMPLATE_TITLE__GENERATE_TITLE = MarkupEMFDocumentStructureTemplatePackage.IMARKUP_TO_FILE_BODY_PART_TEMPLATE__GENERATE_TITLE;

	/**
	 * The feature id for the '<em><b>Custom Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int IMARKUP_UML_BODY_PART_TEMPLATE_TITLE__CUSTOM_TITLE = MarkupEMFDocumentStructureTemplatePackage.IMARKUP_TO_FILE_BODY_PART_TEMPLATE__CUSTOM_TITLE;

	/**
	 * The feature id for the '<em><b>Generate Branch Condition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int IMARKUP_UML_BODY_PART_TEMPLATE_TITLE__GENERATE_BRANCH_CONDITION = MarkupEMFDocumentStructureTemplatePackage.IMARKUP_TO_FILE_BODY_PART_TEMPLATE__GENERATE_BRANCH_CONDITION;

	/**
	 * The feature id for the '<em><b>Generate If Empty</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int IMARKUP_UML_BODY_PART_TEMPLATE_TITLE__GENERATE_IF_EMPTY = MarkupEMFDocumentStructureTemplatePackage.IMARKUP_TO_FILE_BODY_PART_TEMPLATE__GENERATE_IF_EMPTY;

	/**
	 * The feature id for the '<em><b>Default Text If Empty</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int IMARKUP_UML_BODY_PART_TEMPLATE_TITLE__DEFAULT_TEXT_IF_EMPTY = MarkupEMFDocumentStructureTemplatePackage.IMARKUP_TO_FILE_BODY_PART_TEMPLATE__DEFAULT_TEXT_IF_EMPTY;

	/**
	 * The feature id for the '<em><b>Input Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int IMARKUP_UML_BODY_PART_TEMPLATE_TITLE__INPUT_FORMAT = MarkupEMFDocumentStructureTemplatePackage.IMARKUP_TO_FILE_BODY_PART_TEMPLATE__INPUT_FORMAT;

	/**
	 * The feature id for the '<em><b>Output Fomat</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int IMARKUP_UML_BODY_PART_TEMPLATE_TITLE__OUTPUT_FOMAT = MarkupEMFDocumentStructureTemplatePackage.IMARKUP_TO_FILE_BODY_PART_TEMPLATE__OUTPUT_FOMAT;

	/**
	 * The number of structural features of the '<em>IMarkup UML Body Part Template Title</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int IMARKUP_UML_BODY_PART_TEMPLATE_TITLE_FEATURE_COUNT = MarkupEMFDocumentStructureTemplatePackage.IMARKUP_TO_FILE_BODY_PART_TEMPLATE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Build Part Template Title</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int IMARKUP_UML_BODY_PART_TEMPLATE_TITLE___BUILD_PART_TEMPLATE_TITLE__EOBJECT = MarkupEMFDocumentStructureTemplatePackage.IMARKUP_TO_FILE_BODY_PART_TEMPLATE___BUILD_PART_TEMPLATE_TITLE__EOBJECT;

	/**
	 * The operation id for the '<em>Generate Branch</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int IMARKUP_UML_BODY_PART_TEMPLATE_TITLE___GENERATE_BRANCH__EOBJECT = MarkupEMFDocumentStructureTemplatePackage.IMARKUP_TO_FILE_BODY_PART_TEMPLATE___GENERATE_BRANCH__EOBJECT;

	/**
	 * The number of operations of the '<em>IMarkup UML Body Part Template Title</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int IMARKUP_UML_BODY_PART_TEMPLATE_TITLE_OPERATION_COUNT = MarkupEMFDocumentStructureTemplatePackage.IMARKUP_TO_FILE_BODY_PART_TEMPLATE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.impl.CommentInMarkupToFileImpl <em>Comment In Markup To File</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.impl.CommentInMarkupToFileImpl
	 * @see org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.impl.MarkupUMLDocumentStructureTemplatePackageImpl#getCommentInMarkupToFile()
	 * @generated
	 */
	int COMMENT_IN_MARKUP_TO_FILE = 2;

	/**
	 * The feature id for the '<em><b>Generate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int COMMENT_IN_MARKUP_TO_FILE__GENERATE = DocumentStructureTemplatePackage.ITEMPLATE_PART_VIEW_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Generate Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int COMMENT_IN_MARKUP_TO_FILE__GENERATE_TITLE = DocumentStructureTemplatePackage.ITEMPLATE_PART_VIEW_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Custom Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int COMMENT_IN_MARKUP_TO_FILE__CUSTOM_TITLE = DocumentStructureTemplatePackage.ITEMPLATE_PART_VIEW_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Generate Branch Condition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int COMMENT_IN_MARKUP_TO_FILE__GENERATE_BRANCH_CONDITION = DocumentStructureTemplatePackage.ITEMPLATE_PART_VIEW_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Generate If Empty</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int COMMENT_IN_MARKUP_TO_FILE__GENERATE_IF_EMPTY = DocumentStructureTemplatePackage.ITEMPLATE_PART_VIEW_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Default Text If Empty</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int COMMENT_IN_MARKUP_TO_FILE__DEFAULT_TEXT_IF_EMPTY = DocumentStructureTemplatePackage.ITEMPLATE_PART_VIEW_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Input Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int COMMENT_IN_MARKUP_TO_FILE__INPUT_FORMAT = DocumentStructureTemplatePackage.ITEMPLATE_PART_VIEW_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Output Fomat</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int COMMENT_IN_MARKUP_TO_FILE__OUTPUT_FOMAT = DocumentStructureTemplatePackage.ITEMPLATE_PART_VIEW_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Comment Choice</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int COMMENT_IN_MARKUP_TO_FILE__COMMENT_CHOICE = DocumentStructureTemplatePackage.ITEMPLATE_PART_VIEW_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>Comment In Markup To File</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int COMMENT_IN_MARKUP_TO_FILE_FEATURE_COUNT = DocumentStructureTemplatePackage.ITEMPLATE_PART_VIEW_FEATURE_COUNT + 9;

	/**
	 * The operation id for the '<em>Build Part Template Title</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int COMMENT_IN_MARKUP_TO_FILE___BUILD_PART_TEMPLATE_TITLE__EOBJECT = DocumentStructureTemplatePackage.ITEMPLATE_PART_VIEW_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Generate Branch</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int COMMENT_IN_MARKUP_TO_FILE___GENERATE_BRANCH__EOBJECT = DocumentStructureTemplatePackage.ITEMPLATE_PART_VIEW_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Get Matching Comments</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int COMMENT_IN_MARKUP_TO_FILE___GET_MATCHING_COMMENTS__EOBJECT = DocumentStructureTemplatePackage.ITEMPLATE_PART_VIEW_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Comment In Markup To File</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 * @ordered
	 */
	int COMMENT_IN_MARKUP_TO_FILE_OPERATION_COUNT = DocumentStructureTemplatePackage.ITEMPLATE_PART_VIEW_OPERATION_COUNT + 3;


	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.StereotypePropertyAttributeInMarkupToFile <em>Stereotype Property Attribute In Markup To File</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return the meta object for class '<em>Stereotype Property Attribute In Markup To File</em>'.
	 * @see org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.StereotypePropertyAttributeInMarkupToFile
	 * @generated
	 */
	EClass getStereotypePropertyAttributeInMarkupToFile();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.IMarkupUMLBodyPartTemplateTitle <em>IMarkup UML Body Part Template Title</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return the meta object for class '<em>IMarkup UML Body Part Template Title</em>'.
	 * @see org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.IMarkupUMLBodyPartTemplateTitle
	 * @generated
	 */
	EClass getIMarkupUMLBodyPartTemplateTitle();

	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.CommentInMarkupToFile <em>Comment In Markup To File</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return the meta object for class '<em>Comment In Markup To File</em>'.
	 * @see org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.CommentInMarkupToFile
	 * @generated
	 */
	EClass getCommentInMarkupToFile();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.CommentInMarkupToFile#getCommentChoice <em>Comment Choice</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return the meta object for the attribute '<em>Comment Choice</em>'.
	 * @see org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.CommentInMarkupToFile#getCommentChoice()
	 * @see #getCommentInMarkupToFile()
	 * @generated
	 */
	EAttribute getCommentInMarkupToFile_CommentChoice();

	/**
	 * Returns the meta object for the '{@link org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.CommentInMarkupToFile#getMatchingComments(org.eclipse.emf.ecore.EObject) <em>Get Matching Comments</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return the meta object for the '<em>Get Matching Comments</em>' operation.
	 * @see org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.CommentInMarkupToFile#getMatchingComments(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	EOperation getCommentInMarkupToFile__GetMatchingComments__EObject();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	MarkupUMLDocumentStructureTemplateFactory getMarkupUMLDocumentStructureTemplateFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 * <li>each class,</li>
	 * <li>each feature of each class,</li>
	 * <li>each operation of each class,</li>
	 * <li>each enum,</li>
	 * <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.impl.StereotypePropertyAttributeInMarkupToFileImpl <em>Stereotype Property Attribute In Markup To File</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 *
		 * @see org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.impl.StereotypePropertyAttributeInMarkupToFileImpl
		 * @see org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.impl.MarkupUMLDocumentStructureTemplatePackageImpl#getStereotypePropertyAttributeInMarkupToFile()
		 * @generated
		 */
		EClass STEREOTYPE_PROPERTY_ATTRIBUTE_IN_MARKUP_TO_FILE = eINSTANCE.getStereotypePropertyAttributeInMarkupToFile();

		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.IMarkupUMLBodyPartTemplateTitle <em>IMarkup UML Body Part Template Title</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 *
		 * @see org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.IMarkupUMLBodyPartTemplateTitle
		 * @see org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.impl.MarkupUMLDocumentStructureTemplatePackageImpl#getIMarkupUMLBodyPartTemplateTitle()
		 * @generated
		 */
		EClass IMARKUP_UML_BODY_PART_TEMPLATE_TITLE = eINSTANCE.getIMarkupUMLBodyPartTemplateTitle();

		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.impl.CommentInMarkupToFileImpl <em>Comment In Markup To File</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 *
		 * @see org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.impl.CommentInMarkupToFileImpl
		 * @see org.eclipse.papyrus.model2doc.markup.uml.documentstructuretemplate.impl.MarkupUMLDocumentStructureTemplatePackageImpl#getCommentInMarkupToFile()
		 * @generated
		 */
		EClass COMMENT_IN_MARKUP_TO_FILE = eINSTANCE.getCommentInMarkupToFile();

		/**
		 * The meta object literal for the '<em><b>Comment Choice</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 *
		 * @generated
		 */
		EAttribute COMMENT_IN_MARKUP_TO_FILE__COMMENT_CHOICE = eINSTANCE.getCommentInMarkupToFile_CommentChoice();

		/**
		 * The meta object literal for the '<em><b>Get Matching Comments</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 *
		 * @generated
		 */
		EOperation COMMENT_IN_MARKUP_TO_FILE___GET_MATCHING_COMMENTS__EOBJECT = eINSTANCE.getCommentInMarkupToFile__GetMatchingComments__EObject();

	}

} // MarkupUMLDocumentStructureTemplatePackage
