/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.docx.internal.services;

import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.core.builtintypes.AbstractTable;
import org.eclipse.papyrus.model2doc.core.builtintypes.Cell;
import org.eclipse.papyrus.model2doc.core.builtintypes.CellLocation;
import org.eclipse.papyrus.model2doc.core.builtintypes.Row;
import org.eclipse.papyrus.model2doc.docx.Activator;
import org.eclipse.papyrus.model2doc.docx.services.StyleService;

public class StyleServiceImpl
implements StyleService {
    @Override
    public boolean applyDocumentMainTitleStyle(XWPFParagraph paragraph) {
        String style = this.getDocumentMainTitleStyle();
        return this.applyStyle(paragraph, style);
    }

    @Override
    public boolean applySectionTitleStyle(XWPFParagraph paragraph, int sectionLevel) {
        String style = this.getSectionTitleStyle(sectionLevel);
        return this.applyStyle(paragraph, style);
    }

    @Override
    public boolean applyTableStyle(XWPFTable xwpfTable, XWPFDocument document, AbstractTable tableDescription) {
        EList rows;
        boolean isRowHeader = false;
        boolean isColumnHeader = false;
        if (tableDescription.getRowsNumber() != 0) {
            rows = tableDescription.getRows();
            isRowHeader = rows.stream().allMatch(r -> ((Cell)r.getCells().get(0)).getLocation().equals((Object)CellLocation.ROW_HEADER) || ((Cell)r.getCells().get(0)).getLocation().equals((Object)CellLocation.CORNER));
        }
        if (tableDescription.getColumnsNumber() != 0) {
            rows = tableDescription.getRows();
            isColumnHeader = ((Row)rows.get(0)).getCells().stream().allMatch(c -> c.getLocation() == CellLocation.COLUMN_HEADER || c.getLocation() == CellLocation.CORNER);
        }
        String styleName = isRowHeader && isColumnHeader ? "TableStyleWithBothHeader" : (isRowHeader ? "TableStyleWithRowHeaderOnly" : (isColumnHeader ? "TableStyleWithColumnHeaderOnly" : "TableWithoutHeader"));
        if (document.getStyles() != null && document.getStyles().styleExist(styleName)) {
            xwpfTable.setStyleID(styleName);
            return true;
        }
        Activator.log.warn(NLS.bind((String)"the style {0} does not exist in the template file", (Object)styleName));
        return false;
    }

    @Override
    public boolean applyCaptionStyle(XWPFParagraph paragraph, XWPFDocument document) {
        String style = this.getCaptionStyleValue();
        return this.applyStyle(paragraph, style);
    }

    @Override
    public boolean applyListStyle(XWPFParagraph paragraph) {
        String style = this.getListStyleValue();
        return this.applyStyle(paragraph, style);
    }

    @Override
    public boolean applyStyle(XWPFParagraph paragraph, String styleName) {
        XWPFDocument document = paragraph.getDocument();
        if (document.getStyles() != null && document.getStyles().styleExist(styleName)) {
            paragraph.setStyle(styleName);
            return true;
        }
        Activator.log.warn(NLS.bind((String)"the style {0} does not exist in the template file", (Object)styleName));
        return false;
    }

    @Override
    public String getDocumentMainTitleStyle() {
        return "Titre";
    }

    @Override
    public String getSectionTitleStyle(int sectionLevel) {
        return this.getSectionStylePrefix() + sectionLevel;
    }

    @Override
    public String getSectionStylePrefix() {
        return "Titre";
    }

    @Override
    public String getCaptionStyleValue() {
        return "Lgende";
    }

    @Override
    public String getListStyleValue() {
        return "Paragraphedeliste";
    }
}

