/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.python.codegen.transformation;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.ClassUtils;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.python.profile.python.External;
import org.eclipse.papyrus.designer.languages.python.profile.python.Module;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class PythonCodeGenUtils {
    public static String getPythonQName(NamedElement element) {
        org.eclipse.papyrus.designer.languages.common.profile.Codegen.External external = (org.eclipse.papyrus.designer.languages.common.profile.Codegen.External)UMLUtil.getStereotypeApplication((Element)element, org.eclipse.papyrus.designer.languages.common.profile.Codegen.External.class);
        if (external != null && external.getName() != null) {
            return external.getName();
        }
        return element.getQualifiedName().toLowerCase().replace("::", ".");
    }

    public static String getRelativePath(Classifier src, NamedElement target) {
        Object dot = ".";
        Namespace ns = src.getNamespace();
        while (!target.allNamespaces().contains((Object)ns) && ns != null) {
            String _dot = dot;
            dot = _dot + ".";
            ns = ns.getNamespace();
        }
        if (ns != null) {
            String _pythonQName = PythonCodeGenUtils.getPythonQName(target);
            String _pythonQName_1 = PythonCodeGenUtils.getPythonQName((NamedElement)ns);
            String _plus = _pythonQName_1 + ".";
            String _replaceFirst = _pythonQName.replaceFirst(_plus, "");
            return (String)dot + _replaceFirst;
        }
        return PythonCodeGenUtils.getPythonQName(target);
    }

    public static ArrayList<Package> getPackageDep(Classifier src) {
        ArrayList packDp = CollectionLiterals.newArrayList();
        EList _clientDependencies = src.getClientDependencies();
        for (Dependency dependency : _clientDependencies) {
            Functions.Function1 _function = it -> it instanceof Package;
            Iterable _filter = IterableExtensions.filter((Iterable)dependency.getTargets(), (Functions.Function1)_function);
            for (Element target : _filter) {
                packDp.add((Package)target);
            }
        }
        return packDp;
    }

    public static Iterable<Classifier> pyRequiredClassifiers(Classifier classifier) {
        Functions.Function1 _function = it -> !GenUtils.isUMLPrimitiveType((Classifier)it) && !PythonCodeGenUtils.isPythonPrimitiveType(it);
        return IterableExtensions.filter((Iterable)ClassUtils.requiredClassifiers((Classifier)classifier), (Functions.Function1)_function);
    }

    public static boolean isPythonPrimitiveType(Classifier type) {
        String owningPkgName = type.getNearestPackage().getName();
        return "PythonStdLib".equals(owningPkgName);
    }

    public static CharSequence writeImports(Classifier classifier, boolean useRelativeImports) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isAbstract = classifier.isAbstract();
        if (_isAbstract) {
            _builder.append("from abc import ABC, abstractmethod");
            _builder.newLine();
        }
        ArrayList<Package> _packageDep = PythonCodeGenUtils.getPackageDep(classifier);
        for (Package pkg : _packageDep) {
            _builder.append("import ");
            String _pythonQName = PythonCodeGenUtils.getPythonQName((NamedElement)pkg);
            _builder.append(_pythonQName);
            _builder.newLineIfNotEmpty();
        }
        Iterable<Classifier> _pyRequiredClassifiers = PythonCodeGenUtils.pyRequiredClassifiers(classifier);
        for (Classifier dependencyClassifier : _pyRequiredClassifiers) {
            NamedElement mp = PythonCodeGenUtils.modulePkg((NamedElement)dependencyClassifier);
            _builder.newLineIfNotEmpty();
            External extPython = (External)UMLUtil.getStereotypeApplication((Element)dependencyClassifier, External.class);
            _builder.newLineIfNotEmpty();
            org.eclipse.papyrus.designer.languages.common.profile.Codegen.External extCommon = (org.eclipse.papyrus.designer.languages.common.profile.Codegen.External)UMLUtil.getStereotypeApplication((Element)dependencyClassifier, org.eclipse.papyrus.designer.languages.common.profile.Codegen.External.class);
            _builder.newLineIfNotEmpty();
            if (extPython != null) {
                String _externalImport = PythonCodeGenUtils.externalImport((org.eclipse.papyrus.designer.languages.common.profile.Codegen.External)extPython);
                _builder.append(_externalImport);
                _builder.newLineIfNotEmpty();
                continue;
            }
            if (extCommon != null) {
                String _externalImport_1 = PythonCodeGenUtils.externalImport(extCommon);
                _builder.append(_externalImport_1);
                _builder.newLineIfNotEmpty();
                continue;
            }
            if (useRelativeImports) {
                _builder.append("from ");
                String _relativePath = PythonCodeGenUtils.getRelativePath(classifier, mp);
                _builder.append(_relativePath);
                _builder.append(" import ");
                String _name = dependencyClassifier.getName();
                _builder.append(_name);
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append("from ");
            String _pythonQName_1 = PythonCodeGenUtils.getPythonQName(mp);
            _builder.append(_pythonQName_1);
            _builder.append(" import ");
            String _name_1 = dependencyClassifier.getName();
            _builder.append(_name_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static String externalImport(org.eclipse.papyrus.designer.languages.common.profile.Codegen.External external) {
        int index;
        String name = external.getName();
        if (name == null) {
            name = PythonCodeGenUtils.getPythonQName((NamedElement)external.getBase_Classifier());
        }
        if ((index = (name = name.replace("::", ".")).lastIndexOf(".")) != -1) {
            String from = name.substring(0, index).toLowerCase();
            String shortName = name.substring(index + 1);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("from ");
            _builder.append(from);
            _builder.append(" import ");
            _builder.append(shortName);
            return _builder.toString();
        }
        return "";
    }

    public static NamedElement modulePkg(NamedElement ne) {
        boolean _isApplied = StereotypeUtil.isApplied((Element)ne.getNearestPackage(), Module.class);
        if (_isApplied) {
            return ne.getNearestPackage();
        }
        return ne;
    }
}

