/*******************************************************************************
 * Copyright (c) 2006 - 2015 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     CEA LIST - ansgar.radermacher@cea.fr   initial API and implementation
 *******************************************************************************/

package org.eclipse.papyrus.designer.languages.cpp.codegen;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.CommonLangCodegen;
import org.eclipse.papyrus.designer.languages.common.base.ModelElementsCreator;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangCodegen;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.MethodInfo;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.SyncInformation;
import org.eclipse.papyrus.designer.languages.cpp.codegen.preferences.CppCodeGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.transformation.CppModelElementsCreator;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.LocateCppProject;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;

/**
 * C++ language support
 *
 */
public class CppLangCodegen extends CommonLangCodegen implements ILangCodegen {

	@Override
	public String getDescription() {
		return Messages.C_CppLangCodegen_GeneratorDesc;
	}

	/**
	 * Check whether the code generator is able to produce code for the passed element:
	 * it must be a classifier or package. We dropped the requirement that the C++ profile is applied, since
	 * the user might want to generate code without profile details.
	 */
	@Override
	public boolean isEligible(Element modelElement) {
		if (modelElement instanceof Classifier || modelElement instanceof org.eclipse.uml2.uml.Package) {
			return true;
		}
		return false;
	}

	@Override
	public String getSuffix(FILE_KIND fileKind) {
		if (fileKind == FILE_KIND.BODY) {
			return CppCodeGenUtils.getBodySuffix();
		} else {
			return CppCodeGenUtils.getHeaderSuffix();
		}
	}

	@Override
	public IProject getTargetProject(PackageableElement pe, boolean createIfMissing) {
		return LocateCppProject.getTargetProject(pe, createIfMissing);
	}

	@Override
	protected ModelElementsCreator newCreator(IProject project, PackageableElement pe) {
		return new CppModelElementsCreator(project);
	}

	@Override
	public SyncInformation getSyncInformation(String methodName, String body) {
		return null;
	}

	@Override
	public MethodInfo getMethodInfo(NamedElement operationOrBehavior) {
		MethodInfo mi = new MethodInfo(operationOrBehavior.getName());
		EList<Parameter> parameters = null;
		if (operationOrBehavior instanceof Operation) {
			parameters = ((Operation) operationOrBehavior).getOwnedParameters();
		} else if (operationOrBehavior instanceof Behavior) {
			parameters = ((Behavior) operationOrBehavior).getOwnedParameters();
		}

		if (parameters != null) {
			for (Parameter parameter : parameters) {
				if (parameter.getDirection() != ParameterDirectionKind.RETURN_LITERAL) {
					mi.addParameterType(org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppParameter.CppParameterForCDT(parameter).toString());
				}
			}
		}
		return mi;
	}
}
